/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.fa.service.ICloseBookService;
import nc.pub.fa.asset.manager.UsufructAssetCheckStatusEnum;
import nc.pub.fa.asset.relation.UsufructAssetCalculatorVOManager;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesChangeCalculator;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesCore;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesMiddleChangeRecordByMonth;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculatorCheck;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculatorParams;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.card.AssetFieldConst;
import nc.pub.fa.card.CardTabConst;
import nc.vo.am.common.AMSuperVO;
import nc.vo.am.common.newlease.LiabilityCalcParams;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CloneUtil;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.proxy.AMProxy;
import nc.vo.am.rent.UFDateUtils;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFDate;

public class LeaseLiabilitiesChange {
    private final String pk_card;
    private final AssetEntiretyVO addAssetEntiretyVO;
    private final UsufructAssetViewVO addUsufructVO;
    private final AssetEntiretyVO oldAssetEntiretyVO;
    private final UsufructAssetViewVO oldUsufructVO;
    private final DepAccrualViewVO[] oldDepAccuralVOs;
    private final RentPaymentPlanViewVO[] oldRentPaymentPlanVOs;
    private final Map<String, Object> userjson;
    private final UFDate changeDate;
    private final UFDate changeStartDate;
    private LiabilityCalcParams liabilityCalcParams;
    private Map<String, AccperiodVO> minUnCloseBookPeriods;

    public LeaseLiabilitiesChange(AssetEntiretyVO addAssetEntiretyVO, AssetEntiretyVO oldAssetEntiretyVO, Map<String, Object> userjson) {
        UFDate change_start_date;
        Map map;
        String changeStartDateObj;
        this.addAssetEntiretyVO = addAssetEntiretyVO;
        this.addUsufructVO = addAssetEntiretyVO.getUsufructAssetViewVO();
        this.pk_card = this.addUsufructVO.getPk_card();
        this.oldAssetEntiretyVO = oldAssetEntiretyVO;
        this.oldUsufructVO = oldAssetEntiretyVO.getUsufructAssetViewVO();
        this.oldDepAccuralVOs = (DepAccrualViewVO[])oldAssetEntiretyVO.getTableVO(CardTabConst.depaccrual_tab);
        this.oldRentPaymentPlanVOs = (RentPaymentPlanViewVO[])oldAssetEntiretyVO.getTableVO(CardTabConst.rentpayplan_tab);
        Arrays.sort((Object[])this.oldDepAccuralVOs);
        Arrays.sort((Object[])this.oldRentPaymentPlanVOs);
        this.userjson = userjson;
        this.changeDate = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).getChangeDate();
        this.changeStartDate = userjson.get("change_start_date") != null ? ((changeStartDateObj = (String)(map = (Map)userjson.get("change_start_date")).get("newValue")) != null ? (change_start_date = new UFDate(changeStartDateObj, true)) : null) : null;
    }

    private void configure() throws BusinessException {
        this.liabilityCalcParams = UsufructAssetCalculatorParams.getCalcParams(this.addAssetEntiretyVO);
        List<String> pk_accbooks = Stream.of(this.addAssetEntiretyVO.getCardhistoryVOs()).map(CardhistoryVO::getPk_accbook).collect(Collectors.toList());
        this.minUnCloseBookPeriods = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks.toArray(new String[0]));
    }

    public void calc() throws BusinessException {
        if (this.userjson.size() == 1 && this.userjson.keySet().contains("interest_rate")) {
            this.calc2();
        } else if (this.isHaveChangeStartDate()) {
            this.calc3();
        } else {
            this.calc1();
        }
    }

    private boolean isHaveChangeStartDate() {
        return this.userjson.keySet().contains("rent_way") && this.userjson.keySet().contains("change_start_date") || this.userjson.keySet().contains("step_lease_flag") && this.userjson.keySet().contains("change_start_date") || this.userjson.keySet().contains("steprentStandardData") && this.userjson.keySet().contains("change_start_date") || this.userjson.keySet().contains("rent_standard") && this.userjson.keySet().contains("change_start_date");
    }

    private void calc3() throws BusinessException {
        this.configure();
        PaymentPlanChangeRange changeRange = this.calcChangeRange(null);
        PaymentPlanChangeRange paymentPlanChangeRange = this.calcChangeRange(this.changeStartDate);
        UFDate discountingBeginDate = changeRange.getDiscountingBeginDate();
        LeaseLiabilitiesChangeCalculator leaseLiabilitiesChangeCalculator = new LeaseLiabilitiesChangeCalculator(discountingBeginDate, this.addUsufructVO, this.oldDepAccuralVOs, this.minUnCloseBookPeriods, this.liabilityCalcParams);
        leaseLiabilitiesChangeCalculator.check(discountingBeginDate);
        RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs = paymentPlanChangeRange.getTempOldRentPaymentPlanVOs();
        PayScheduleCalculator payScheduleCalculator = new PayScheduleCalculator(tempOldRentPaymentPlanVOs, this.addAssetEntiretyVO, paymentPlanChangeRange.getDates(), UsufructAssetCheckStatusEnum.LEASE_CHANGE);
        if (this.userjson.keySet().contains("step_lease_flag") || this.userjson.keySet().contains("steprentStandardData")) {
            payScheduleCalculator.setChange_to_step_lease_flag(true);
            payScheduleCalculator.setChange_start_date(this.changeStartDate);
        }
        RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs = payScheduleCalculator.calc();
        DepAccrualViewVO[] mergeDepAccrualViewVOs = null;
        RentPaymentPlanViewVO[] clonedAddRentPaymentPlanViewVOs = (RentPaymentPlanViewVO[])addRentPaymentPlanViewVOs.clone();
        List<RentPaymentPlanViewVO> oldRentPaymentPlanViewVOs = Stream.of(tempOldRentPaymentPlanVOs).filter(vo -> vo.getStart_date().beforeDate(discountingBeginDate) || vo.getStart_date().isSameDate(discountingBeginDate)).filter(vo -> vo.getEnd_date().afterDate(discountingBeginDate) || vo.getEnd_date().isSameDate(discountingBeginDate)).filter(vo -> vo.getEnd_date().beforeDate(clonedAddRentPaymentPlanViewVOs[0].getStart_date())).collect(Collectors.toList());
        List oldRentPaymentPlanViewVOs2 = null;
        if (CollectionUtils.isNotEmpty(oldRentPaymentPlanViewVOs)) {
            oldRentPaymentPlanViewVOs2 = Stream.of(tempOldRentPaymentPlanVOs).filter(vo -> vo.getStart_date().afterDate(((RentPaymentPlanViewVO)((Object)((Object)oldRentPaymentPlanViewVOs.get(0)))).getEnd_date()) || vo.getStart_date().isSameDate(((RentPaymentPlanViewVO)((Object)((Object)oldRentPaymentPlanViewVOs.get(0)))).getEnd_date())).filter(vo -> vo.getEnd_date().beforeDate(clonedAddRentPaymentPlanViewVOs[0].getStart_date()) || vo.getEnd_date().isSameDate(clonedAddRentPaymentPlanViewVOs[0].getStart_date())).collect(Collectors.toList());
        }
        ArrayList<RentPaymentPlanViewVO> calOldRentPaymentPlanVOs = new ArrayList<RentPaymentPlanViewVO>();
        if (CollectionUtils.isNotEmpty(oldRentPaymentPlanViewVOs2)) {
            for (RentPaymentPlanViewVO vo2 : oldRentPaymentPlanViewVOs2) {
                oldRentPaymentPlanViewVOs.add(vo2);
            }
        }
        HashSet<UFDate> startDateSet = new HashSet<UFDate>();
        HashSet<UFDate> endDateSet = new HashSet<UFDate>();
        for (RentPaymentPlanViewVO delvo : oldRentPaymentPlanViewVOs) {
            startDateSet.add(delvo.getStart_date());
            endDateSet.add(delvo.getEnd_date());
        }
        for (RentPaymentPlanViewVO oldvo : tempOldRentPaymentPlanVOs) {
            if (startDateSet.contains(oldvo.getStart_date()) && endDateSet.contains(oldvo.getEnd_date())) continue;
            calOldRentPaymentPlanVOs.add(oldvo);
        }
        for (RentPaymentPlanViewVO vo3 : clonedAddRentPaymentPlanViewVOs) {
            oldRentPaymentPlanViewVOs.add(vo3);
        }
        RentPaymentPlanViewVO[] calRentPaymentPlanViewVOs = oldRentPaymentPlanViewVOs.toArray(new RentPaymentPlanViewVO[0]);
        mergeDepAccrualViewVOs = leaseLiabilitiesChangeCalculator.calc(calRentPaymentPlanViewVOs);
        RentPaymentPlanViewVO[] mergeRentPaymentPlanViewVOs = null;
        LeaseLiabilitiesMiddleChangeRecordByMonth leaseLiabilitiesMiddleChangeRecordByMonth = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).getLeaseLiabilitiesMiddleChangeRecordByMonth();
        mergeRentPaymentPlanViewVOs = leaseLiabilitiesMiddleChangeRecordByMonth != null ? leaseLiabilitiesMiddleChangeRecordByMonth.mergePaymentPlan(calOldRentPaymentPlanVOs.toArray(new RentPaymentPlanViewVO[0]), calRentPaymentPlanViewVOs) : (RentPaymentPlanViewVO[])ArrayUtils.mergeArrays((Object[])calOldRentPaymentPlanVOs.toArray(new RentPaymentPlanViewVO[0]), (Object[])calRentPaymentPlanViewVOs);
        Arrays.sort((Object[])mergeRentPaymentPlanViewVOs);
        this.calcChangeRange(null);
        this.addAssetEntiretyVO.setTabVO(CardTabConst.rentpayplan_tab, (SuperVO[])mergeRentPaymentPlanViewVOs);
        this.addAssetEntiretyVO.setTabVO(CardTabConst.depaccrual_tab, (SuperVO[])mergeDepAccrualViewVOs);
    }

    private void calc1() throws BusinessException {
        this.configure();
        PaymentPlanChangeRange changeRange = this.calcChangeRange(null);
        UFDate discountingBeginDate = changeRange.getDiscountingBeginDate();
        LeaseLiabilitiesChangeCalculator leaseLiabilitiesChangeCalculator = new LeaseLiabilitiesChangeCalculator(discountingBeginDate, this.addUsufructVO, this.oldDepAccuralVOs, this.minUnCloseBookPeriods, this.liabilityCalcParams);
        leaseLiabilitiesChangeCalculator.check(this.changeDate);
        RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs = changeRange.getTempOldRentPaymentPlanVOs();
        PayScheduleCalculator payScheduleCalculator = new PayScheduleCalculator(tempOldRentPaymentPlanVOs, this.addAssetEntiretyVO, changeRange.getDates(), UsufructAssetCheckStatusEnum.LEASE_CHANGE);
        RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs = payScheduleCalculator.calc();
        DepAccrualViewVO[] mergeDepAccrualViewVOs = leaseLiabilitiesChangeCalculator.calc(addRentPaymentPlanViewVOs);
        RentPaymentPlanViewVO[] mergeRentPaymentPlanViewVOs = null;
        LeaseLiabilitiesMiddleChangeRecordByMonth leaseLiabilitiesMiddleChangeRecordByMonth = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).getLeaseLiabilitiesMiddleChangeRecordByMonth();
        mergeRentPaymentPlanViewVOs = leaseLiabilitiesMiddleChangeRecordByMonth != null ? leaseLiabilitiesMiddleChangeRecordByMonth.mergePaymentPlan(tempOldRentPaymentPlanVOs, addRentPaymentPlanViewVOs) : (RentPaymentPlanViewVO[])ArrayUtils.mergeArrays((Object[])tempOldRentPaymentPlanVOs, (Object[])addRentPaymentPlanViewVOs);
        Arrays.sort((Object[])mergeRentPaymentPlanViewVOs);
        this.addAssetEntiretyVO.setTabVO(CardTabConst.rentpayplan_tab, (SuperVO[])mergeRentPaymentPlanViewVOs);
        this.addAssetEntiretyVO.setTabVO(CardTabConst.depaccrual_tab, (SuperVO[])mergeDepAccrualViewVOs);
    }

    private void calc2() throws BusinessException {
        RentPaymentPlanViewVO[] alterRentPaymentPlanViewVOs;
        this.configure();
        RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs = this.oldRentPaymentPlanVOs;
        UFDate discountingBeginDate = null;
        RentPaymentPlanViewVO firstRent = addRentPaymentPlanViewVOs[0];
        if (this.changeDate.beforeDate(firstRent.getStart_date())) {
            discountingBeginDate = firstRent.getStart_date();
            alterRentPaymentPlanViewVOs = addRentPaymentPlanViewVOs;
        } else {
            boolean needCalcPlan = false;
            ArrayList<RentPaymentPlanViewVO> alterPayPlanVOs = new ArrayList<RentPaymentPlanViewVO>();
            for (RentPaymentPlanViewVO pay : addRentPaymentPlanViewVOs) {
                if (PayScheduleCalculateHelper.inPayperiod(this.changeDate, pay)) {
                    needCalcPlan = true;
                    discountingBeginDate = LeaseLiabilitiesCore.discountingBeginDate(this.changeDate, this.oldDepAccuralVOs, this.addUsufructVO);
                    this.allowChangeWhenNotCheckoutWithOther(pay, discountingBeginDate);
                }
                if (!needCalcPlan) continue;
                alterPayPlanVOs.add(pay);
            }
            alterRentPaymentPlanViewVOs = alterPayPlanVOs.toArray(new RentPaymentPlanViewVO[0]);
        }
        for (RentPaymentPlanViewVO rent : alterRentPaymentPlanViewVOs) {
            rent.setTax_rate(this.addUsufructVO.getTax_rate());
        }
        UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.addUsufructVO.getPk_card()).setDiscountingBeginDate(discountingBeginDate);
        LeaseLiabilitiesChangeCalculator leaseLiabilitiesChangeCalculator = new LeaseLiabilitiesChangeCalculator(discountingBeginDate, this.addUsufructVO, this.oldDepAccuralVOs, this.minUnCloseBookPeriods, this.liabilityCalcParams);
        leaseLiabilitiesChangeCalculator.check(this.changeDate);
        DepAccrualViewVO[] mergeDepAccrualViewVOs = leaseLiabilitiesChangeCalculator.calc(alterRentPaymentPlanViewVOs);
        this.addAssetEntiretyVO.setTabVO(CardTabConst.rentpayplan_tab, (SuperVO[])addRentPaymentPlanViewVOs);
        this.addAssetEntiretyVO.setTabVO(CardTabConst.depaccrual_tab, (SuperVO[])mergeDepAccrualViewVOs);
    }

    private PaymentPlanChangeRange calcChangeRange(UFDate change_start_date) throws BusinessException {
        UFDate change_date = this.changeDate;
        if (change_start_date != null) {
            change_date = change_start_date;
        }
        UFDate retrospective_date_old = this.oldUsufructVO.getRetrospective_date();
        UFDate retrospective_date_now = this.addUsufructVO.getRetrospective_date();
        RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs = (RentPaymentPlanViewVO[])this.cloneDeep(RentPaymentPlanViewVO.class, (AMSuperVO[])this.oldRentPaymentPlanVOs);
        UFDate rentstart_date_old = this.oldUsufructVO.getRentstart_date();
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.oldUsufructVO)) {
            rentstart_date_old = UFDateUtils.maxDate((UFDate)rentstart_date_old, (UFDate)retrospective_date_old);
        }
        UFDate starting_date_now = this.addUsufructVO.getStarting_date();
        if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.addUsufructVO)) {
            starting_date_now = UFDateUtils.maxDate((UFDate)starting_date_now, (UFDate)retrospective_date_now);
        }
        UFDate ending_date_now = PayScheduleCalculateHelper.getMaxEndDate(this.addUsufructVO);
        UFDate discountingBeginDate = null;
        Optional<Object> dates = Optional.empty();
        if (change_date.beforeDate(rentstart_date_old)) {
            discountingBeginDate = rentstart_date_old;
            dates = Optional.of(Lists.newArrayList((Object[])new UFDate[]{rentstart_date_old, ending_date_now, starting_date_now}));
            for (RentPaymentPlanViewVO rentPaymentPlanViewVO : tempOldRentPaymentPlanVOs) {
                rentPaymentPlanViewVO.setStatus(3);
            }
        } else {
            boolean needDelAfterPayPlan = false;
            if (change_start_date == null) {
                for (RentPaymentPlanViewVO pay : tempOldRentPaymentPlanVOs) {
                    UFDate start_date = pay.getStart_date();
                    if (PayScheduleCalculateHelper.inPayperiod(change_date, pay)) {
                        discountingBeginDate = LeaseLiabilitiesCore.discountingBeginDate(change_date, this.oldDepAccuralVOs, this.addUsufructVO);
                        LeaseLiabilitiesMiddleChangeRecordByMonth leaseLiabilitiesMiddleChangeRecordByMonth = new LeaseLiabilitiesMiddleChangeRecordByMonth(this.addUsufructVO, pay, this.oldDepAccuralVOs, discountingBeginDate);
                        UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).setLeaseLiabilitiesMiddleChangeRecordByMonth(leaseLiabilitiesMiddleChangeRecordByMonth);
                        if (Sets.intersection((Set)AssetFieldConst.LEASECHANGE_PERIOD_FIELD, this.userjson.keySet()).size() > 0) {
                            this.allowChangeWhenLastCycle(pay, discountingBeginDate);
                        }
                        if (Sets.intersection((Set)AssetFieldConst.LEASECHANGE_NOT_PERIOD_RENT_FIELD, this.userjson.keySet()).size() > 0) {
                            this.allowChangeWhenNotCheckoutWithOther(pay, discountingBeginDate);
                        }
                        if (!dates.isPresent()) {
                            dates = Optional.of(Lists.newArrayList((Object[])new UFDate[]{start_date, ending_date_now, starting_date_now.beforeDate(start_date) ? start_date : starting_date_now}));
                        }
                        needDelAfterPayPlan = true;
                        if (!leaseLiabilitiesMiddleChangeRecordByMonth.isDeleteOldCurrentChangePay()) continue;
                        pay.setStatus(3);
                        continue;
                    }
                    if (!needDelAfterPayPlan) continue;
                    pay.setStatus(3);
                }
            } else {
                boolean flag = true;
                AccperiodVO minAccperiod = this.minUnCloseBookPeriods.get(this.addAssetEntiretyVO.getMainAccbookKey());
                for (RentPaymentPlanViewVO pay : tempOldRentPaymentPlanVOs) {
                    UFDate start_date = pay.getStart_date();
                    if (flag && PayScheduleCalculateHelper.inChangePayperiod(change_date, pay, minAccperiod, this.addUsufructVO)) {
                        flag = false;
                        discountingBeginDate = LeaseLiabilitiesCore.discountingBeginDate(start_date, this.oldDepAccuralVOs, this.addUsufructVO);
                        LeaseLiabilitiesMiddleChangeRecordByMonth leaseLiabilitiesMiddleChangeRecordByMonth = new LeaseLiabilitiesMiddleChangeRecordByMonth(this.addUsufructVO, pay, this.oldDepAccuralVOs, discountingBeginDate);
                        UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).setLeaseLiabilitiesMiddleChangeRecordByMonth(leaseLiabilitiesMiddleChangeRecordByMonth);
                        if (Sets.intersection((Set)AssetFieldConst.LEASECHANGE_PERIOD_FIELD, this.userjson.keySet()).size() > 0) {
                            this.allowChangeWhenLastCycle(pay, discountingBeginDate);
                        }
                        if (Sets.intersection((Set)AssetFieldConst.LEASECHANGE_NOT_PERIOD_RENT_FIELD, this.userjson.keySet()).size() > 0) {
                            this.allowChangeWhenNotCheckoutWithOther(pay, discountingBeginDate);
                        }
                        if (!dates.isPresent()) {
                            dates = Optional.of(Lists.newArrayList((Object[])new UFDate[]{start_date, ending_date_now, starting_date_now.beforeDate(start_date) ? start_date : starting_date_now}));
                        }
                        needDelAfterPayPlan = true;
                        if (!leaseLiabilitiesMiddleChangeRecordByMonth.isDeleteOldCurrentChangePay()) continue;
                        pay.setStatus(3);
                        continue;
                    }
                    if (!needDelAfterPayPlan) continue;
                    pay.setStatus(3);
                }
                if (!dates.isPresent()) {
                    throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0912", null, new String[]{change_date.toStdString()}));
                }
            }
        }
        if (!dates.isPresent()) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0812"));
        }
        UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).setDiscountingBeginDate(discountingBeginDate);
        return new PaymentPlanChangeRange(tempOldRentPaymentPlanVOs, (List)dates.get(), discountingBeginDate);
    }

    private <T extends AMSuperVO> T[] cloneDeep(Class<T> clazz, T[] in) throws BusinessException {
        AMSuperVO[] ret = (AMSuperVO[])Array.newInstance(clazz, in.length);
        for (int i = 0; i < in.length; ++i) {
            ret[i] = (AMSuperVO)CloneUtil.clone(in[i]);
        }
        return ret;
    }

    private void allowChangeWhenLastCycle(RentPaymentPlanViewVO pay, UFDate discountingBeginDate) throws BusinessException {
        UFDate start_date = pay.getStart_date();
        UFDate end_date = pay.getEnd_date();
        UFDate old_ending_date = PayScheduleCalculateHelper.getMaxEndDate(this.oldUsufructVO);
        UFDate add_ending_date = PayScheduleCalculateHelper.getMaxEndDate(this.addUsufructVO);
        if (!UsufructAssetCalculatorCheck.isFullPeriod(start_date, end_date, this.addUsufructVO) || !UsufructAssetCalculatorCheck.isFullPeriod(start_date, add_ending_date, this.addUsufructVO)) {
            if (old_ending_date.beforeDate(discountingBeginDate) || add_ending_date.beforeDate(discountingBeginDate)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0786", null, new String[]{this.changeDate.toLocalString(), start_date.toLocalString(), end_date.toLocalString()}));
            }
        } else {
            if (add_ending_date.beforeDate(old_ending_date) && old_ending_date.beforeDate(discountingBeginDate)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0791", null, new String[]{this.changeDate.toLocalString(), start_date.toLocalString(), add_ending_date.toLocalString()}));
            }
            if (old_ending_date.beforeDate(add_ending_date) && add_ending_date.beforeDate(discountingBeginDate)) {
                throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0791", null, new String[]{this.changeDate.toLocalString(), start_date.toLocalString(), add_ending_date.toLocalString()}));
            }
        }
    }

    private void allowChangeWhenNotCheckoutWithOther(RentPaymentPlanViewVO pay, UFDate discountingBeginDate) throws BusinessException {
        UFDate start_date = pay.getStart_date();
        UFDate end_date = pay.getEnd_date();
        UFDate old_ending_date = PayScheduleCalculateHelper.getMaxEndDate(this.oldUsufructVO);
        UFDate add_ending_date = PayScheduleCalculateHelper.getMaxEndDate(this.addUsufructVO);
        if (old_ending_date.beforeDate(discountingBeginDate) || add_ending_date.beforeDate(discountingBeginDate)) {
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0786", null, new String[]{this.changeDate.toLocalString(), start_date.toLocalString(), end_date.toLocalString()}));
        }
    }

    public LiabilityCalcParams getLiabilityCalcParams() {
        return this.liabilityCalcParams;
    }

    private class PaymentPlanChangeRange {
        private RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs;
        private List<UFDate> dates;
        private UFDate discountingBeginDate;

        public PaymentPlanChangeRange(RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs, List<UFDate> dates, UFDate discountingBeginDate) {
            this.tempOldRentPaymentPlanVOs = tempOldRentPaymentPlanVOs;
            this.dates = dates;
            this.discountingBeginDate = discountingBeginDate;
        }

        public RentPaymentPlanViewVO[] getTempOldRentPaymentPlanVOs() {
            return this.tempOldRentPaymentPlanVOs;
        }

        public void setTempOldRentPaymentPlanVOs(RentPaymentPlanViewVO[] tempOldRentPaymentPlanVOs) {
            this.tempOldRentPaymentPlanVOs = tempOldRentPaymentPlanVOs;
        }

        public List<UFDate> getDates() {
            return this.dates;
        }

        public void setDates(List<UFDate> dates) {
            this.dates = dates;
        }

        public UFDate getDiscountingBeginDate() {
            return this.discountingBeginDate;
        }

        public void setDiscountingBeginDate(UFDate discountingBeginDate) {
            this.discountingBeginDate = discountingBeginDate;
        }
    }
}

