/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.fa.prv.IAsset;
import nc.itf.fa.service.ICloseBookService;
import nc.pub.fa.asset.manager.UsufructAssetCheckStatusEnum;
import nc.pub.fa.asset.relation.UsufructAssetCalculatorVOManager;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesChangeCalculator;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesCore;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesMiddleChangeRecordByMonth;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.card.CardTabConst;
import nc.vo.am.common.newlease.LiabilityCalcParams;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFDate;

public class ContractPushFACalculator {
    private final AssetEntiretyVO addAssetEntity;
    private final AssetEntiretyVO oldAssetEntity;
    private final UFDate changeDate;
    private final String pk_card;
    private final LiabilityCalcParams liabilityCalcParams;
    private Map<String, AccperiodVO> minUnCloseBookPeriods;

    public ContractPushFACalculator(AssetEntiretyVO addAssetEntity, AssetEntiretyVO oldAssetEntity, UFDate changeDate, LiabilityCalcParams liabilityCalcParams) {
        this.addAssetEntity = addAssetEntity;
        this.oldAssetEntity = oldAssetEntity;
        this.changeDate = changeDate;
        this.pk_card = addAssetEntity.getCardVO().getPk_card();
        this.liabilityCalcParams = liabilityCalcParams;
    }

    private void configure() throws BusinessException {
        List<String> pk_accbooks = Stream.of(this.addAssetEntity.getCardhistoryVOs()).map(CardhistoryVO::getPk_accbook).collect(Collectors.toList());
        this.minUnCloseBookPeriods = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks.toArray(new String[0]));
    }

    public void calc() throws BusinessException {
        this.configure();
        this.calDepAccrual();
        this.writeback();
    }

    private void calDepAccrual() throws BusinessException {
        RentPaymentPlanViewVO[] alterRentPaymentPlanViewVOs;
        UsufructAssetViewVO addUsufructVO = this.addAssetEntity.getUsufructAssetViewVO();
        DepAccrualViewVO[] oldDepAccuralVOs = (DepAccrualViewVO[])this.oldAssetEntity.getTabVO(CardTabConst.depaccrual_tab);
        RentPaymentPlanViewVO[] oldRentPaymentPlanViewVOs = (RentPaymentPlanViewVO[])this.oldAssetEntity.getTabVO(CardTabConst.rentpayplan_tab);
        RentPaymentPlanViewVO[] addRentPaymentPlanViewVOs = (RentPaymentPlanViewVO[])this.addAssetEntity.getTabVO(CardTabConst.rentpayplan_tab);
        Arrays.sort((Object[])oldDepAccuralVOs);
        Arrays.sort((Object[])addRentPaymentPlanViewVOs);
        Arrays.stream(addRentPaymentPlanViewVOs).forEach(planVo -> {
            for (RentPaymentPlanViewVO oldPlanVo : oldRentPaymentPlanViewVOs) {
                if (!planVo.getStart_date().isSameDate(oldPlanVo.getStart_date()) || !planVo.getEnd_date().isSameDate(oldPlanVo.getEnd_date())) continue;
                planVo.setTax_deductible(oldPlanVo.getTax_deductible());
                planVo.setTax_rate(oldPlanVo.getTax_rate());
                break;
            }
        });
        UFDate discountingBeginDate = null;
        RentPaymentPlanViewVO firstRent = addRentPaymentPlanViewVOs[0];
        if (this.changeDate.beforeDate(firstRent.getStart_date())) {
            discountingBeginDate = firstRent.getStart_date();
            alterRentPaymentPlanViewVOs = addRentPaymentPlanViewVOs;
        } else {
            boolean needCalcPlan = false;
            ArrayList<RentPaymentPlanViewVO> alterPayPlanVOs = new ArrayList<RentPaymentPlanViewVO>();
            for (RentPaymentPlanViewVO plan : addRentPaymentPlanViewVOs) {
                if (PayScheduleCalculateHelper.inPayperiod(this.changeDate, plan)) {
                    needCalcPlan = true;
                    discountingBeginDate = LeaseLiabilitiesCore.discountingBeginDate(this.changeDate, oldDepAccuralVOs, addUsufructVO);
                    LeaseLiabilitiesMiddleChangeRecordByMonth leaseLiabilitiesMiddleChangeRecordByMonth = new LeaseLiabilitiesMiddleChangeRecordByMonth(addUsufructVO, plan, oldDepAccuralVOs, discountingBeginDate);
                    UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).setLeaseLiabilitiesMiddleChangeRecordByMonth(leaseLiabilitiesMiddleChangeRecordByMonth);
                }
                if (!needCalcPlan) continue;
                alterPayPlanVOs.add(plan);
            }
            alterRentPaymentPlanViewVOs = alterPayPlanVOs.toArray(new RentPaymentPlanViewVO[0]);
        }
        if (discountingBeginDate == null) {
            throw ExceptionUtils.businessRuntimeException((String)"\u6298\u73b0\u5f00\u59cb\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01\u53ef\u80fd\u662f\u56e0\u4e3a\u53d8\u66f4\u65e5\u671f\u5728\u6b62\u79df\u65e5\u671f\u4e4b\u540e\u3002");
        }
        for (RentPaymentPlanViewVO rent : alterRentPaymentPlanViewVOs) {
            rent.setTax_rate(addUsufructVO.getTax_rate());
            rent.setTax_deductible(addUsufructVO.getTax_deductible());
        }
        UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).setDiscountingBeginDate(discountingBeginDate);
        LeaseLiabilitiesChangeCalculator leaseLiabilitiesChangeCalculator = new LeaseLiabilitiesChangeCalculator(discountingBeginDate, addUsufructVO, oldDepAccuralVOs, this.minUnCloseBookPeriods, this.liabilityCalcParams);
        leaseLiabilitiesChangeCalculator.check(this.changeDate);
        DepAccrualViewVO[] mergeDepAccrualViewVOs = leaseLiabilitiesChangeCalculator.calc(alterRentPaymentPlanViewVOs);
        this.addAssetEntity.setTabVO(CardTabConst.depaccrual_tab, (SuperVO[])mergeDepAccrualViewVOs);
    }

    private void writeback() throws BusinessException {
        ((IAsset)AMProxy.lookup(IAsset.class)).writeBackUsufructAsset(this.addAssetEntity, this.liabilityCalcParams, UsufructAssetCheckStatusEnum.LEASE_CHANGE);
    }
}

