/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.util.usufruct;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import nc.bs.pf.pub.PfDataCache;
import nc.itf.fa.service.IAccbookInfoService;
import nc.pub.fa.asset.manager.AccbookRelatCategoryUtil;
import nc.pub.fa.asset.relation.BeginLiabilityEnum;
import nc.pub.fa.asset.relation.UsufructAssetCalculatorVOManager;
import nc.pub.fa.asset.util.usufruct.LeaseLiabilitiesMiddleChangeRecordByMonth;
import nc.pub.fa.asset.util.usufruct.PayScheduleCalculateHelper;
import nc.pub.fa.asset.util.usufruct.UsufructAssetCalculator;
import nc.pub.fa.asset.util.usufruct.UsufructAssetEnumJudge;
import nc.pub.fa.card.AssetDateCalUtils;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.CardVOUtils;
import nc.pub.fa.common.util.FAScaleUtils;
import nc.vo.am.common.BizContext;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.common.util.UFDoubleUtils;
import nc.vo.am.manager.AccbookManager;
import nc.vo.am.manager.CurrencyRateManager;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.am.scale.query.IDigitQueryVar;
import nc.vo.am.scale.query.ScaleObjFactory;
import nc.vo.am.scale.query.ScaleUtils;
import nc.vo.bd.currinfo.CurrinfoVO;
import nc.vo.bd.rate.util.RateReturnObject;
import nc.vo.fa.accbookinfo.AccbookBodyVO;
import nc.vo.fa.accbookinfo.AccbookHeadVO;
import nc.vo.fa.accbookinfo.ConvertData;
import nc.vo.fa.alter.AlterBodyVO;
import nc.vo.fa.alter.AlterHeadVO;
import nc.vo.fa.alter.AlterVO;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.asset.DepAccrualViewVO;
import nc.vo.fa.asset.RentPaymentPlanViewVO;
import nc.vo.fa.asset.RentTypeEnum;
import nc.vo.fa.asset.UsufructAssetViewVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.fa.assetcard.UsufructAssetVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.ISuperVO;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nc.vo.tmpub.ia.util.NatureDateTools;

public class AssetToAlterGenerator {
    private final AssetEntiretyVO oldAssetEntiretyVO;
    private final AssetEntiretyVO addAssetEntiretyVO;
    private final String pk_accbook;
    private final String pk_bill_src;
    private final CardhistoryVO cardhistoryVO;
    private final UsufructAssetViewVO addUsufructVO;
    private final UFDate change_date;
    private final CardVO addCardVO;
    private final BizContext bizContext;
    private final String pk_card;
    private final UsufructAssetViewVO oldUsufructVO;
    private final RentPaymentPlanViewVO[] oldPlanVOs;
    private final RentPaymentPlanViewVO[] addPlanVOs;
    private final UFDate discountingBeginDate;
    private static UFDate changeCalculationDate;

    public AssetToAlterGenerator(AssetEntiretyVO oldAssetEntiretyVO, AssetEntiretyVO addAssetEntiretyVO, String pk_accbook, String pk_bill_src) {
        this.oldAssetEntiretyVO = oldAssetEntiretyVO;
        this.oldUsufructVO = oldAssetEntiretyVO.getUsufructAssetViewVO();
        this.addAssetEntiretyVO = addAssetEntiretyVO;
        this.addUsufructVO = addAssetEntiretyVO.getUsufructAssetViewVO();
        this.change_date = this.addUsufructVO.getChange_date();
        this.pk_accbook = pk_accbook;
        this.pk_bill_src = pk_bill_src;
        this.cardhistoryVO = addAssetEntiretyVO.getCardhistoryVO(pk_accbook);
        this.addCardVO = addAssetEntiretyVO.getCardVO();
        this.bizContext = BizContext.getInstance();
        this.pk_card = this.addCardVO.getPk_card();
        this.oldPlanVOs = (RentPaymentPlanViewVO[])oldAssetEntiretyVO.getTableVO(CardTabConst.rentpayplan_tab);
        this.addPlanVOs = (RentPaymentPlanViewVO[])addAssetEntiretyVO.getTableVO(CardTabConst.rentpayplan_tab);
        Arrays.sort((Object[])this.oldPlanVOs);
        Arrays.sort((Object[])this.addPlanVOs);
        changeCalculationDate = null;
        this.discountingBeginDate = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(this.pk_card).getDiscountingBeginDate();
    }

    public AlterVO createAlterVOForNaturemonth() throws BusinessException {
        AlterVO alterVO = this.createAlterVO();
        SuccessAlter status = this.appendNaturemonth(alterVO);
        if (SuccessAlter.FAIL == status) {
            return null;
        }
        if (SuccessAlter.NONE == status) {
            return AlterVO.NONE_INSTANCE;
        }
        return alterVO;
    }

    public AlterVO createAlterVOForOriginvalue() throws BusinessException {
        AlterVO alterVO = this.createAlterVO();
        SuccessAlter status = this.appendOriginValue(alterVO);
        if (SuccessAlter.FAIL == status) {
            return null;
        }
        return alterVO;
    }

    private AlterVO createAlterVO() {
        AlterVO alterVO = new AlterVO();
        AlterHeadVO headVO = this.createAlterHeadVO();
        AlterBodyVO[] bodyVOs = this.createAlterBodyVOs();
        alterVO.setParent((ISuperVO)headVO);
        alterVO.setChildrenVO((CircularlyAccessibleValueObject[])bodyVOs);
        return alterVO;
    }

    private AlterHeadVO createAlterHeadVO() {
        AlterHeadVO headVO = new AlterHeadVO();
        headVO.setPk_accbook("~");
        headVO.setBusiness_date(this.change_date);
        headVO.setTransi_type("HG-00");
        headVO.setPk_group(this.addCardVO.getPk_group());
        headVO.setPk_org(this.addCardVO.getPk_org());
        headVO.setPk_org_v(this.addCardVO.getPk_org_v());
        headVO.setBill_type("HG");
        headVO.setTransi_type_src(this.addCardVO.getTransi_type());
        headVO.setBill_type_src(this.addCardVO.getBill_type());
        headVO.setPk_transitype_src(this.addCardVO.getPk_transitype());
        headVO.setBill_status(Integer.valueOf(0));
        headVO.setBillmaker(this.bizContext.getUserId());
        headVO.setBillmaketime(this.bizContext.getBizDateTime());
        headVO.setStatus(2);
        headVO.setPk_bill_src(this.pk_bill_src);
        BilltypeVO billtypeVO = PfDataCache.getBillTypeInfo((String)headVO.getPk_group(), (String)headVO.getTransi_type());
        headVO.setPk_transitype(billtypeVO.getPk_billtypeid());
        return headVO;
    }

    private AlterBodyVO[] createAlterBodyVOs() {
        CardVO cardVO = this.addAssetEntiretyVO.getCardVO();
        AlterBodyVO[] alterBodyVO = new AlterBodyVO[]{new AlterBodyVO()};
        AlterBodyVO bodyVO = alterBodyVO[0];
        bodyVO.setPk_group(cardVO.getPk_group());
        bodyVO.setPk_org(cardVO.getPk_org());
        bodyVO.setPk_org_v(cardVO.getPk_org_v());
        bodyVO.setPk_card(cardVO.getPk_card());
        bodyVO.setPk_bill_src(this.pk_bill_src);
        bodyVO.setPk_accbook("~");
        return alterBodyVO;
    }

    private SuccessAlter appendOriginValue(AlterVO alterVO) throws BusinessException {
        AlterHeadVO headVO = alterVO.getParentVO();
        String pk_currency = this.addCardVO.getPk_currency();
        AlterBodyVO bodyVO = (AlterBodyVO)alterVO.getChildrenVO()[0];
        UFDouble beginLiability_before = UsufructAssetCalculator.getBeginLiability(BeginLiabilityEnum.OLD, this.pk_card);
        UFDouble beginLiability_after = UsufructAssetCalculator.getBeginLiability(BeginLiabilityEnum.NEW, this.pk_card);
        UFDouble alterLiability = UFDoubleUtils.sub((UFDouble)beginLiability_after, (UFDouble)beginLiability_before);
        bodyVO.setAttributeValue("liabilityalter_before", (Object)ScaleUtils.setScaleByCurrType((UFDouble)beginLiability_before, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("liabilityalter_alter", (Object)ScaleUtils.setScaleByCurrType((UFDouble)alterLiability, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("liabilityalter_after", (Object)ScaleUtils.setScaleByCurrType((UFDouble)beginLiability_after, (String)pk_currency, (boolean)false));
        alterVO.getShowAlterKeyList().add("liabilityalter");
        UFDouble alterRentnotax = AssetToAlterGenerator.calcAlterRent(this.addUsufructVO, this.addPlanVOs, this.oldPlanVOs, this.discountingBeginDate);
        UFDouble alterExpect = this.calcAlterExpectLiabilities();
        alterLiability = UFDoubleUtils.add((UFDouble[])new UFDouble[]{alterLiability, alterRentnotax, alterExpect});
        UFDouble originvalue = this.cardhistoryVO.getOriginvalue();
        bodyVO.setAttributeValue("expectoriginal_before", (Object)ScaleUtils.setScaleByCurrType((UFDouble)originvalue, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("expectoriginal_alter", (Object)ScaleUtils.setScaleByCurrType((UFDouble)alterLiability, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("expectoriginal_after", (Object)ScaleUtils.setScaleByCurrType((UFDouble)UFDoubleUtils.add((UFDouble)originvalue, (UFDouble)alterLiability), (String)pk_currency, (boolean)false));
        alterVO.getShowAlterKeyList().add("expectoriginal");
        bodyVO.setPk_currency(pk_currency);
        CardhistoryVO[] historyvos = this.oldAssetEntiretyVO.getCardhistoryVOs();
        CardVO cardvo = this.oldAssetEntiretyVO.getCardVO();
        boolean isUsufruct = UFBoolean.TRUE.equals((Object)cardvo.getUsufructasset_flag());
        for (CardhistoryVO hisvo : historyvos) {
            String pk_accbook2 = hisvo.getPk_accbook();
            AccbookHeadVO accbookHeadVO = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryAccbookHeadVOByAccbook(pk_accbook2);
            int convertInt = accbookHeadVO.getConvert_date();
            UFDate convertDate = null;
            UFDouble localcurr_rate = UFDouble.ZERO_DBL;
            if (ConvertData.CARD_CREATE_DATA.value().equals(convertInt)) {
                localcurr_rate = hisvo.getLocalcurr_rate();
            } else {
                String destCurrencyPk = AccbookManager.queryCurrTypeByAccbook((String)this.pk_accbook);
                if (destCurrencyPk.equals(pk_currency)) {
                    localcurr_rate = UFDouble.ONE_DBL;
                } else {
                    RateReturnObject rateReturnObject = CurrencyRateManager.getRateByAccbook((String)this.pk_accbook, (String)pk_currency, (UFDate)headVO.getBusiness_date());
                    if (rateReturnObject != null) {
                        localcurr_rate = rateReturnObject.getRate();
                        hisvo.setRate_date_src(rateReturnObject.getDate());
                        hisvo.setPk_ratetype(rateReturnObject.getPk_ratetype());
                    }
                }
                convertDate = alterVO.getParentVO().getBusiness_date();
            }
            HashBasedTable<Boolean, String, String> categoryFromLocalvage = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryAllLocaloriginvalue(cardvo.getPk_org(), new String[]{hisvo.getPk_category()}, pk_accbook2);
            String fromKey = (String)categoryFromLocalvage.get((Object)isUsufruct, (Object)hisvo.getPk_category());
            if (StringUtils.isBlank((CharSequence)fromKey)) continue;
            alterLiability = ScaleUtils.setScaleByCurrType((UFDouble)alterLiability, (String)pk_currency, (boolean)false);
            UFDouble alterLocalValue = CurrencyRateManager.getAccbookAmountByOpp((String)pk_accbook2, (String)cardvo.getPk_currency(), (UFDouble)alterLiability, (UFDouble)localcurr_rate, (UFDate)convertDate, (String)hisvo.getPk_ratetype());
            String pk_accbookcurrtype = AccbookManager.queryCurrTypeByAccbook((String)pk_accbook2);
            UFDouble localValueAfter = UFDoubleUtils.add((UFDouble)hisvo.getLocaloriginvalue(), (UFDouble)alterLocalValue);
            UFDouble salvageAfter = ScaleUtils.setScaleByCurrType((UFDouble)UFDoubleUtils.multiply((UFDouble)localValueAfter, (UFDouble)hisvo.getSalvagerate()), (String)pk_accbookcurrtype, (boolean)false);
            UFDouble netvalueAfter = UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)localValueAfter, (UFDouble)hisvo.getAccudep()), (UFDouble)hisvo.getPredevaluate());
            if (!UFDoubleUtils.isLessThan((UFDouble)netvalueAfter, (UFDouble)salvageAfter)) continue;
            UFDouble maxLocalAlterValue = UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)UFDoubleUtils.sub((UFDouble)hisvo.getLocaloriginvalue(), (UFDouble)hisvo.getAccudep()), (UFDouble)hisvo.getPredevaluate()), (UFDouble)hisvo.getSalvage());
            UFDouble maxOriginAlterValue = UFDouble.ZERO_DBL;
            if (UFDoubleUtils.notNullAndNotZero((UFDouble)localcurr_rate)) {
                CurrinfoVO currinfo = CurrencyRateManager.getCurrinfoVOByAccbook((String)this.pk_accbook, (String)pk_currency);
                Integer convmode = currinfo.getConvmode();
                maxOriginAlterValue = convmode == -1 ? UFDouble.ZERO_DBL : (convmode == 0 ? UFDoubleUtils.sub((UFDouble)UFDouble.ZERO_DBL, (UFDouble)UFDoubleUtils.div((UFDouble)maxLocalAlterValue, (UFDouble)localcurr_rate)) : UFDoubleUtils.sub((UFDouble)UFDouble.ZERO_DBL, (UFDouble)UFDoubleUtils.multiply((UFDouble)maxLocalAlterValue, (UFDouble)localcurr_rate)));
            }
            if (!UFDoubleUtils.isLessThan((UFDouble)maxOriginAlterValue.abs(), (UFDouble)alterLiability.abs())) continue;
            IDigitQueryVar digitQuery = new ScaleObjFactory().getCurrTypeScaleObj();
            int digit = digitQuery.getDigit((Object)pk_currency, false);
            alterLiability = ScaleUtils.setScale((UFDouble)maxOriginAlterValue, (int)digit, (int)1);
        }
        if (UFDouble.ZERO_DBL.equals((Object)alterLiability)) {
            return SuccessAlter.FAIL;
        }
        UFDouble addOriginvalue = UFDoubleUtils.add((UFDouble)originvalue, (UFDouble)alterLiability);
        bodyVO.setAttributeValue("originvalue_before", (Object)ScaleUtils.setScaleByCurrType((UFDouble)originvalue, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("originvalue_alter", (Object)ScaleUtils.setScaleByCurrType((UFDouble)alterLiability, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("originvalue_after", (Object)ScaleUtils.setScaleByCurrType((UFDouble)addOriginvalue, (String)pk_currency, (boolean)false));
        alterVO.getShowAlterKeyList().add("originvalue");
        this.appendAmountAlter(alterVO);
        this.appendTotalInterest(alterVO);
        this.appendTaxDeductible(alterVO);
        this.appendTaxRate(alterVO);
        return SuccessAlter.SUCCESS;
    }

    private void appendTaxRate(AlterVO alterVO) {
        UFDouble tax_rate_new;
        AlterBodyVO bodyVO = (AlterBodyVO)alterVO.getChildrenVO()[0];
        UFDouble tax_rate_old = this.oldUsufructVO.getTax_rate();
        if (!UFDoubleUtils.isEqual((UFDouble)tax_rate_old, (UFDouble)(tax_rate_new = this.addUsufructVO.getTax_rate()))) {
            bodyVO.setAttributeValue("tax_rate_before", (Object)tax_rate_old);
            bodyVO.setAttributeValue("tax_rate_after", (Object)tax_rate_new);
            List showAlterKeyList = alterVO.getShowAlterKeyList();
            showAlterKeyList.add("tax_rate");
        }
    }

    private void appendTaxDeductible(AlterVO alterVO) {
        AlterBodyVO bodyVO = (AlterBodyVO)alterVO.getChildrenVO()[0];
        UFBoolean tax_deductible_old = this.oldUsufructVO.getTax_deductible();
        UFBoolean tax_deductible_new = this.addUsufructVO.getTax_deductible();
        if (tax_deductible_old != null && tax_deductible_new != null && tax_deductible_old.compareTo((Object)tax_deductible_new) != 0) {
            bodyVO.setAttributeValue("tax_deductible_before", (Object)tax_deductible_old);
            bodyVO.setAttributeValue("tax_deductible_after", (Object)tax_deductible_new);
            List showAlterKeyList = alterVO.getShowAlterKeyList();
            showAlterKeyList.add("tax_deductible");
        }
    }

    private void appendTotalInterest(AlterVO alterVO) {
        AlterBodyVO bodyVO = (AlterBodyVO)alterVO.getChildrenVO()[0];
        String pk_currtype = this.addAssetEntiretyVO.getCardVO().getPk_currency();
        UFDouble alter = this.addUsufructVO.getTotal_interest().sub(this.oldUsufructVO.getTotal_interest());
        if (UFDoubleUtils.isEqual((UFDouble)alter, (UFDouble)UFDouble.ZERO_DBL)) {
            return;
        }
        UFDouble total_interest_before = FAScaleUtils.setScaleByCurrType((UFDouble)this.oldUsufructVO.getTotal_interest(), (String)pk_currtype, (boolean)false);
        UFDouble total_interest_alter = FAScaleUtils.setScaleByCurrType((UFDouble)alter, (String)pk_currtype, (boolean)false);
        UFDouble total_interest_after = FAScaleUtils.setScaleByCurrType((UFDouble)this.addUsufructVO.getTotal_interest(), (String)pk_currtype, (boolean)false);
        bodyVO.setAttributeValue("total_interest_before", (Object)total_interest_before);
        bodyVO.setAttributeValue("total_interest_alter", (Object)total_interest_alter);
        bodyVO.setAttributeValue("total_interest_after", (Object)total_interest_after);
        List showAlterKeyList = alterVO.getShowAlterKeyList();
        showAlterKeyList.add("total_interest");
    }

    private UFDouble calcAlterExpectLiabilities() {
        return UFDoubleUtils.sub((UFDouble)this.addUsufructVO.getExpect_liabilities(), (UFDouble)this.oldUsufructVO.getExpect_liabilities());
    }

    public static UFDouble calcAlterRent(UsufructAssetViewVO addUsufructVO, RentPaymentPlanViewVO[] addPlanVOs, RentPaymentPlanViewVO[] oldPlanVOs, UFDate discountingBeginDate) {
        boolean isCalcDepAccruaInNext;
        if (changeCalculationDate != null) {
            discountingBeginDate = changeCalculationDate;
        }
        UFDate realDiscountingBeginDate = discountingBeginDate;
        if (addUsufructVO.getAttributeValue("#RentDiff#") != null) {
            return (UFDouble)addUsufructVO.getAttributeValue("#RentDiff#");
        }
        boolean tax_deductible = UFBoolean.TRUE.equals((Object)addUsufructVO.getTax_deductible());
        UFDouble calculate_rent_sum_before = Stream.of(oldPlanVOs).filter(vo -> vo.getEnd_date().beforeDate(realDiscountingBeginDate)).map(vo -> tax_deductible ? vo.getCalculate_rentnotax() : vo.getCalculate_renttax()).reduce(UFDoubleUtils::add).orElse(UFDouble.ZERO_DBL);
        UFDouble calculate_rent_sum_after = Stream.of(addPlanVOs).filter(vo -> 3 != vo.getStatus()).filter(vo -> vo.getEnd_date().beforeDate(realDiscountingBeginDate)).map(vo -> tax_deductible ? vo.getCalculate_rentnotax() : vo.getCalculate_renttax()).reduce(UFDoubleUtils::add).orElse(UFDouble.ZERO_DBL);
        UFDouble sub1 = UFDoubleUtils.sub((UFDouble)calculate_rent_sum_after, (UFDouble)calculate_rent_sum_before);
        if (!UsufructAssetEnumJudge.isPaymentTypeEnumPayment_before(addUsufructVO)) {
            return sub1;
        }
        LeaseLiabilitiesMiddleChangeRecordByMonth leaseLiabilitiesMiddleChangeRecordByMonth = UsufructAssetCalculatorVOManager.getUsufructAssetCalculatorVO(addUsufructVO.getPk_card()).getLeaseLiabilitiesMiddleChangeRecordByMonth();
        boolean isMiddleChange = leaseLiabilitiesMiddleChangeRecordByMonth != null && leaseLiabilitiesMiddleChangeRecordByMonth.isMiddleChange();
        boolean bl = isCalcDepAccruaInNext = leaseLiabilitiesMiddleChangeRecordByMonth != null && leaseLiabilitiesMiddleChangeRecordByMonth.isCalcDepAccruaInNext();
        if (UsufructAssetEnumJudge.isPeriodRulePrefirst(addUsufructVO) && isMiddleChange && isCalcDepAccruaInNext) {
            return sub1;
        }
        if (UsufructAssetEnumJudge.isPeriodRulePrefirst(addUsufructVO) && !isMiddleChange) {
            return sub1;
        }
        UFDouble calculate_rent_curr_sum_before = Stream.of(oldPlanVOs).filter(vo -> vo.getAmount_type().intValue() == RentTypeEnum.rent_default.toIntValue()).filter(vo -> vo.getStart_date().beforeDate(realDiscountingBeginDate) || vo.getStart_date().isSameDate(realDiscountingBeginDate)).filter(vo -> realDiscountingBeginDate.beforeDate(vo.getEnd_date()) || realDiscountingBeginDate.isSameDate(vo.getEnd_date())).filter(vo -> !UsufructAssetEnumJudge.isPeriodRulePrefirst(addUsufructVO) || !UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(addUsufructVO) || !vo.getStart_date().isSameDate(realDiscountingBeginDate)).map(vo -> tax_deductible ? vo.getCalculate_rentnotax() : vo.getCalculate_renttax()).reduce(UFDoubleUtils::add).orElse(UFDouble.ZERO_DBL);
        UFDouble calculate_rent_curr_sum_after = Stream.of(addPlanVOs).filter(vo -> vo.getAmount_type().intValue() == RentTypeEnum.rent_default.toIntValue()).filter(vo -> 3 != vo.getStatus()).filter(vo -> vo.getStart_date().beforeDate(realDiscountingBeginDate) || vo.getStart_date().isSameDate(realDiscountingBeginDate)).filter(vo -> realDiscountingBeginDate.beforeDate(vo.getEnd_date()) || realDiscountingBeginDate.isSameDate(vo.getEnd_date())).filter(vo -> !UsufructAssetEnumJudge.isPeriodRulePrefirst(addUsufructVO) || !UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(addUsufructVO) || !vo.getStart_date().isSameDate(realDiscountingBeginDate)).map(vo -> tax_deductible ? vo.getCalculate_rentnotax() : vo.getCalculate_renttax()).reduce(UFDoubleUtils::add).orElse(UFDouble.ZERO_DBL);
        UFDouble sub2 = UFDoubleUtils.sub((UFDouble)calculate_rent_curr_sum_after, (UFDouble)calculate_rent_curr_sum_before);
        return UFDoubleUtils.add((UFDouble)sub1, (UFDouble)sub2);
    }

    private void appendAmountAlter(AlterVO alterVO) throws BusinessException {
        CardVO cardVO = this.addAssetEntiretyVO.getCardVO();
        String pk_currency = cardVO.getPk_currency();
        DepAccrualViewVO[] oldDeps = (DepAccrualViewVO[])this.oldAssetEntiretyVO.getTableVO(CardTabConst.depaccrual_tab);
        DepAccrualViewVO[] addDeps = (DepAccrualViewVO[])this.addAssetEntiretyVO.getTableVO(CardTabConst.depaccrual_tab);
        boolean discountModeDay365OrDay360 = UsufructAssetEnumJudge.isDiscountModeDay365OrDay360(this.addAssetEntiretyVO.getUsufructAssetViewVO());
        ArrayList beforeList = Lists.newArrayList();
        for (int i = 0; i < oldDeps.length; ++i) {
            beforeList.add(oldDeps[i].getCalc_cash());
        }
        UFDouble rentAlter_before = UFDoubleUtils.add((UFDouble[])beforeList.toArray(new UFDouble[0]));
        rentAlter_before = discountModeDay365OrDay360 ? rentAlter_before.div(2.0) : rentAlter_before;
        ArrayList afterList = Lists.newArrayList();
        for (int i = 0; i < addDeps.length; ++i) {
            if (3 == addDeps[i].getStatus()) continue;
            afterList.add(addDeps[i].getCalc_cash());
        }
        UFDouble rentAlter_after = UFDoubleUtils.add((UFDouble[])afterList.toArray(new UFDouble[0]));
        rentAlter_after = discountModeDay365OrDay360 ? rentAlter_after.div(2.0) : rentAlter_after;
        AlterBodyVO bodyVO = (AlterBodyVO)alterVO.getChildrenVO()[0];
        UFDouble rentAlter = UFDoubleUtils.sub((UFDouble)rentAlter_after, (UFDouble)rentAlter_before);
        bodyVO.setAttributeValue("rentalter_before", (Object)ScaleUtils.setScaleByCurrType((UFDouble)rentAlter_before, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("rentalter_alter", (Object)ScaleUtils.setScaleByCurrType((UFDouble)rentAlter, (String)pk_currency, (boolean)false));
        bodyVO.setAttributeValue("rentalter_after", (Object)ScaleUtils.setScaleByCurrType((UFDouble)rentAlter_after, (String)pk_currency, (boolean)false));
        List showAlterKeyList = alterVO.getShowAlterKeyList();
        showAlterKeyList.add("rentalter");
    }

    private SuccessAlter appendNaturemonth(AlterVO alterVO) throws BusinessException {
        if (this.addUsufructVO.getPurchase_choice() != null && this.addUsufructVO.getPurchase_choice().booleanValue() && this.oldUsufructVO.getPurchase_choice().booleanValue()) {
            return SuccessAlter.NONE;
        }
        AlterHeadVO headVO = alterVO.getParentVO();
        AlterBodyVO body = (AlterBodyVO)alterVO.getChildrenVO()[0];
        headVO.setPk_accbook(this.pk_accbook);
        body.setPk_accbook(this.pk_accbook);
        UsufructAssetVO usufructAssetVO = (UsufructAssetVO)CardVOUtils.toTrueTab((SuperVO[])new UsufructAssetViewVO[]{this.addUsufructVO})[0];
        UFDate beginDate = PayScheduleCalculateHelper.getMaxBeginDateForNature(this.addCardVO, usufructAssetVO);
        UFDate endDate = PayScheduleCalculateHelper.getMaxEndDate(this.addUsufructVO);
        int afterNaturemonth = PeriodManager.getInstance().getMonCountBetween(beginDate.toLocalString(), endDate.toLocalString()) + 1;
        Set<String> setAccbook = AccbookRelatCategoryUtil.queryCategoryAndOrgBookKeys(headVO.getPk_group(), headVO.getPk_org(), this.cardhistoryVO.getPk_category(), headVO.getBusiness_date(), this.addCardVO.getUsufructasset_flag());
        Map<String, AccbookBodyVO> mapAccbookBodyVO = AccbookRelatCategoryUtil.queryAccbookBodyData(headVO.getPk_group(), headVO.getPk_org(), this.cardhistoryVO.getPk_category(), (String[])CollectionUtils.toArray(setAccbook), headVO.getBusiness_date(), this.addCardVO.getUsufructasset_flag());
        if (this.addUsufructVO.getPurchase_choice() != null && this.addUsufructVO.getPurchase_choice().booleanValue()) {
            if (UsufructAssetEnumJudge.isCohesionProcessEnumSimple_retrospective_adjustment(this.addUsufructVO)) {
                afterNaturemonth = this.addUsufructVO.getRetrospective_date().beforeDate(this.addUsufructVO.getRentstart_date()) ? mapAccbookBodyVO.get(this.cardhistoryVO.getPk_accbook()).getServicemonth() : mapAccbookBodyVO.get(this.cardhistoryVO.getPk_accbook()).getServicemonth() - NatureDateTools.getMonthsBetween((UFDate)this.addUsufructVO.getRentstart_date(), (UFDate)this.addUsufructVO.getRetrospective_date());
                afterNaturemonth = afterNaturemonth < 0 ? 0 : afterNaturemonth;
            } else {
                afterNaturemonth = mapAccbookBodyVO.get(this.cardhistoryVO.getPk_accbook()).getServicemonth();
            }
        }
        UFDate business_date = this.addCardVO.getBusiness_date();
        Integer beforeNaturemonth = this.cardhistoryVO.getNaturemonth();
        if (beforeNaturemonth.equals(afterNaturemonth)) {
            return SuccessAlter.FAIL;
        }
        body.setAttributeValue("naturemonth_before", (Object)beforeNaturemonth);
        body.setAttributeValue("naturemonth_after", (Object)afterNaturemonth);
        List showAlterKeyList = alterVO.getShowAlterKeyList();
        showAlterKeyList.add("naturemonth");
        if (showAlterKeyList.contains("naturemonth")) {
            String serviceMonth = AssetDateCalUtils.getServiceMonth(body.getPk_accbook(), afterNaturemonth, business_date);
            body.setAttributeValue("servicemonth_before", (Object)this.cardhistoryVO.getServicemonth());
            body.setAttributeValue("servicemonth_after", (Object)serviceMonth);
            UFDate dep_end_date = AssetDateCalUtils.getDepEndDate(this.cardhistoryVO.getDep_start_date(), afterNaturemonth);
            body.setAttributeValue("dep_end_date_before", (Object)this.cardhistoryVO.getDep_end_date());
            body.setAttributeValue("dep_end_date_after", (Object)dep_end_date);
            if (!showAlterKeyList.contains("servicemonth")) {
                showAlterKeyList.add("servicemonth");
            }
            if (!showAlterKeyList.contains("dep_end_date")) {
                showAlterKeyList.add("dep_end_date");
            }
        }
        return SuccessAlter.SUCCESS;
    }

    public static UFDate getChangeCalculationDate() {
        return changeCalculationDate;
    }

    public static void setChangeCalculationDate(UFDate changeCalculationDate) {
        AssetToAlterGenerator.changeCalculationDate = changeCalculationDate;
    }

    private static enum SuccessAlter {
        SUCCESS,
        FAIL,
        NONE;

    }
}

