/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.relative.handler;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nc.itf.bd.userdefitem.IUserdefitemQryService;
import nc.md.MDBaseQueryFacade;
import nc.md.model.IAttribute;
import nc.pub.fa.asset.relation.RelationConst;
import nc.pub.fa.asset.relation.RelativeDataVO;
import nc.pub.fa.asset.relative.handler.IRelateHandler;
import nc.pub.fa.card.AssetBeanUtils;
import nc.pub.fa.card.AssetFieldConst;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.CardVOUtils;
import nc.vo.am.common.BizContext;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.bd.userdefrule.UserdefitemVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.CardVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;

public abstract class BaseRelateHandler
implements IRelateHandler {
    protected AggCardVO aggCvo = null;
    protected RelativeDataVO rdVO = null;
    protected String pk_accbook_bs = null;
    protected String pk_accbook_selected = null;
    protected List<String> links = Lists.newArrayList();

    public void addLinks(String link) {
        this.links.add(link);
    }

    public List<String> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    protected void setRelateVO(AggCardVO aggCvo) {
        this.aggCvo = aggCvo;
        this.rdVO = new RelativeDataVO();
    }

    public AggCardVO getAggCvo() {
        return this.aggCvo;
    }

    public abstract Object getOriginValue(String var1);

    public void setMutilBookData(CardhistoryVO[] hisVOs) {
        this.aggCvo.setTableVO(CardTabConst.history, (CircularlyAccessibleValueObject[])hisVOs);
        this.setRelateProData(RelationConst.createMutilBook, hisVOs);
    }

    @Override
    public Object getValue(String fieldName, String pk_accbook) {
        if (pk_accbook == null) {
            pk_accbook = this.getSelectedAccbook();
        }
        Object result = null;
        IAttribute attri = AssetBeanUtils.getCardAttribut(fieldName);
        IAttribute usufructAssetAttri = AssetBeanUtils.getUsufructAssetAttribut(fieldName);
        if (attri != null) {
            result = this.aggCvo.getParentVO().getAttributeValue(fieldName);
        } else if (usufructAssetAttri != null) {
            result = this.aggCvo.getUsufructAssetVO().getAttributeValue(fieldName);
        } else {
            if (fieldName.equals("pk_accbook")) {
                return pk_accbook;
            }
            Object[] hisVOs = this.aggCvo.getTableVO(CardTabConst.history);
            if (ArrayUtils.isNotEmpty((Object[])hisVOs)) {
                if (StringUtils.isEmpty((String)pk_accbook) || Arrays.asList(AssetFieldConst.BUSINESS_FIELD).contains(fieldName)) {
                    return hisVOs[0].getAttributeValue(fieldName);
                }
                for (Object vo : hisVOs) {
                    CardhistoryVO hisVO = (CardhistoryVO)vo;
                    if (!StringUtils.equals((CharSequence)hisVO.getPk_accbook(), (CharSequence)pk_accbook)) continue;
                    result = hisVO.getAttributeValue(fieldName);
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public void setValue(String fieldName, String pk_accbook, Object obj) {
        IAttribute cardAttri = AssetBeanUtils.getCardAttribut(fieldName);
        IAttribute usufructAssetAttri = AssetBeanUtils.getUsufructAssetAttribut(fieldName);
        if (cardAttri != null) {
            this.aggCvo.getParentVO().setAttributeValue(fieldName, obj);
            this.rdVO.setValue(fieldName, obj);
        } else if (usufructAssetAttri != null) {
            this.aggCvo.getTableVO(CardTabConst.usufructasset_tab)[0].setAttributeValue(fieldName, obj);
            this.rdVO.setValue(fieldName, CardTabConst.usufructasset_tab, obj);
        } else {
            Object[] hisVOs = this.aggCvo.getTableVO(CardTabConst.history);
            if (StringUtils.isEmpty((String)pk_accbook) || Arrays.asList(AssetFieldConst.BUSINESS_FIELD).contains(fieldName)) {
                if (ArrayUtils.isNotEmpty((Object[])hisVOs)) {
                    for (Object vo : hisVOs) {
                        vo.setAttributeValue(fieldName, obj);
                    }
                }
                this.rdVO.setValue(fieldName, obj);
            } else if (ArrayUtils.isNotEmpty((Object[])hisVOs)) {
                for (Object vo : hisVOs) {
                    CardhistoryVO hisVO = (CardhistoryVO)vo;
                    if (!StringUtils.equals((CharSequence)hisVO.getPk_accbook(), (CharSequence)pk_accbook)) continue;
                    hisVO.setAttributeValue(fieldName, obj);
                    this.rdVO.setValue(fieldName, pk_accbook, obj);
                }
            }
        }
    }

    @Override
    public void clearValue(String fieldName, String pk_accbook) {
        this.setValue(fieldName, pk_accbook, null);
    }

    @Override
    public String[] getAllAccbookKeys() {
        return CardVOUtils.getAllBooksFormAggvo(this.aggCvo);
    }

    @Override
    public CardhistoryVO[] getCardhistoryData() {
        return (CardhistoryVO[])this.aggCvo.body(CardTabConst.history);
    }

    @Override
    public CardhistoryVO getCardhistoryVO(String pk_accbook) {
        Object[] hisVOs = this.getCardhistoryData();
        if (ArrayUtils.isNotEmpty((Object[])hisVOs)) {
            for (Object vo : hisVOs) {
                if (!((CardhistoryVO)vo).getPk_accbook().equals(pk_accbook)) continue;
                return vo;
            }
        }
        return null;
    }

    @Override
    public String getSelectedAccbook() {
        Object[] hisVOs;
        if (StringUtils.isEmpty((String)this.pk_accbook_selected) && ArrayUtils.isNotEmpty((Object[])(hisVOs = this.getCardhistoryData()))) {
            for (Object vo : hisVOs) {
                if (!UFBoolean.TRUE.equals((Object)((CardhistoryVO)vo).getBusiness_flag())) continue;
                this.pk_accbook_selected = ((CardhistoryVO)vo).getPk_accbook();
            }
        }
        return this.pk_accbook_selected;
    }

    public void setSelectedAccbook(String pk_accbook) {
        if (StringUtils.isNotBlank((CharSequence)pk_accbook)) {
            this.pk_accbook_selected = pk_accbook;
        }
    }

    @Override
    public void setBusinessAccbook(String pk_accbook) {
        this.pk_accbook_bs = pk_accbook;
        Object[] hisVOs = this.getCardhistoryData();
        if (ArrayUtils.isNotEmpty((Object[])hisVOs)) {
            for (Object vo : hisVOs) {
                if (!((CardhistoryVO)vo).getPk_accbook().equals(pk_accbook)) continue;
                ((CardhistoryVO)vo).setBusiness_flag(UFBoolean.TRUE);
                break;
            }
        }
    }

    @Override
    public Object getSource(String fieldName) {
        IAttribute attri = AssetBeanUtils.getAssetAttribut(fieldName);
        return attri;
    }

    @Override
    public void setRelateProData(String key, Object obj) {
        this.rdVO.setOtherProData(key, obj);
    }

    public String getBusinessBook() {
        return this.pk_accbook_bs;
    }

    @Override
    public String getPk_org() {
        String pk_org = (String)this.getValue("pk_org", this.pk_accbook_bs);
        return pk_org;
    }

    @Override
    public UFDate getCurrencyRateDate() {
        CardVO cvo = this.aggCvo.getParentVO();
        UFDate date = cvo.getBusiness_date();
        if (date == null) {
            date = BizContext.getInstance().getBizDate();
        }
        return date;
    }

    public RelativeDataVO getRelativeDataVO() {
        return this.rdVO;
    }

    @Override
    public boolean isEmptyAccbooks() {
        Object[] hisVOs = this.getCardhistoryData();
        if (ArrayUtils.isEmpty((Object[])hisVOs)) {
            return true;
        }
        for (Object vo : hisVOs) {
            if (((CardhistoryVO)vo).getPk_accbook() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCalcLocal(String field) {
        block11: {
            if (field.equals("naturemonth_display")) {
                field = "naturemonth";
                return false;
            }
            if (field.equals("servicemonth")) {
                return false;
            }
            if (field.equals("salvage")) {
                return false;
            }
            if (field.equals("accu_interest")) {
                return false;
            }
            IAttribute attri = AssetBeanUtils.getAssetAttribut(field);
            if (attri == null) {
                return false;
            }
            int type = attri.getDataType().getTypeType();
            if (type == 56) {
                try {
                    String pk_org = (String)this.getValue("pk_org", this.getSelectedAccbook());
                    String MDPropertyID = AssetBeanUtils.getAssetAttribut(field).getID();
                    UserdefitemVO defItem = ((IUserdefitemQryService)AMProxy.lookup(IUserdefitemQryService.class)).qeuryUserdefitemVOByMDPropertyID(MDPropertyID, pk_org);
                    if (defItem == null) {
                        return false;
                    }
                    int typetype = MDBaseQueryFacade.getInstance().getTypeByID(defItem.getClassid(), 300).getTypeType();
                    if (typetype == 52 || typetype == 31 || typetype == 2 || typetype == 4 || typetype == 6 || typetype == 10) {
                        return true;
                    }
                    break block11;
                }
                catch (BusinessException e) {
                    throw ExceptionUtils.businessRuntimeException((Throwable)e);
                }
            }
            if (type == 52 || type == 31 || type == 2 || type == 4 || type == 6 || type == 10) {
                return true;
            }
        }
        return false;
    }
}

