/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.pub.fa.asset.relation.FieldVO;
import nc.pub.fa.asset.relation.RelationConst;
import nc.pub.fa.card.AssetFieldConst;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.StringUtils;

public class RelativeDataVO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<FieldVO> fvos = new ArrayList<FieldVO>();
    private Map<String, Object> otherProDatas = new HashMap<String, Object>();

    public String[] getChangedTypes(String type) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (this.fvos != null && this.fvos.size() > 0) {
            for (FieldVO vo : this.fvos) {
                String fieldName = vo.getFieldName();
                if (!StringUtils.isNotEmpty((String)fieldName) || !vo.containAccbook(type)) continue;
                fieldNames.add(fieldName);
            }
        }
        return (String[])CollectionUtils.toArray(fieldNames);
    }

    public String[] getChangedFields() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (this.fvos != null && this.fvos.size() > 0) {
            for (FieldVO vo : this.fvos) {
                String fieldName = vo.getFieldName();
                if (!StringUtils.isNotEmpty((String)fieldName)) continue;
                fieldNames.add(fieldName);
            }
        }
        return (String[])CollectionUtils.toArray(fieldNames);
    }

    public void setValue(String fieldName, Object value) {
        this.setValue(fieldName, RelationConst.businessBook, value);
    }

    public void setValue(String fieldName, String pk_accbook, Object value) {
        FieldVO fvo = this.getFieldVO(fieldName);
        if (fvo == null) {
            fvo = new FieldVO();
            this.fvos.add(fvo);
        }
        if (Arrays.asList(AssetFieldConst.BUSINESS_FIELD).contains(fieldName)) {
            pk_accbook = RelationConst.businessBook;
        }
        fvo.setFieldName(fieldName);
        fvo.setValue(pk_accbook, value);
    }

    public Object getValue(String fieldName) {
        return this.getValue(fieldName, RelationConst.businessBook);
    }

    public Object getValue(String fieldName, String pk_accbook) {
        FieldVO fvo = this.getFieldVO(fieldName);
        if (fvo != null) {
            return fvo.getValue(pk_accbook);
        }
        return null;
    }

    public FieldVO getFieldVO(String fieldName) {
        for (FieldVO vo : this.fvos) {
            if (!vo.getFieldName().equals(fieldName)) continue;
            return vo;
        }
        return null;
    }

    public void setOtherProData(String key, Object data) {
        this.otherProDatas.put(key, data);
    }

    public Object getOtherProData(String key) {
        return this.otherProDatas.get(key);
    }

    public Map<String, Object> getOtherProDatas() {
        return this.otherProDatas;
    }

    public List<FieldVO> getFvos() {
        return this.fvos;
    }

    public void setFvos(List<FieldVO> fvos) {
        this.fvos = fvos;
    }
}

