/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.manager;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nc.itf.fa.prv.IAsset;
import nc.pub.fa.card.CardTabConst;
import nc.pub.fa.card.CardVOUtils;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetEntiretyVO;
import nc.vo.fa.assetcard.AggCardVO;
import nc.vo.fa.assetcard.StepRentStandardVO;
import nc.vo.fa.assetcard.UsufructAssetVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.lang.UFBoolean;

public class UsufructAssetUpdateBeforeHandler<T extends AggCardVO> {
    private T originAggCard;
    private T updatedAggCard;
    private String pk_card;

    public UsufructAssetUpdateBeforeHandler(T originAggCard, T updatedAggCard) throws BusinessException {
        this.originAggCard = originAggCard;
        this.updatedAggCard = updatedAggCard;
        this.pk_card = this.updatedAggCard.getPrimaryKey();
        if (this.originAggCard == null) {
            AssetEntiretyVO originvo = ((IAsset)AMProxy.lookup(IAsset.class)).queryAssetEntiretyVOByPkcard(this.pk_card);
            this.originAggCard = CardVOUtils.toAggCard(originvo);
        }
    }

    public void updateStepRent() {
        UsufructAssetVO usufructasset_tab = (UsufructAssetVO)this.updatedAggCard.getTableVO(CardTabConst.usufructasset_tab)[0];
        UFBoolean step_rent = usufructasset_tab.getStep_rent();
        StepRentStandardVO[] update_steps = (StepRentStandardVO[])this.updatedAggCard.getTableVO(CardTabConst.steprentstandard_tab);
        StepRentStandardVO[] origin_steps = (StepRentStandardVO[])this.originAggCard.getTableVO(CardTabConst.steprentstandard_tab);
        if (update_steps == null) {
            update_steps = new StepRentStandardVO[]{};
        }
        if (origin_steps == null) {
            origin_steps = new StepRentStandardVO[]{};
        }
        LinkedList<StepRentStandardVO> update_list = new LinkedList<StepRentStandardVO>();
        Collections.addAll(update_list, update_steps);
        LinkedList origin_list = new LinkedList();
        Collections.addAll(origin_list, origin_steps);
        Set update_key_set = update_list.stream().filter(v -> v.getPk_steprentstandard() != null && v.getStatus() < 3).map(v -> {
            v.setStatus(1);
            return v.getPk_steprentstandard();
        }).collect(Collectors.toSet());
        origin_list.forEach(v -> v.setStatus(3));
        Map<String, StepRentStandardVO> origin_map = origin_list.stream().collect(Collectors.toMap(StepRentStandardVO::getPk_steprentstandard, o -> o));
        if (UFBoolean.FALSE.equals((Object)step_rent)) {
            update_list.addAll(origin_map.values());
        } else {
            for (Map.Entry<String, StepRentStandardVO> step : origin_map.entrySet()) {
                String key = step.getKey();
                if (update_key_set.contains(key)) continue;
                update_list.add(step.getValue());
            }
        }
        this.updatedAggCard.setTableVO(CardTabConst.steprentstandard_tab, (CircularlyAccessibleValueObject[])update_list.toArray(new StepRentStandardVO[0]));
    }
}

