/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.manager;

import java.util.Map;
import nc.pub.fa.asset.manager.AssetHelperHandleUtil;
import nc.pub.fa.card.AssetQuerySqlTool;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;

public class IUFOAssetQueryUtil {
    public static String getPeriodAndAccbookSql(String queryPeriod, String[] asset_states, String[] pk_accbooks) throws BusinessException {
        if (queryPeriod != null && pk_accbooks != null && pk_accbooks.length > 0) {
            String[] yearMonth = null;
            if (queryPeriod.length() != 7) {
                yearMonth = PeriodManager.getYearMonthByPeriodCode((String)queryPeriod);
            } else {
                if (queryPeriod.contains("-")) {
                    yearMonth = queryPeriod.split("-");
                }
                if (queryPeriod.contains("_")) {
                    yearMonth = queryPeriod.split("_");
                }
            }
            Map<String, AccperiodVO> accbookToStratPeriodMap = AssetHelperHandleUtil.accbookAndStratPeriodMap;
            String sql = AssetHelperHandleUtil.getQueryCardhistorySqlWithCatch(yearMonth[0], yearMonth[1], asset_states, pk_accbooks, accbookToStratPeriodMap);
            String adjustWhere = AssetQuerySqlTool.adjustWhereSQL(sql);
            return adjustWhere;
        }
        return null;
    }

    public static String getPeriodAndAccbookSqlWithCatch(String queryPeriod, String[] asset_states, String[] pk_accbooks, Map<String, AccperiodVO> accbookToStratPeriodMap) throws BusinessException {
        if (queryPeriod != null && pk_accbooks != null && pk_accbooks.length > 0) {
            String[] yearMonth = null;
            if (queryPeriod.length() != 7) {
                yearMonth = PeriodManager.getYearMonthByPeriodCode((String)queryPeriod);
            } else {
                if (queryPeriod.contains("-")) {
                    yearMonth = queryPeriod.split("-");
                }
                if (queryPeriod.contains("_")) {
                    yearMonth = queryPeriod.split("_");
                }
            }
            String sql = AssetHelperHandleUtil.getQueryCardhistorySqlWithCatch(yearMonth[0], yearMonth[1], asset_states, pk_accbooks, accbookToStratPeriodMap);
            String adjustWhere = AssetQuerySqlTool.adjustWhereSQL(sql);
            return adjustWhere;
        }
        return null;
    }

    public static String getPeriodAndAccbookSql(String startPeriod, String endPeriod, String[] asset_states, String[] pk_accbooks) throws BusinessException {
        int compare;
        if (startPeriod == null || endPeriod == null || pk_accbooks == null || pk_accbooks.length == 0) {
            return null;
        }
        if (startPeriod.compareTo(endPeriod) > 0) {
            ExceptionUtils.asBusinessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0479"));
        }
        StringBuffer sql = new StringBuffer();
        String[] yearMonth1 = PeriodManager.getYearMonthByPeriodCode((String)startPeriod);
        AccperiodVO startPeriodVO = new AccperiodVO(yearMonth1[0], yearMonth1[1]);
        String[] yearMonth2 = PeriodManager.getYearMonthByPeriodCode((String)endPeriod);
        AccperiodVO endPeriodVO = new AccperiodVO(yearMonth2[0], yearMonth2[1]);
        AccperiodVO thisPeriodVO = startPeriodVO;
        while ((compare = PeriodManager.compareTwoPeriods((AccperiodVO)thisPeriodVO, (AccperiodVO)endPeriodVO)) <= 0) {
            String thisSql = AssetHelperHandleUtil.getQueryCardhistorySql(thisPeriodVO.getAccyear(), thisPeriodVO.getPeriod(), asset_states, pk_accbooks);
            sql.append(" or " + thisSql);
            thisPeriodVO = PeriodManager.getInstance().getNextPeriod(pk_accbooks[0], thisPeriodVO);
        }
        return sql.toString().substring(4, sql.length());
    }
}

