/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.manager;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.impl.am.common.InSqlManager;
import nc.itf.fa.service.ICategoryService;
import nc.itf.fa.service.ICloseBookService;
import nc.pub.fa.card.AssetStateConst;
import nc.pubitf.org.IAccountingBookPubService;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.BaseVOUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.StringUtils;
import nc.vo.am.manager.AccbookManager;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.asset.AssetVO;
import nc.vo.fa.assetcard.CardhistoryVO;
import nc.vo.fa.category.CategoryVO;
import nc.vo.logging.Debug;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.AggregatedValueObject;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;

public class AssetHelperHandleUtil {
    public static Map<String, AccperiodVO> accbookAndStratPeriodMap = new HashMap<String, AccperiodVO>();

    public static void fillPeriod(List<CardhistoryVO> data, UFDate business_date) throws BusinessException {
        if (data == null || data.size() == 0) {
            return;
        }
        HashMap<String, AccperiodVO> periodMap = new HashMap<String, AccperiodVO>();
        for (CardhistoryVO vo : data) {
            String pk_accbook = vo.getPk_accbook();
            AccperiodVO periodvo = null;
            if (periodMap.containsKey(pk_accbook)) {
                periodvo = (AccperiodVO)periodMap.get(pk_accbook);
            } else {
                periodvo = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, business_date);
                periodMap.put(pk_accbook, periodvo);
            }
            vo.setPeriod(periodvo.getPeriod());
            vo.setAccyear(periodvo.getAccyear());
        }
    }

    public static String getQueryCardhistorySql(String accyear, String period, String[] asset_states, String[] pk_accbooks) throws BusinessException {
        Map minUnClosed = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriodWithBatch(pk_accbooks, accbookAndStratPeriodMap);
        HashSet<CallSite> minperiods = new HashSet<CallSite>();
        for (String pk_accbook : minUnClosed.keySet()) {
            AccperiodVO accperiod = (AccperiodVO)minUnClosed.get(pk_accbook);
            if (null == accperiod) continue;
            accperiod.getAccyear();
            accperiod.getPeriod();
            String minPeriod = accperiod.getAccyear() + accperiod.getPeriod();
            minperiods.add((CallSite)((Object)minPeriod));
        }
        if (minperiods.size() == 1) {
            String tperiod = minperiods.toArray(new String[0])[0];
            if ((accyear + period).equals(tperiod)) {
                List<String> reduce_state = AssetStateConst.getReduceStateList(asset_states);
                List<String> exist_state = AssetStateConst.getExitStateList(asset_states);
                if (reduce_state.isEmpty() && !exist_state.isEmpty()) {
                    String pk_accbooksql = InSqlManager.getInSQLValue((String[])pk_accbooks);
                    StringBuffer queryHistoryDataSql = new StringBuffer();
                    queryHistoryDataSql.append("(");
                    queryHistoryDataSql.append("pk_accbook in " + pk_accbooksql);
                    queryHistoryDataSql.append(" and asset_state in " + InSqlManager.getInSQLValue(exist_state));
                    queryHistoryDataSql.append(" and accyear = '" + accyear + "'");
                    queryHistoryDataSql.append(" and period = '" + period + "'");
                    queryHistoryDataSql.append(" and laststate_flag = '" + UFBoolean.TRUE + "'");
                    queryHistoryDataSql.append(")");
                    return queryHistoryDataSql.toString();
                }
            }
        }
        Map startPeriods = PeriodManager.getBatchStartPeriod_FA((String[])pk_accbooks);
        return AssetHelperHandleUtil.getQueryCardhistorySql(accyear, period, minUnClosed, startPeriods, asset_states);
    }

    public static String getQueryCardhistorySqlWithCatch(String accyear, String period, String[] asset_states, String[] pk_accbooks, Map<String, AccperiodVO> accbookToStratPeriodMap) throws BusinessException {
        accbookAndStratPeriodMap.putAll(accbookToStratPeriodMap);
        Map<String, AccperiodVO> startPeriods = new HashMap();
        if (accbookAndStratPeriodMap.size() > 0) {
            ArrayList<String> pkAccbookString = new ArrayList<String>();
            for (String pkAccbook : pk_accbooks) {
                AccperiodVO vo = accbookAndStratPeriodMap.get(pkAccbook);
                if (vo == null) {
                    pkAccbookString.add(pkAccbook);
                    continue;
                }
                startPeriods.put(pkAccbook, accbookAndStratPeriodMap.get(pkAccbook));
            }
            if (!pkAccbookString.isEmpty()) {
                Map startPeriodsSub = PeriodManager.getBatchStartPeriod_FA((String[])pkAccbookString.toArray(new String[0]));
                startPeriods.putAll(startPeriodsSub);
                accbookAndStratPeriodMap.putAll(startPeriodsSub);
            }
        } else {
            startPeriods = PeriodManager.getBatchStartPeriod_FA((String[])pk_accbooks);
            accbookAndStratPeriodMap.putAll(startPeriods);
        }
        Map minUnClosed = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriodWithBatch(pk_accbooks, accbookAndStratPeriodMap);
        Set minperiods = minUnClosed.keySet().stream().map(pk_accbook -> (AccperiodVO)minUnClosed.get(pk_accbook)).filter(accPeriodVO -> accPeriodVO != null).map(accPeriodVO -> accPeriodVO.getAccyear() + accPeriodVO.getPeriod()).collect(Collectors.toSet());
        if (minperiods.size() == 1) {
            String tperiod = (String)minperiods.stream().findFirst().get();
            if ((accyear + period).equals(tperiod)) {
                List<String> reduce_state = AssetStateConst.getReduceStateList(asset_states);
                List<String> exist_state = AssetStateConst.getExitStateList(asset_states);
                if (reduce_state.isEmpty() && !exist_state.isEmpty()) {
                    StringBuffer queryHistoryDataSql = new StringBuffer();
                    queryHistoryDataSql.append("(");
                    queryHistoryDataSql.append(" pk_accbook in " + InSqlManager.getInSQLValue((String[])pk_accbooks));
                    queryHistoryDataSql.append(" and asset_state in " + InSqlManager.getInSQLValue(exist_state));
                    queryHistoryDataSql.append(" and accyear = '" + accyear + "'");
                    queryHistoryDataSql.append(" and period = '" + period + "'");
                    queryHistoryDataSql.append(" and laststate_flag = '" + UFBoolean.TRUE + "'");
                    queryHistoryDataSql.append(")");
                    return queryHistoryDataSql.toString();
                }
            }
        }
        return AssetHelperHandleUtil.getQueryCardhistorySql(accyear, period, minUnClosed, startPeriods, asset_states);
    }

    public static String getMinUnCloseQueryCardhistorySqlByOrg(String pk_org) throws BusinessException {
        String sql = "";
        Object[] pk_accbooks = ((IAccountingBookPubService)AMProxy.lookup(IAccountingBookPubService.class)).queryAccountingBookIDSByFinanceOrgID(pk_org);
        if (ArrayUtils.isNotEmpty((Object[])pk_accbooks)) {
            Map minUnClosed = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod((String[])pk_accbooks);
            sql = AssetHelperHandleUtil.getMinUnCloseQueryCardhistorySql(minUnClosed);
        }
        return sql;
    }

    public static String getMinUnCloseQueryCardhistorySqlByBook(String pk_accbook) throws BusinessException {
        String sql = "";
        Map minUnClosed = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(new String[]{pk_accbook});
        sql = AssetHelperHandleUtil.getMinUnCloseQueryCardhistorySql(minUnClosed);
        return sql;
    }

    private static String getMinUnCloseQueryCardhistorySql(Map<String, AccperiodVO> minUnClosed) {
        StringBuffer queryHistoryDataSql = new StringBuffer();
        queryHistoryDataSql.append("(");
        int i = 0;
        for (String pk_accbook : minUnClosed.keySet()) {
            AccperiodVO vo = minUnClosed.get(pk_accbook);
            if (i > 0) {
                queryHistoryDataSql.append(" or");
            }
            queryHistoryDataSql.append(" (pk_accbook = '" + pk_accbook + "'");
            queryHistoryDataSql.append(" and accyear = '" + vo.getAccyear() + "' and period = '" + vo.getPeriod() + "'");
            queryHistoryDataSql.append(")");
            ++i;
        }
        queryHistoryDataSql.append(" )");
        return queryHistoryDataSql.toString();
    }

    public static String getQueryCardhistorySql(String accyear, String period, Map<String, AccperiodVO> minUnClosedMap, Map<String, AccperiodVO> startPeriods, String[] asset_states) throws BusinessException {
        if (startPeriods == null || startPeriods.isEmpty()) {
            return "";
        }
        Map<String, AccperiodVO> minUnClosed = minUnClosedMap.keySet().stream().filter(key -> minUnClosedMap.get(key) != null).collect(Collectors.toMap(key -> key, key -> (AccperiodVO)minUnClosedMap.get(key)));
        AccperiodVO queryPeriod = new AccperiodVO(accyear, period);
        List<String> reduce_state = AssetStateConst.getReduceStateList(asset_states);
        List<String> exist_state = AssetStateConst.getExitStateList(asset_states);
        ArrayList<QueryConditionObject> queryObjectList = new ArrayList<QueryConditionObject>();
        for (String pk_accbook : minUnClosed.keySet()) {
            QueryConditionObject queryObject;
            AccperiodVO minUnClosedAccPeriodVo = minUnClosed.get(pk_accbook);
            int compare2 = PeriodManager.compareTwoPeriods((AccperiodVO)queryPeriod, (AccperiodVO)minUnClosedAccPeriodVo);
            if (compare2 >= 0) {
                StringBuffer queryHistoryDataSql;
                QueryConditionObject queryObject2;
                if (exist_state.size() > 0) {
                    queryObject2 = new QueryConditionObject();
                    queryObject2.setPkAccbook(pk_accbook);
                    queryHistoryDataSql = new StringBuffer();
                    queryHistoryDataSql.append("(");
                    if (exist_state.size() == 1) {
                        queryHistoryDataSql.append(" asset_state = 'exist'");
                    } else {
                        queryHistoryDataSql.append(" asset_state in " + InSqlManager.getInSQLValue(exist_state));
                    }
                    queryHistoryDataSql.append(" and accyear = '" + minUnClosedAccPeriodVo.getAccyear() + "'");
                    queryHistoryDataSql.append(" and period = '" + minUnClosedAccPeriodVo.getPeriod() + "'");
                    queryHistoryDataSql.append(" and laststate_flag = '" + UFBoolean.TRUE + "'");
                    queryHistoryDataSql.append(")");
                    queryObject2.setSqlSegment(queryHistoryDataSql.toString());
                    queryObjectList.add(queryObject2);
                }
                if (reduce_state.size() <= 0) continue;
                queryObject2 = new QueryConditionObject();
                queryObject2.setPkAccbook(pk_accbook);
                queryHistoryDataSql = new StringBuffer();
                queryHistoryDataSql.append("(");
                queryHistoryDataSql.append(" asset_state in " + InSqlManager.getInSQLValue(reduce_state));
                queryHistoryDataSql.append(" and ");
                queryHistoryDataSql.append("(");
                queryHistoryDataSql.append("laststate_flag = '" + UFBoolean.TRUE + "'");
                queryHistoryDataSql.append(" or ");
                queryHistoryDataSql.append("(");
                queryHistoryDataSql.append("fa_cardhistory.accyear||fa_cardhistory.period <= " + minUnClosedAccPeriodVo.getAccyear() + minUnClosedAccPeriodVo.getPeriod());
                queryHistoryDataSql.append(" and laststate_flag = '" + UFBoolean.FALSE + "'");
                queryHistoryDataSql.append(")");
                queryHistoryDataSql.append(")");
                queryHistoryDataSql.append(")");
                queryObject2.setSqlSegment(queryHistoryDataSql.toString());
                queryObjectList.add(queryObject2);
                continue;
            }
            AccperiodVO strPeriod = startPeriods.get(pk_accbook);
            int compare1 = PeriodManager.compareTwoPeriods((AccperiodVO)queryPeriod, (AccperiodVO)strPeriod);
            if (compare1 >= 0) {
                StringBuffer queryHistoryDataSql;
                AccperiodVO nextPeriod = PeriodManager.getInstance().getNextPeriod(pk_accbook, accyear, period);
                if (exist_state.size() > 0) {
                    queryObject = new QueryConditionObject();
                    queryObject.setPkAccbook(pk_accbook);
                    queryHistoryDataSql = new StringBuffer();
                    queryHistoryDataSql.append("(");
                    if (exist_state.size() == 1) {
                        queryHistoryDataSql.append(" asset_state = 'exist'");
                    } else {
                        queryHistoryDataSql.append(" asset_state in " + InSqlManager.getInSQLValue(exist_state));
                    }
                    queryHistoryDataSql.append(" and accyear = '" + nextPeriod.getAccyear() + "'");
                    queryHistoryDataSql.append(" and period = '" + nextPeriod.getPeriod() + "'");
                    queryHistoryDataSql.append(" and newasset_flag > 1");
                    queryHistoryDataSql.append(" and laststate_flag = '" + UFBoolean.FALSE + "'");
                    queryHistoryDataSql.append(")");
                    queryObject.setSqlSegment(queryHistoryDataSql.toString());
                    queryObjectList.add(queryObject);
                }
                if (reduce_state.size() <= 0) continue;
                queryObject = new QueryConditionObject();
                queryObject.setPkAccbook(pk_accbook);
                queryHistoryDataSql = new StringBuffer();
                queryHistoryDataSql.append("(");
                queryHistoryDataSql.append("fa_cardhistory.accyear||fa_cardhistory.period <= " + nextPeriod.getAccyear() + nextPeriod.getPeriod());
                queryHistoryDataSql.append(" and asset_state in " + InSqlManager.getInSQLValue(reduce_state));
                queryHistoryDataSql.append(" and laststate_flag = '" + UFBoolean.FALSE + "'");
                queryHistoryDataSql.append(")");
                queryObject.setSqlSegment(queryHistoryDataSql.toString());
                queryObjectList.add(queryObject);
                continue;
            }
            StringBuffer queryHistoryDataSql = new StringBuffer();
            queryHistoryDataSql.append(" 1 = 2 ");
            queryObject = new QueryConditionObject();
            queryObject.setPkAccbook(pk_accbook);
            queryObject.setSqlSegment(queryHistoryDataSql.toString());
            queryObjectList.add(queryObject);
        }
        return AssetHelperHandleUtil.gatherPkAccbook(queryObjectList);
    }

    private static String gatherPkAccbook(List<QueryConditionObject> queryObjectList) {
        Map<String, List<QueryConditionObject>> orSegement = queryObjectList.stream().collect(Collectors.groupingBy(QueryConditionObject::getSqlSegment));
        String whereSql = orSegement.keySet().stream().map(segment -> {
            List pkAccbook = ((List)orSegement.get(segment)).stream().map(QueryConditionObject::getPkAccbook).collect(Collectors.toList());
            return "(pk_accbook in " + InSqlManager.getInSQLValue(pkAccbook) + " and " + segment + ")";
        }).collect(Collectors.joining(" or "));
        return "(" + whereSql + ")";
    }

    public static String getQueryCardhistorySql(UFDate business_date, String[] asset_states, String[] pk_accbooks) throws BusinessException {
        StringBuffer sqlall = new StringBuffer();
        if (ArrayUtils.isNotEmpty((Object[])pk_accbooks)) {
            HashMap periodScheme_accbooks = new HashMap();
            for (String pk_accbook : pk_accbooks) {
                String periodScheme = AccbookManager.queryAccperiodScheme((String)pk_accbook);
                if (periodScheme_accbooks.containsKey(periodScheme)) {
                    ((List)periodScheme_accbooks.get(periodScheme)).add(pk_accbook);
                    continue;
                }
                ArrayList<String> accbooks = new ArrayList<String>();
                accbooks.add(pk_accbook);
                periodScheme_accbooks.put(periodScheme, accbooks);
            }
            for (String periodScheme : periodScheme_accbooks.keySet()) {
                String[] accbooks;
                String pk_accbook_first = (String)((List)periodScheme_accbooks.get(periodScheme)).get(0);
                AccperiodVO periodvo = PeriodManager.getInstance().queryPerriodMonth(pk_accbook_first, business_date);
                String period = periodvo.getPeriod();
                String accyear = periodvo.getAccyear();
                String sql = AssetHelperHandleUtil.getQueryCardhistorySql(accyear, period, asset_states, accbooks = (String[])CollectionUtils.toArray((Collection)((Collection)periodScheme_accbooks.get(periodScheme))));
                if (!StringUtils.isNotEmpty((String)sql)) continue;
                sqlall.append(" or ");
                sqlall.append(sql);
            }
            sqlall = sqlall.delete(0, 4);
        }
        return "(" + sqlall.toString() + ")";
    }

    public static String checkBeginAndBusinessDate(Integer newasset_flag, String pk_accbook, UFDate begindate, UFDate businessDate) throws BusinessException {
        AccperiodVO begin = null;
        try {
            begin = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, begindate);
        }
        catch (Exception e) {
            Debug.error((Object)e);
        }
        if (begin == null) {
            if (!begindate.before(businessDate)) {
                if (newasset_flag % 10 == 0) {
                    return NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0070");
                }
                if (!begindate.equals((Object)businessDate)) {
                    return NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0071");
                }
            }
        } else {
            AccperiodVO business = PeriodManager.getInstance().queryPerriodMonth(pk_accbook, businessDate);
            int result = PeriodManager.compareTwoPeriods((AccperiodVO)begin, (AccperiodVO)business);
            if (result > 0) {
                if (newasset_flag % 10 == 0) {
                    return NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0073");
                }
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0072");
            }
            if (result == 0 && newasset_flag % 10 == 0) {
                return NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0073");
            }
        }
        return null;
    }

    public static void fillTransTypeByCategory(AggregatedValueObject[] aggvos) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])aggvos)) {
            return;
        }
        AssetVO[] assetVOs = (AssetVO[])BaseVOUtils.getHeadVOs((AggregatedValueObject[])aggvos, AssetVO.class);
        Object[] pk_categorys = BaseVOUtils.getVOAttributeNotNullValues((SuperVO[])assetVOs, (String)"pk_category");
        if (ArrayUtils.isEmpty((Object[])pk_categorys)) {
            return;
        }
        String pk_group = InvocationInfoProxy.getInstance().getGroupId();
        CategoryVO[] categoryVOs = ((ICategoryService)AMProxy.lookup(ICategoryService.class)).batchQueryCategorys(pk_group, (String[])pk_categorys);
        if (ArrayUtils.isEmpty((Object[])categoryVOs)) {
            String errorMsg = NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0034");
            Debug.error((Object)errorMsg);
            ExceptionUtils.asBusinessRuntimeException((String)errorMsg);
        }
        Map mapCategory = Stream.of(categoryVOs).collect(Collectors.toMap(CategoryVO::getPk_category, Function.identity()));
        for (AssetVO headVO : assetVOs) {
            String pk_category = headVO.getPk_category();
            CategoryVO categoryVO = (CategoryVO)((Object)mapCategory.get(pk_category));
            if (categoryVO == null) continue;
            String trans_type_code = categoryVO.getTransi_type();
            String pk_transtype = categoryVO.getPk_transitype();
            headVO.setTransi_type(trans_type_code);
            headVO.setPk_transitype(pk_transtype);
        }
    }

    private static class QueryConditionObject {
        private String pkAccbook;
        private String sqlSegment;

        private QueryConditionObject() {
        }

        public String getPkAccbook() {
            return this.pkAccbook;
        }

        public void setPkAccbook(String pkAccbook) {
            this.pkAccbook = pkAccbook;
        }

        public String getSqlSegment() {
            return this.sqlSegment;
        }

        public void setSqlSegment(String sqlSegment) {
            this.sqlSegment = sqlSegment;
        }
    }
}

