/*
 * Decompiled with CFR 0.152.
 */
package nc.pub.fa.asset.manager;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nc.itf.appplatform.lic.IAPLicService;
import nc.itf.fa.service.IAccbookInfoService;
import nc.itf.fa.service.internal.AccbookBodysFromAccbookKey;
import nc.pub.fa.asset.manager.AccbookChangeUtil;
import nc.pub.fa.common.util.FAMultiLanguageUtil;
import nc.pubitf.org.IAccountingBookPubService;
import nc.pubitf.rbac.IDataPermissionPubService;
import nc.vo.am.common.BizContext;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.BaseVOUtils;
import nc.vo.am.common.util.ExceptionUtils;
import nc.vo.am.common.util.MapUtils;
import nc.vo.am.common.util.OrgUtils;
import nc.vo.am.constant.DataPowerConst;
import nc.vo.am.manager.VOManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.accbookinfo.AccbookBodyVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.AccountingBookVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.SuperVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDate;

public class AccbookRelatCategoryUtil {
    public static Map<String, List<String>> queryOrgBookKeys(String[] pk_orgs) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pk_orgs)) {
            return null;
        }
        HashMap<String, List<String>> orgToAccbook = new HashMap<String, List<String>>();
        for (String pk_org : pk_orgs) {
            Object[] bookVOs = AccbookRelatCategoryUtil.queryMultiAccbookVOs(pk_org, null);
            if (!ArrayUtils.isNotEmpty((Object[])bookVOs)) continue;
            String[] pk_accountingbooks = BaseVOUtils.getVOAttributeNotNullValues((SuperVO[])bookVOs, (String)"pk_accountingbook");
            orgToAccbook.put(pk_org, Arrays.asList(pk_accountingbooks));
        }
        return orgToAccbook;
    }

    private static List<String> queryPermAccbooks(String pk_org, UFDate business_date) throws BusinessException {
        Object[] accountingBookVOs = AccbookRelatCategoryUtil.queryMultiAccbookVOs(pk_org, business_date);
        if (ArrayUtils.isEmpty((Object[])accountingBookVOs)) {
            return Lists.newArrayList();
        }
        String[] pk_accbooks = (String[])VOManager.getAttributeValueArray((CircularlyAccessibleValueObject[])accountingBookVOs, (String)"pk_accountingbook");
        BizContext bizContext = BizContext.getInstance();
        Map permissionAccbook = ((IDataPermissionPubService)AMProxy.lookup(IDataPermissionPubService.class)).isUserhasPermission("accountingbook", pk_accbooks, DataPowerConst.FA_DEFAULT, bizContext.getGroupId(), bizContext.getUserId());
        return Stream.of(accountingBookVOs).filter(o -> {
            String pk_accbook = o.getPk_accountingbook();
            return permissionAccbook.containsKey(pk_accbook) && ((UFBoolean)permissionAccbook.get(pk_accbook)).booleanValue();
        }).map(o -> o.getPk_accountingbook()).collect(Collectors.toList());
    }

    public static ArrayListMultimap<String, String> queryCategoryCanUsedBookKeys(String pk_group, String pk_org, String[] pk_categorys, UFDate business_date, UFBoolean isUsufructasset) throws BusinessException {
        if (ArrayUtils.isEmpty((Object[])pk_categorys)) {
            return ArrayListMultimap.create();
        }
        List<String> pk_accbooksWithPermission = AccbookRelatCategoryUtil.queryPermAccbooks(pk_org, business_date);
        if (pk_accbooksWithPermission.isEmpty()) {
            Object[] orgvos = OrgUtils.getOrgVOsByOids((String[])new String[]{pk_org});
            if (ArrayUtils.isBlank((Object[])orgvos)) {
                String pk_org1 = OrgUtils.getPkOrgByVid((String)pk_org);
                orgvos = OrgUtils.getOrgVOsByOids((String[])new String[]{pk_org1});
            }
            String org_name = FAMultiLanguageUtil.getMultiLanguageValue((SuperVO)orgvos[0], (String)"name");
            throw ExceptionUtils.businessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("facard_0", "02012005-0666", null, new String[]{org_name, business_date.toLocalString()}));
        }
        return AccbookRelatCategoryUtil.queryAccbookKeyFromCategory(pk_org, pk_accbooksWithPermission.toArray(new String[0]), pk_categorys, isUsufructasset);
    }

    public static ArrayListMultimap<String, String> queryAccbookKeyFromCategory(String pk_org, String[] pk_accbooks, String[] pk_categorys, UFBoolean isUsufructasset) throws BusinessException {
        Map<Boolean, AccbookBodysFromAccbookKey> accbookDataMap = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryAccbookInfoBodyByAccbook(pk_org, pk_accbooks, pk_categorys);
        if (MapUtils.isEmpty(accbookDataMap)) {
            return ArrayListMultimap.create();
        }
        AccbookBodysFromAccbookKey accbookBodysFromAccbookKey = accbookDataMap.get(UFBoolean.TRUE.equals((Object)isUsufructasset));
        if (accbookBodysFromAccbookKey == null || accbookBodysFromAccbookKey.isEmpty()) {
            return ArrayListMultimap.create();
        }
        return accbookBodysFromAccbookKey.transpose();
    }

    public static Map<String, AccbookBodyVO> queryAccbookInfoFromCategory(String pk_org, String[] pk_accbooks, String[] pk_categorys) throws BusinessException {
        HashMap<String, AccbookBodyVO> resultMap = new HashMap<String, AccbookBodyVO>();
        Map<Boolean, AccbookBodysFromAccbookKey> accbookDataMap = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryAccbookInfoBodyByAccbook(pk_org, pk_accbooks, pk_categorys);
        if (MapUtils.isEmpty(accbookDataMap)) {
            return resultMap;
        }
        AccbookBodysFromAccbookKey accbookBodysFromAccbookKey = accbookDataMap.get(false);
        if (accbookBodysFromAccbookKey != null && !accbookBodysFromAccbookKey.isEmpty()) {
            resultMap.putAll(accbookBodysFromAccbookKey.getCategoryAccbookInfoMap());
        }
        if ((accbookBodysFromAccbookKey = accbookDataMap.get(true)) != null && !accbookBodysFromAccbookKey.isEmpty()) {
            resultMap.putAll(accbookBodysFromAccbookKey.getCategoryAccbookInfoMap());
        }
        return resultMap;
    }

    public static Set<String> queryCategoryAndOrgBookKeys(String pk_group, String pk_org, String pk_category, UFDate business_date, UFBoolean isUsufructasset) throws BusinessException {
        ArrayListMultimap<String, String> categoryData = AccbookRelatCategoryUtil.queryCategoryCanUsedBookKeys(pk_group, pk_org, new String[]{pk_category}, business_date, isUsufructasset);
        if (categoryData == null) {
            return Sets.newHashSet();
        }
        List pk_accbooks = categoryData.get((Object)pk_category);
        return Sets.newHashSet((Iterable)pk_accbooks);
    }

    public static Map<String, AccbookBodyVO> queryAccbookBodyData(String pk_group, String pk_org, String pk_category, String[] pk_accbooks, UFDate business_date, UFBoolean isUsufructasset) throws BusinessException {
        Map<String, String> accbookKey2setofbookKey = AccbookChangeUtil.getAccountingBookAndSetofbookKey(pk_org, pk_accbooks, business_date);
        if (accbookKey2setofbookKey == null) {
            return Maps.newHashMap();
        }
        Map<String, AccbookBodyVO> accbookKey2accbookBody = ((IAccbookInfoService)AMProxy.lookup(IAccbookInfoService.class)).queryAccbookinfoBody(pk_org, pk_category, accbookKey2setofbookKey.keySet().toArray(new String[0]), isUsufructasset);
        return accbookKey2accbookBody;
    }

    private static AccountingBookVO[] queryMultiAccbookVOs(String pk_org, UFDate business_date) throws BusinessException {
        if (business_date == null) {
            business_date = BizContext.getInstance().getBizDate();
        }
        Object[] accountingBookVOs = ((IAccountingBookPubService)AMProxy.lookup(IAccountingBookPubService.class)).queryAccountingBookByFinanceOrgIDAndDate(pk_org, business_date);
        boolean enableAssetMutiBook = ((IAPLicService)AMProxy.lookup(IAPLicService.class)).canEnableAssetMultiBook();
        if (enableAssetMutiBook) {
            return accountingBookVOs;
        }
        if (ArrayUtils.isBlank((Object[])accountingBookVOs)) {
            return null;
        }
        List<AccountingBookVO> collect = Arrays.stream(accountingBookVOs).filter(o -> o.getAccounttype() == 1).collect(Collectors.toList());
        return collect.toArray(new AccountingBookVO[0]);
    }
}

