/*
 * Decompiled with CFR 0.152.
 */
package nc.impl.fa.common.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.bs.am.framework.action.ActionContext;
import nc.bs.am.framework.action.IRule;
import nc.itf.fa.service.IAssetService;
import nc.vo.am.common.AMSuperVO;
import nc.vo.am.common.AbstractAggBill;
import nc.vo.am.common.itf.IAlterInfo;
import nc.vo.am.proxy.AMProxy;
import nc.vo.fa.common.AssetMultiAlterInfo;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDate;

public class WriteBackToCardhistoryAfterRule<E extends AbstractAggBill>
implements IRule<E> {
    protected boolean isApprove = false;

    public WriteBackToCardhistoryAfterRule(boolean isApprove) {
        this.isApprove = isApprove;
    }

    public void process(ActionContext<E> context, E ... aggVos) throws BusinessException {
        ArrayList<AssetMultiAlterInfo> alterInfo = new ArrayList<AssetMultiAlterInfo>();
        for (E aggVo : aggVos) {
            AssetMultiAlterInfo[] multiAlterInfos = this.createMultiAlterInfos(context, aggVo);
            if (multiAlterInfos == null || multiAlterInfos.length < 1) continue;
            alterInfo.addAll(Arrays.asList(multiAlterInfos));
        }
        if (alterInfo.size() > 0) {
            ((IAssetService)AMProxy.lookup(IAssetService.class)).writeBackInfoToAsset(alterInfo.toArray(new AssetMultiAlterInfo[0]), this.isApprove, null);
        }
    }

    protected AssetMultiAlterInfo[] createMultiAlterInfos(ActionContext<E> context, E aggVo) {
        AMSuperVO[] bodyVOs = (AMSuperVO[])aggVo.getChildrenVO();
        AMSuperVO headVO = (AMSuperVO)aggVo.getParentVO();
        String pk_accbook = (String)headVO.getAttributeValue("pk_accbook");
        UFDate business_date = (UFDate)headVO.getAttributeValue("business_date");
        AssetMultiAlterInfo[] multiAlterInfos = new AssetMultiAlterInfo[bodyVOs.length];
        for (int i = 0; i < bodyVOs.length; ++i) {
            String pk_card = (String)bodyVOs[i].getAttributeValue("pk_card");
            AssetMultiAlterInfo mai = new AssetMultiAlterInfo();
            mai.setPrimarykey(pk_card);
            mai.setPk_accbook(pk_accbook);
            mai.setBusiness_date(business_date);
            ArrayList<IAlterInfo> alterInfos = new ArrayList<IAlterInfo>();
            this.appendAlterInfo(headVO, bodyVOs[i], alterInfos);
            mai.setAlterInfos(alterInfos);
            multiAlterInfos[i] = mai;
        }
        return multiAlterInfos;
    }

    protected void appendAlterInfo(AMSuperVO headVO, AMSuperVO bodyVO, List<IAlterInfo> alterInfos) {
    }
}

