/*
 * Decompiled with CFR 0.152.
 */
package nc.impl.fa.asset.prealert.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.itf.fa.service.ICloseBookService;
import nc.pubitf.org.IAccountingBookPubService;
import nc.vo.am.common.BizContext;
import nc.vo.am.common.util.ArrayUtils;
import nc.vo.am.common.util.CollectionUtils;
import nc.vo.am.common.util.MapUtils;
import nc.vo.am.manager.AccperiodVO;
import nc.vo.am.manager.PeriodManager;
import nc.vo.am.proxy.AMProxy;
import nc.vo.logging.Debug;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDateTime;

public class PreAlertUtils {
    public static Map<String, List<String>> integrateOrgAndAccbook(String[] orgs, String[] accbooks) throws BusinessException {
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        List<String> accbookList = Arrays.asList(accbooks);
        if (ArrayUtils.isNotEmpty((Object[])orgs)) {
            for (String pk_org : orgs) {
                Object[] pk_accbooks_org = ((IAccountingBookPubService)AMProxy.lookup(IAccountingBookPubService.class)).queryAccountingBookIDSByFinanceOrgID(pk_org);
                if (ArrayUtils.isEmpty((Object[])pk_accbooks_org)) {
                    Debug.error((Object)("\u67e5\u8be2\u8d22\u52a1\u7ec4\u7ec7 " + pk_org + "\u5bf9\u5e94\u7684\u8d26\u7c3f\u4fe1\u606f\u4e3a\u7a7a \n "));
                    continue;
                }
                ArrayList<Object> filterAccbooks = new ArrayList<Object>();
                for (Object pk_accbook : pk_accbooks_org) {
                    if (!accbookList.contains(pk_accbook)) continue;
                    filterAccbooks.add(pk_accbook);
                }
                if (!CollectionUtils.isNotEmpty(filterAccbooks)) continue;
                returnMap.put(pk_org, filterAccbooks);
            }
        }
        return returnMap;
    }

    public static AccperiodVO queryMinUnClosebookPeriod(String pk_org, String pk_accbook) {
        AccperiodVO accperiodVO = null;
        try {
            accperiodVO = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).queryMinUnClosebookPeriod(pk_org, pk_accbook);
        }
        catch (BusinessException e) {
            Debug.error((Object)e.getMessage());
        }
        return accperiodVO;
    }

    public static Map<String, AccperiodVO> batchQueryMinUnCloseBookPeriod(String[] pk_accbooks) {
        Map accbook_accperiod = null;
        try {
            accbook_accperiod = ((ICloseBookService)AMProxy.lookup(ICloseBookService.class)).batchQueryMinUnCloseBookPeriod(pk_accbooks);
        }
        catch (BusinessException e) {
            Debug.error((Object)e.getMessage());
        }
        return accbook_accperiod;
    }

    public static String constructSqlByOrgAccbook(Map<String, List<String>> orgAccbookMap) throws BusinessException {
        String lastsql;
        UFDateTime sysDate = BizContext.getInstance().getServerDateTime();
        int sys_year = sysDate.getYear();
        int sys_month = sysDate.getMonth();
        int sys_year_month = Integer.parseInt(sys_year + (sys_month < 10 ? "0" + sys_month : "" + sys_month));
        StringBuffer last_sql = new StringBuffer();
        if (MapUtils.isNotEmpty(orgAccbookMap)) {
            for (Map.Entry<String, List<String>> entry : orgAccbookMap.entrySet()) {
                String pk_org = entry.getKey();
                String[] pk_accbooks = (String[])CollectionUtils.toArray((Collection)entry.getValue());
                Map<String, AccperiodVO> accbook_accperiod = PreAlertUtils.batchQueryMinUnCloseBookPeriod(pk_accbooks);
                if (!MapUtils.isNotEmpty(accbook_accperiod)) continue;
                for (Map.Entry<String, AccperiodVO> innerEntry : accbook_accperiod.entrySet()) {
                    String pk_accbook = innerEntry.getKey();
                    AccperiodVO minUnClosePeriod = innerEntry.getValue();
                    if (minUnClosePeriod == null) continue;
                    int min_year_month = Integer.parseInt(minUnClosePeriod.getAccyear() + minUnClosePeriod.getPeriod());
                    if (sys_year_month < min_year_month) {
                        AccperiodVO nextPeriod = PeriodManager.getInstance().getNextPeriod(pk_accbook, Integer.toString(sys_year), sys_month < 10 ? "0" + sys_month : "" + sys_month);
                        last_sql.append(" ( accyear = '" + nextPeriod.getAccyear() + "' and period = '" + nextPeriod.getPeriod() + "' and laststate_flag = 'N' and pk_accbook = '" + pk_accbook + "' and pk_org = '" + pk_org + "' )");
                    } else if (sys_year_month == min_year_month || sys_year_month > min_year_month) {
                        last_sql.append(" ( accyear = '" + minUnClosePeriod.getAccyear() + "' and period = '" + minUnClosePeriod.getPeriod() + "' and laststate_flag = 'Y' and pk_accbook = '" + pk_accbook + "' and pk_org = '" + pk_org + "' )");
                    }
                    last_sql.append(" or ");
                }
            }
        }
        if ((lastsql = last_sql.toString()).endsWith(" or ")) {
            lastsql = lastsql.substring(0, lastsql.length() - 3);
        }
        return lastsql;
    }
}

