/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.txmsgdata.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.web.fip.txmsgdata.action.CommonInfo;

public class QueryPageAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        CommonInfo info = (CommonInfo)json.fromJson(str, CommonInfo.class);
        AggTXBillVO[] vos = null;
        Grid grid = null;
        try {
            String[] relations = info.getRelationIDs();
            if (relations != null && relations.length > 0) {
                vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsBySrcRelationIDs(relations);
                vos = this.sort(vos, relations, "relationid");
            } else {
                vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsByPKs(info.getPk_bills());
                vos = this.sort(vos, info.getPk_bills(), "pk_txbill");
            }
            if (vos != null) {
                Object[] parent = new TXBillVO[vos.length];
                for (int i = 0; i < vos.length; ++i) {
                    parent[i] = vos[i].getParentVO();
                }
                GridOperator operator = new GridOperator(info.getPageId());
                grid = operator.toGrid(parent);
                this.processBillGridBillType(grid, (TXBillVO[])parent);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return grid;
    }

    private AggTXBillVO[] sort(AggTXBillVO[] vos, String[] ids, String pkString) {
        List voList;
        if (vos == null || ids == null || vos.length == 0 || ids.length == 0) {
            return vos;
        }
        HashMap<String, List> map = new HashMap<String, List>();
        for (AggTXBillVO vo : vos) {
            String pk = (String)vo.getParent().getAttributeValue(pkString);
            voList = map.computeIfAbsent(pk, k -> new ArrayList());
            voList.add(vo);
        }
        ArrayList reList = new ArrayList();
        for (String id : ids) {
            voList = (List)map.get(id);
            if (voList == null) continue;
            reList.addAll(voList);
        }
        return reList.toArray(new AggTXBillVO[0]);
    }

    private void processBillGridBillType(Grid grid, TXBillVO[] heads) throws BusinessException {
        Row[] rows = grid.getModel().getRows();
        for (int i = 0; i < rows.length; ++i) {
            Cell pkSystemCell;
            Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
            Cell cell2 = rows[i].getCell("pk_srctradetypeid");
            String pk_currbilltype = null;
            pk_currbilltype = cell2 != null && cell2.getValue() != null ? String.valueOf(cell2.getValue()) : String.valueOf(cell1.getValue());
            BilltypeVO billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
            if (billType != null) {
                Cell billtypeCell = new Cell();
                if (billType.istransaction != null && billType.istransaction.booleanValue()) {
                    BilltypeVO parentBillType;
                    String parentTypeCode = billType.getParentbilltype();
                    billtypeCell.setValue((Object)(billType.getPk_billtypecode() + "," + parentTypeCode));
                    if (StringUtils.isBlank((CharSequence)cell2.getDisplay())) {
                        cell2.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                    }
                    if (StringUtils.isBlank((CharSequence)cell1.getDisplay()) && (parentBillType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(parentTypeCode)) != null) {
                        cell1.setDisplay(FipLangTool.getCurrLangValue((SuperVO)parentBillType, (String)"billtypename"));
                    }
                } else {
                    billtypeCell.setValue((Object)billType.getPk_billtypecode());
                    if (StringUtils.isBlank((CharSequence)cell1.getDisplay())) {
                        cell1.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                    }
                }
                billtypeCell.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                rows[i].addCell("pk_currbilltype", billtypeCell);
            }
            if ((pkSystemCell = rows[i].getCell("pk_system")).getValue() != null && "EM".equals(pkSystemCell.getValue())) {
                pkSystemCell.setValue((Object)NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
            }
            if (pkSystemCell.getValue() != null && "YXY".equals(pkSystemCell.getValue())) {
                pkSystemCell.setValue((Object)NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
            }
            rows[i].addCell("pk_system", pkSystemCell);
        }
    }
}

