/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.txmsgdata.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.CloudFusionUtil;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillItemVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.form.Form;
import nccloud.web.fip.txmsgdata.action.CommonInfo;

public class QueryCardAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        CommonInfo info = (CommonInfo)json.fromJson(str, CommonInfo.class);
        AggTXBillVO[] vos = null;
        BillCard retcard = null;
        try {
            String relation = info.getRelationID();
            vos = relation != null ? ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsBySrcRelationIDs(new String[]{relation}) : ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsByPKs(new String[]{info.getPk_bill()});
            if (vos != null && vos.length > 0) {
                for (AggTXBillVO aggTXBillVO : vos) {
                    Object[] items;
                    HashMap<Integer, Object> bodyMap = new HashMap<Integer, Object>();
                    TXBillVO parent = (TXBillVO)aggTXBillVO.getParent();
                    if (parent != null && "EM".equals(parent.getPk_system())) {
                        parent.setPk_system(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
                    }
                    if (parent != null && "YXY".equals(parent.getPk_system())) {
                        parent.setPk_system(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
                    }
                    if (ArrayUtils.isNotEmpty((Object[])(items = aggTXBillVO.getBodyVOs()))) {
                        for (Object item : items) {
                            Integer rowNo = item.getRowno();
                            bodyMap.put(rowNo, item);
                        }
                    }
                    ArrayList keylist = new ArrayList();
                    keylist.addAll(bodyMap.keySet());
                    Collections.sort(keylist);
                    ArrayList<TXBillItemVO> bodyList = new ArrayList<TXBillItemVO>();
                    for (Integer key : keylist) {
                        TXBillItemVO item = (TXBillItemVO)bodyMap.get(key);
                        if (item == null) continue;
                        bodyList.add(item);
                    }
                    if (!CollectionUtils.isNotEmpty(bodyList)) continue;
                    aggTXBillVO.setChildrenVO((CircularlyAccessibleValueObject[])bodyList.toArray(new TXBillItemVO[0]));
                }
                retcard = this.afterProcess(info.getPagecode(), vos[0]);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return retcard;
    }

    private void processBillFormBillType(BillCard billCard) throws BusinessException {
        Form headForm = billCard.getHead();
        Row[] rows = headForm.getModel().getRows();
        for (int i = 0; i < rows.length; ++i) {
            Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
            Cell cell2 = rows[i].getCell("pk_srctradetypeid");
            String pk_currbilltype = null;
            pk_currbilltype = cell2 != null && cell2.getValue() != null ? String.valueOf(cell2.getValue()) : String.valueOf(cell1.getValue());
            BilltypeVO billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
            if (billType == null || !CloudFusionUtil.isCloudFusionProduct((String)billType.getSystemcode())) continue;
            Cell billtypeCell = new Cell();
            if (billType.istransaction != null && billType.istransaction.booleanValue()) {
                BilltypeVO parentBillType;
                String parentTypeCode = billType.getParentbilltype();
                billtypeCell.setValue((Object)(billType.getPk_billtypecode() + "," + parentTypeCode));
                if (StringUtils.isBlank((CharSequence)cell2.getDisplay())) {
                    cell2.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                }
                if (StringUtils.isBlank((CharSequence)cell1.getDisplay()) && (parentBillType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(parentTypeCode)) != null) {
                    cell1.setDisplay(FipLangTool.getCurrLangValue((SuperVO)parentBillType, (String)"billtypename"));
                }
            } else {
                billtypeCell.setValue((Object)billType.getPk_billtypecode());
                if (StringUtils.isBlank((CharSequence)cell1.getDisplay())) {
                    cell1.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                }
            }
            billtypeCell.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
            rows[i].addCell("pk_currbilltype", billtypeCell);
        }
    }

    private BillCard afterProcess(String pageid, Object vo) throws BusinessException {
        BillCardOperator operator = new BillCardOperator(pageid);
        operator.setTransFlag(Boolean.TRUE.booleanValue());
        BillCard billCard = operator.toCard(vo);
        this.processBillFormBillType(billCard);
        return billCard;
    }
}

