/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.txmsgdata.action;

import nc.itf.fip.opreatinglog.GenerateRelatedBillService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class QueryBillsByDesInfoAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);
        Object[] vos = null;
        Grid grid = null;
        try {
            GenerateRelatedBillService qservice = (GenerateRelatedBillService)ServiceLocator.find(GenerateRelatedBillService.class);
            vos = qservice.queryBill(info.getFipLink(), "src");
            if (vos == null || vos.length == 0) {
                ExceptionUtils.wrapBusinessException((String)NCLangRes4VoTransl.getNCLangRes().getStrByID("2006pub_0", "02006pub-0795"));
            }
            if (vos != null) {
                Object[] parent = new TXBillVO[vos.length];
                for (int i = 0; i < vos.length; ++i) {
                    parent[i] = ((AggTXBillVO)vos[i]).getParentVO();
                }
                GridOperator operator = new GridOperator(info.getPageId());
                grid = operator.toGrid(parent);
                this.processBillGridBillType(grid, (TXBillVO[])parent);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return grid;
    }

    private void processBillGridBillType(Grid grid, TXBillVO[] heads) {
        String pk_group = heads[0].getPk_group();
        Row[] rows = grid.getModel().getRows();
        for (int i = 0; i < rows.length; ++i) {
            Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
            Cell cell2 = rows[i].getCell("pk_srctradetypeid");
            String pk_currbilltype = null;
            pk_currbilltype = cell2 != null && cell2.getValue() != null ? String.valueOf(cell2.getValue()) : String.valueOf(cell1.getValue());
            BilltypeVO billType = null;
            try {
                billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
            }
            catch (BusinessException e) {
                ExceptionUtils.wrapException((Throwable)e);
            }
            if (billType == null) continue;
            Cell billtypeCell = new Cell();
            billtypeCell.setValue((Object)billType.getPk_billtypecode());
            billtypeCell.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
            rows[i].addCell("pk_currbilltype", billtypeCell);
        }
    }
}

