/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.txmsgdata.action;

import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.pub.CloudFusionUtil;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pubapp.pattern.model.entity.bill.IBill;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.platform.query.INCCloudQueryService;
import nccloud.web.fip.txmsgdata.action.PageQueryVO;
import nccloud.web.fip.txmsgdata.action.SearchInfo;
import nccloud.web.fip.util.PageUtil;

public class QueryAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        Grid grid = null;
        String str = request.read();
        IJson json = JsonFactory.create();
        SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);
        try {
            INCCloudQueryService qservice = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
            IQueryScheme scheme = qservice.convertCondition(info.getQueryInfo());
            AggTXBillVO[] vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).query(scheme);
            if (vos == null || vos.length == 0) {
                return null;
            }
            String[] pks = new String[vos.length];
            for (int i = 0; i < vos.length; ++i) {
                TXBillVO parent = vos[i].getParentVO();
                pks[i] = parent.getPk_txbill();
            }
            PageQueryVO qvo = new PageQueryVO(pks, (IBill[])vos);
            grid = this.convert(qvo, info);
            PageInfo pageInfo = new PageInfo();
            pageInfo.setTotal(pks.length);
            pageInfo.setPageSize(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue());
            pageInfo.setPageIndex(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageIndex()).intValue());
            pageInfo.setTotalPage(PageUtil.getTotalPage(pageInfo, pks.length));
            grid.getModel().setPageinfo(pageInfo);
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return grid;
    }

    private Grid convert(PageQueryVO result, SearchInfo info) throws BusinessException {
        IBill[] bills = result.getCurrentPageBills();
        int copySize = bills.length < Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()) ? bills.length : Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize());
        Grid grid = null;
        if (bills != null) {
            Object[] heads = new TXBillVO[copySize];
            for (int i = 0; i < copySize; ++i) {
                heads[i] = (TXBillVO)bills[i].getParent();
            }
            GridOperator operator = new GridOperator(info.getPagecode());
            grid = operator.toGrid(heads);
            this.processBillGridBillType(grid, (TXBillVO[])heads);
            grid.getModel().setAllpks(result.getPks());
        }
        return grid;
    }

    private void processBillGridBillType(Grid grid, TXBillVO[] heads) throws BusinessException {
        Row[] rows = grid.getModel().getRows();
        for (int i = 0; i < rows.length; ++i) {
            Cell pkSystemCell;
            Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
            Cell cell2 = rows[i].getCell("pk_srctradetypeid");
            String pk_currbilltype = null;
            pk_currbilltype = cell2 != null && cell2.getValue() != null ? String.valueOf(cell2.getValue()) : String.valueOf(cell1.getValue());
            BilltypeVO billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
            if (billType != null && CloudFusionUtil.isCloudFusionProduct((String)billType.getSystemcode())) {
                Cell billtypeCell = new Cell();
                if (billType.istransaction != null && billType.istransaction.booleanValue()) {
                    BilltypeVO parentBillType;
                    String parentTypeCode = billType.getParentbilltype();
                    billtypeCell.setValue((Object)(billType.getPk_billtypecode() + "," + parentTypeCode));
                    if (StringUtils.isBlank((CharSequence)cell2.getDisplay())) {
                        cell2.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                    }
                    if (StringUtils.isBlank((CharSequence)cell1.getDisplay()) && (parentBillType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(parentTypeCode)) != null) {
                        cell1.setDisplay(FipLangTool.getCurrLangValue((SuperVO)parentBillType, (String)"billtypename"));
                    }
                } else {
                    billtypeCell.setValue((Object)billType.getPk_billtypecode());
                    if (StringUtils.isBlank((CharSequence)cell1.getDisplay())) {
                        cell1.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                    }
                }
                billtypeCell.setDisplay(FipLangTool.getCurrLangValue((SuperVO)billType, (String)"billtypename"));
                rows[i].addCell("pk_currbilltype", billtypeCell);
            }
            if ((pkSystemCell = rows[i].getCell("pk_system")).getValue() != null && "EM".equals(pkSystemCell.getValue())) {
                pkSystemCell.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
            }
            if (pkSystemCell.getValue() != null && "YXY".equals(pkSystemCell.getValue())) {
                pkSystemCell.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
            }
            rows[i].addCell("pk_system", pkSystemCell);
        }
    }
}

