/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nccloud.web.fip.tree.TradeTypeRootNode;
import nccloud.web.uapbd.commons.tree.ITreeNode;
import nccloud.web.uapbd.commons.tree.TreeBuilder;

public class TradeTypeTreeBuilder
implements TreeBuilder {
    public static final String SYSTEM_FLAG = "sys";
    public static final String BILLTYPE_FLAG = "bill";
    Map<String, ITreeNode> nodeMap = new HashMap<String, ITreeNode>();

    public List<ITreeNode> buildTree(List<ITreeNode> treenodes) {
        for (ITreeNode iTreeNode : treenodes) {
            this.nodeMap.put(iTreeNode.getId(), iTreeNode);
        }
        TradeTypeRootNode rootNode = new TradeTypeRootNode(null, null, null, null);
        for (ITreeNode node : treenodes) {
            ITreeNode pnode = this.nodeMap.get(node.getPid());
            if (pnode != null) {
                node.setId(node.getId().substring(node.getId().indexOf(BILLTYPE_FLAG) + BILLTYPE_FLAG.length()));
                node.setPid(this.getIABillId(node.getPid().substring(node.getPid().indexOf(BILLTYPE_FLAG) + BILLTYPE_FLAG.length())));
                pnode.getChildren().add(node);
                continue;
            }
            node.setId(this.getIABillId(node.getId().substring(node.getId().indexOf(SYSTEM_FLAG) + SYSTEM_FLAG.length())));
            rootNode.getChildren().add(node);
        }
        Collection<ITreeNode> collection = rootNode.getChildren();
        if (collection != null) {
            collection.removeIf(next -> next.getChildren().isEmpty());
        }
        return new ArrayList<ITreeNode>(rootNode.getChildren());
    }

    private String getIABillId(String id) {
        String newId = "IA".equals(id) ? "IA_SYS" : id;
        return newId;
    }
}

