/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.ref;

import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.docview.IDocViewListService;
import nc.vo.fip.docview.DocViewListVO;
import nc.vo.fip.docview.SrcDocGroupVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.processor.refgrid.RefQueryInfo;
import nccloud.framework.web.ui.meta.RefMeta;
import nccloud.web.refer.DefaultGridRefAction;

public class DocViewListGridRef
extends DefaultGridRefAction {
    public static final String IS_LIACENTER_Y = "Y";

    public RefMeta getRefMeta(RefQueryInfo refQueryInfo) {
        RefMeta meta = new RefMeta();
        meta.setCodeField("viewcode");
        meta.setNameField("viewname");
        meta.setPkField("pk_classview");
        String[] columns = new String[]{"viewcode", "viewname"};
        meta.setExtraFields(columns);
        meta.setTableName("fip_docview");
        meta.setMutilLangNameRef(true);
        return meta;
    }

    public String getExtraSql(RefQueryInfo refQueryInfo, RefMeta refMeta) {
        try {
            Map param = refQueryInfo.getQueryCondition();
            String pkgroup = SessionContext.getInstance().getClientInfo().getPk_group();
            param = param == null ? new HashMap() : param;
            String pk_org = (String)param.get("pk_org");
            String pk_setorg1 = (String)param.get("pk_setorg1");
            String desBilltype = (String)param.get("des_billtype");
            String nodeType = (String)param.get("nodeType");
            String desdocid = (String)param.get("desdocid");
            String src_node = param.get("src_node") == null ? "" : (String)param.get("src_node");
            String isLiacenter = (String)param.get("isLiacenter");
            if (StringUtils.isNotEmpty((CharSequence)isLiacenter) && IS_LIACENTER_Y.equals(isLiacenter)) {
                return "";
            }
            boolean isFip = true;
            if (desBilltype == null || "".equals(desBilltype)) {
                desBilltype = "CM02";
                isFip = false;
            }
            if (nodeType == null || "".equals(nodeType)) {
                nodeType = "org";
            }
            if ("".equals(desdocid) || desdocid == null) {
                desdocid = "37e3adca-e0a0-4dff-82ea-63b335cf5515";
            }
            String orgEntityId = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("desdocid", desdocid);
            map.put("nodeType", nodeType);
            map.put("pkgroup", pkgroup);
            map.put("desBilltype", desBilltype);
            map.put("pk_setorg1", pk_setorg1);
            map.put("src_node", src_node);
            Map resultMap = ((IDocViewListService)ServiceLocator.find(IDocViewListService.class)).getDocViewListRefInfo(map);
            if (resultMap != null && resultMap.size() > 0) {
                orgEntityId = (String)resultMap.get("orgEntityId");
                pk_setorg1 = (String)resultMap.get("pk_setorg1");
            }
            String pk_srcdocid = (String)param.get("pk_srcdocid");
            String[] pk_srcdocidarr = null;
            if (StringUtils.isNotEmpty((CharSequence)pk_srcdocid)) {
                pk_srcdocidarr = pk_srcdocid.split(",");
            }
            if (!("4D19".equals(desBilltype) || "CM02".equals(desBilltype) || "CCA02".equals(desBilltype))) {
                orgEntityId = desBilltype;
            }
            StringBuilder sql = this.resetWherePart(pkgroup, pk_org, pk_setorg1, desdocid, pk_srcdocidarr, orgEntityId, isFip);
            return sql.toString();
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((String)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private StringBuilder resetWherePart(String pkgroup, String pkorg, String pk_setorg, String desdocid, String[] srcdocs, String orgType, boolean isFip) {
        StringBuilder sb = new StringBuilder();
        if (isFip) {
            sb.append(" and (pk_group='").append(pkgroup).append("' ");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pkorg})) {
                sb.append(" and pk_org in('").append(pkorg).append("','").append(pkgroup).append("') ");
            } else {
                sb.append(" and pk_org='").append(pkgroup).append("' ");
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgType})) {
                sb.append(" and (orgtype='").append(orgType).append("' or orgtype='~' )");
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pk_setorg})) {
                sb.append(" and (pk_setorg1='").append(pk_setorg).append("' or ").append("pk_setorg1").append("='~') ");
            }
            sb.append(" and desdocid='").append(desdocid).append("') ");
        } else {
            sb.append(" and ((pk_group='").append(pkgroup).append("' ");
            sb.append(" and pk_org='").append(pkorg).append("' ");
            sb.append(" and orgtype='5144b675-b681-4509-809e-6eb311db39b4' ) ");
            sb.append(" or pk_org='").append(pkgroup).append("') ");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pk_setorg})) {
                sb.append(" and pk_setorg1='").append(pk_setorg).append("' ");
            }
            sb.append(" and desdocid='").append(desdocid).append("' ");
        }
        if (srcdocs != null && srcdocs.length > 0) {
            int length = srcdocs.length;
            StringBuilder sb1 = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                String o = srcdocs[i];
                if (o == null) continue;
                sb1.append(" and a.pk_classview in (select pk_classview from ").append(SrcDocGroupVO.getDefaultTableName()).append(" where ").append("pk_srcdocid").append("='").append(o).append("' and ").append("pk_classview").append("=a.pk_classview and ").append("docindex").append("=").append(i + 1).append(" group by pk_classview having count(1)=1)");
            }
            String subsql = "select a.pk_classview from " + SrcDocGroupVO.getDefaultTableName() + " a where a.pk_classview=" + DocViewListVO.getDefaultTableName() + ".pk_classview" + sb1 + " group by a.pk_classview having count(1)=" + srcdocs.length;
            sb.append(" and pk_classview in (").append(subsql).append(")");
        } else if (isFip) {
            sb.append(" and 1=2 ");
        }
        return sb;
    }
}

