/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nc.itf.fip.cache.memcache.ReconSystemCache;
import nc.itf.fip.cache.memcache.ReconSystemMapCache;
import nc.vo.fip.reconsysreg.AggReconSystemMapVO;
import nc.vo.fip.reconsysreg.AggReconSystemVO;
import nc.vo.fip.reconsysreg.ReconAmtTypeRelationVO;
import nc.vo.fip.reconsysreg.ReconSysAmntTypeVO;
import nc.vo.fip.reconsysreg.ReconSysDefColVO;
import nc.vo.fip.reconsysreg.ReconSysOrgDimVO;
import nc.vo.fip.reconsysreg.ReconSystemVO;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;

public class ReconSystemUtil {
    public static ReconSystemSingleVO getReconSystem(String moduleId, String isSrc, String otherModuleId) {
        ReconSystemSingleVO singleVO = null;
        AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId((String)moduleId);
        if (Objects.nonNull(systemVO)) {
            singleVO = new ReconSystemSingleVO();
            singleVO.setReconsystem(systemVO.getParentVO(), "Y".equals(isSrc));
            singleVO.setAmttype((ReconSysAmntTypeVO[])systemVO.getChildren(ReconSysAmntTypeVO.class));
            singleVO.setOrgdim((ReconSysOrgDimVO[])systemVO.getChildren(ReconSysOrgDimVO.class));
            singleVO.setDefcols((ReconSysDefColVO[])systemVO.getChildren(ReconSysDefColVO.class));
            singleVO.setDim(systemVO.getReconSysDimVO());
            if (StringUtils.isNotEmpty((CharSequence)moduleId) && StringUtils.isNotEmpty((CharSequence)otherModuleId)) {
                AggReconSystemVO desSystemVO;
                AggReconSystemVO srcSystemVO;
                String desModulePK;
                String srcModulePk;
                AggReconSystemVO systemVO2 = ReconSystemCache.getReconSystemByModuleId((String)otherModuleId);
                if ("Y".equals(isSrc)) {
                    srcModulePk = systemVO.getParentVO().getPk_reconsystem();
                    desModulePK = systemVO2.getParentVO().getPk_reconsystem();
                    srcSystemVO = systemVO;
                    desSystemVO = systemVO2;
                } else {
                    srcModulePk = systemVO2.getParentVO().getPk_reconsystem();
                    desModulePK = systemVO.getParentVO().getPk_reconsystem();
                    srcSystemVO = systemVO2;
                    desSystemVO = systemVO;
                }
                AggReconSystemMapVO vo = ReconSystemMapCache.getReconSystemByModuleIdList((String)srcModulePk, (String)desModulePK);
                ReconAmtTypeRelationVO[] vos = vo.getReconAmtTypeRelationVO();
                singleVO.setAmtTypeList(srcSystemVO, desSystemVO, vos);
            }
        }
        return singleVO;
    }

    public static ReconSystemSingleVO getReconSystemOnlyAmtTypeList(String moduleId, String isSrc, String otherModuleId) {
        ReconSystemSingleVO singleVO = null;
        AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId((String)moduleId);
        if (Objects.nonNull(systemVO)) {
            singleVO = new ReconSystemSingleVO();
            if (StringUtils.isNotEmpty((CharSequence)moduleId) && StringUtils.isNotEmpty((CharSequence)otherModuleId)) {
                AggReconSystemVO desSystemVO;
                AggReconSystemVO srcSystemVO;
                String desModulePK;
                String srcModulePk;
                AggReconSystemVO systemVO2 = ReconSystemCache.getReconSystemByModuleId((String)otherModuleId);
                if ("Y".equals(isSrc)) {
                    srcModulePk = systemVO.getParentVO().getPk_reconsystem();
                    desModulePK = systemVO2.getParentVO().getPk_reconsystem();
                    srcSystemVO = systemVO;
                    desSystemVO = systemVO2;
                } else {
                    srcModulePk = systemVO2.getParentVO().getPk_reconsystem();
                    desModulePK = systemVO.getParentVO().getPk_reconsystem();
                    srcSystemVO = systemVO2;
                    desSystemVO = systemVO;
                }
                AggReconSystemMapVO vo = ReconSystemMapCache.getReconSystemByModuleIdList((String)srcModulePk, (String)desModulePK);
                ReconAmtTypeRelationVO[] vos = vo.getReconAmtTypeRelationVO();
                singleVO.setAmtTypeList(srcSystemVO, desSystemVO, vos);
            }
        }
        return singleVO;
    }

    public static List<ReconSystemSingleVO> getAllReconSystem(String isSrc) {
        ArrayList<ReconSystemSingleVO> reconSystemSingleVOList = new ArrayList<ReconSystemSingleVO>();
        Object[] aggReconSystemVOS = ReconSystemCache.getReconSystemByModuleByIsSrc((String)isSrc);
        if (ArrayUtils.isNotEmpty((Object[])aggReconSystemVOS)) {
            for (Object aggReconSystemVO : aggReconSystemVOS) {
                ReconSystemSingleVO singleVO = new ReconSystemSingleVO();
                reconSystemSingleVOList.add(singleVO);
                singleVO.setReconsystem(aggReconSystemVO.getParentVO(), "Y".equals(isSrc));
            }
        }
        return reconSystemSingleVOList;
    }

    public static List<ReconSystemSingleVO> getOnlyReconSystem(String[] moduleIds, String[] isSrc) {
        if (Objects.isNull(moduleIds)) {
            return new ArrayList<ReconSystemSingleVO>();
        }
        ArrayList<ReconSystemSingleVO> reconSystemSingleVOList = new ArrayList<ReconSystemSingleVO>();
        for (int i = 0; i < moduleIds.length; ++i) {
            ReconSystemSingleVO singleVO = ReconSystemUtil.getOnlyReconSystem(moduleIds[i], isSrc[i]);
            if (!Objects.nonNull(singleVO)) continue;
            reconSystemSingleVOList.add(singleVO);
        }
        return reconSystemSingleVOList;
    }

    public static ReconSystemSingleVO getOnlyReconSystem(String moduleId, String isSrc) {
        ReconSystemSingleVO singleVO = null;
        AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId((String)moduleId);
        if (Objects.nonNull(systemVO)) {
            singleVO = new ReconSystemSingleVO();
            singleVO.setReconsystem(systemVO.getParentVO(), UFBoolean.valueOf((String)isSrc).booleanValue());
        }
        return singleVO;
    }

    public static List<ReconSystemSingleVO> getReconSystemsWithAmtTypeMap(String[] moduleIds, String isSrc, String otherModuleId) {
        if (Objects.isNull(moduleIds)) {
            return new ArrayList<ReconSystemSingleVO>();
        }
        ArrayList<ReconSystemSingleVO> reconSystemSingleVOList = new ArrayList<ReconSystemSingleVO>();
        for (String moduleId : moduleIds) {
            ReconSystemSingleVO singleVO = ReconSystemUtil.getReconSystem(moduleId, isSrc, otherModuleId);
            if (!Objects.nonNull(singleVO)) continue;
            reconSystemSingleVOList.add(singleVO);
        }
        return reconSystemSingleVOList;
    }

    public static ReconSystemSingleVO[] getReconSystemVOs(String[] moduleIds, String isSrc) {
        ArrayList<ReconSystemSingleVO> singleVOs = new ArrayList<ReconSystemSingleVO>();
        Object[] systemVOs = ReconSystemCache.getReconSystemByModuleIdList((String[])moduleIds);
        if (ArrayUtils.isNotEmpty((Object[])systemVOs)) {
            for (Object systemVO : systemVOs) {
                ReconSystemSingleVO singleVO = new ReconSystemSingleVO();
                singleVOs.add(singleVO);
                singleVO.setReconsystem(systemVO.getParentVO(), "Y".equals(isSrc));
                singleVO.setAmttype((ReconSysAmntTypeVO[])systemVO.getChildren(ReconSysAmntTypeVO.class));
                singleVO.setOrgdim((ReconSysOrgDimVO[])systemVO.getChildren(ReconSysOrgDimVO.class));
                singleVO.setDefcols((ReconSysDefColVO[])systemVO.getChildren(ReconSysDefColVO.class));
            }
        }
        return singleVOs.toArray(new ReconSystemSingleVO[0]);
    }

    public static ReconSystemVO getLinkUrl(String moduleId, String isSrc) {
        AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId((String)moduleId);
        if ("Y".equals(isSrc)) {
            return systemVO.getParentVO();
        }
        return systemVO.getParentVO();
    }
}

