/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.pubitf.org.IOrgUnitPubService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nc.vo.fip.reconsetting.ReconSettingDefColVO;
import nc.vo.fip.reconsetting.ReconSettingVO;
import nc.vo.fip.reconsysreg.ReconSysDefColVO;
import nc.vo.fip.reconsysreg.ReconSystemCache;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.pub.BusinessException;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.collections.MapUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.GridModel;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCard;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.web.fip.reconwb.utils.ReconAmtUtil;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;

public class RcpSettingCardUtil {
    public static void afterToCard(ExtBillCard card, AggReconSettingVO reconSettingVO) throws BusinessException {
        RcpSettingCardUtil.setDesOrSrcSystemDisplayAndSysReg(card);
        RcpSettingCardUtil.setExcludesOrgAndDefColIntoCard(card, reconSettingVO);
        RcpSettingCardUtil.dealDimProperty(card);
    }

    public static void setCurrentLang(AggReconSettingVO aggReconSettingVO) throws BusinessException {
        String currentName;
        ReconSettingVO reconSettingVO = aggReconSettingVO.getParentVO();
        int currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq();
        String name = reconSettingVO.getName();
        if (StringUtils.isNotBlank((CharSequence)name) && currLangIndex != 1 && StringUtils.isBlank((CharSequence)(currentName = (String)reconSettingVO.getAttributeValue("name" + currLangIndex)))) {
            reconSettingVO.setAttributeValue("name" + currLangIndex, (Object)name);
        }
    }

    private static void dealDimProperty(ExtBillCard card) throws BusinessException {
        Grid bodyDimGrid = card.getBody("body_dim");
        if (Objects.isNull(bodyDimGrid) || Objects.isNull(bodyDimGrid.getModel())) {
            return;
        }
        List rows = bodyDimGrid.getModel().getListRows();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            for (Row row : rows) {
                RcpSettingCardUtil.setPropertyCell(row.getCell("pk_dim_src.metaid"), row.getCell("dim_src_proppath"));
                RcpSettingCardUtil.setPropertyCell(row.getCell("pk_dim_des.metaid"), row.getCell("dim_des_proppath"));
            }
        }
    }

    private static void setPropertyCell(Cell metaCell, Cell propertyCell) throws BusinessException {
        if (Objects.isNull(metaCell) || Objects.isNull(metaCell.getValue()) || Objects.isNull(propertyCell) || Objects.isNull(propertyCell.getValue())) {
            return;
        }
        String metaId = (String)metaCell.getValue();
        String property = (String)propertyCell.getValue();
        String name = ((IReconSettingService)ServiceLocator.find(IReconSettingService.class)).getDimPropertyName(metaId, property.split("#")[0]);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            propertyCell.setDisplay(name);
        }
    }

    public static void setDesOrSrcSystemDisplayAndSysReg(ExtBillCard card) {
        HashMap<String, ReconSystemSingleVO> reconSystemMap = new HashMap<String, ReconSystemSingleVO>(2);
        if (Objects.nonNull(card) && Objects.nonNull(card.getHead()) && Objects.nonNull(card.getHead().getModel())) {
            Object[] amtRows;
            Map values;
            String pk_system_des = null;
            String pk_system_src = null;
            List rows = card.getHead().getModel().getListRows();
            if (CollectionUtils.isNotEmpty((Collection)rows) && MapUtils.isNotEmpty((Map)(values = ((Row)rows.get(0)).getValues()))) {
                Cell desSystemCell = (Cell)values.get("pk_system_des");
                Cell desSystemNameCell = (Cell)values.get("pk_system_des.moduleid");
                if (Objects.nonNull(desSystemCell) && Objects.nonNull(desSystemNameCell) && Objects.nonNull(desSystemCell.getValue()) && StringUtils.isNotEmpty((CharSequence)desSystemNameCell.getDisplay())) {
                    desSystemCell.setDisplay(desSystemNameCell.getDisplay());
                    reconSystemMap.put("des_system", ReconSystemUtil.getReconSystem((String)desSystemCell.getValue(), "N", null));
                    pk_system_des = (String)desSystemCell.getValue();
                }
                Cell srcSystemCell = (Cell)values.get("pk_system_src");
                Cell srcSystemNameCell = (Cell)values.get("pk_system_src.moduleid");
                if (Objects.nonNull(srcSystemCell) && Objects.nonNull(srcSystemNameCell) && Objects.nonNull(srcSystemCell.getValue()) && StringUtils.isNotEmpty((CharSequence)srcSystemNameCell.getDisplay())) {
                    srcSystemCell.setDisplay(srcSystemNameCell.getDisplay());
                    reconSystemMap.put("src_system", ReconSystemUtil.getReconSystem((String)srcSystemCell.getValue(), "Y", null));
                    pk_system_src = (String)srcSystemCell.getValue();
                }
                if (StringUtils.isNotEmpty(pk_system_src) && StringUtils.isNotEmpty(pk_system_des)) {
                    reconSystemMap.put("amtType", ReconSystemUtil.getReconSystemOnlyAmtTypeList(pk_system_src, "Y", pk_system_des));
                }
            }
            if (Objects.nonNull(card.getBody("amounttype_table")) && Objects.nonNull(card.getBody("amounttype_table").getModel()) && ArrayUtils.isNotEmpty((Object[])(amtRows = card.getBody("amounttype_table").getModel().getRows()))) {
                for (Object row : amtRows) {
                    Cell srccell;
                    String formula_src;
                    Cell descell = row.getCell("formula_des");
                    String formula_des = (String)descell.getValue();
                    if (!StringUtils.isEmpty((CharSequence)formula_des)) {
                        String display_des = ReconAmtUtil.formulaTranslator(formula_des, pk_system_des);
                        descell.setDisplay(display_des);
                    }
                    if (StringUtils.isEmpty((CharSequence)(formula_src = (String)(srccell = row.getCell("formula_src")).getValue()))) continue;
                    String display_src = ReconAmtUtil.formulaTranslator(formula_src, pk_system_src);
                    srccell.setDisplay(display_src);
                }
            }
        }
        IJson json = JsonFactory.create();
        card.setUserjson(json.toJson(reconSystemMap));
    }

    public static void setExcludesOrgAndDefColIntoCard(ExtBillCard card, AggReconSettingVO reconSettingVO) throws BusinessException {
        if (Objects.isNull(reconSettingVO) || Objects.isNull(card.getHead()) || Objects.isNull(card.getHead().getModel())) {
            return;
        }
        GridModel model = card.getHead().getModel();
        List rows = model.getListRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        Row row = (Row)rows.get(0);
        int currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq();
        ArrayList<String> excludeOrgSrc = new ArrayList<String>();
        ArrayList<String> excludeOrgDes = new ArrayList<String>();
        ArrayList<String> pkList = new ArrayList<String>();
        Object[] reconSettingExcludeOrgVOs = reconSettingVO.getReconSettingExcludeOrgVO();
        if (ArrayUtils.isNotEmpty((Object[])reconSettingExcludeOrgVOs)) {
            for (Object vo : reconSettingExcludeOrgVOs) {
                if (vo.getDesorgflag().booleanValue()) {
                    excludeOrgDes.add(vo.getPk_org());
                } else {
                    excludeOrgSrc.add(vo.getPk_org());
                }
                pkList.add(vo.getPk_org());
            }
        }
        Map<String, String> displayMap = RcpSettingCardUtil.getOrgNameMap(pkList, currLangIndex);
        Cell des = new Cell();
        des.setValue((Object)String.join((CharSequence)",", excludeOrgDes));
        des.setDisplay(RcpSettingCardUtil.getDisplay(excludeOrgDes, displayMap));
        row.addCell("excludes_des", des);
        Cell src = new Cell();
        src.setValue((Object)String.join((CharSequence)",", excludeOrgSrc));
        src.setDisplay(RcpSettingCardUtil.getDisplay(excludeOrgSrc, displayMap));
        row.addCell("excludes_src", src);
        ArrayList<String> defColSrc = new ArrayList<String>();
        ArrayList<String> defColDes = new ArrayList<String>();
        ArrayList<String> defColSrcDisplay = new ArrayList<String>();
        ArrayList<String> defColDesDisplay = new ArrayList<String>();
        Cell reconSettingDefColVOs = reconSettingVO.getReconSettingDefColVO();
        if (ArrayUtils.isNotEmpty((Object[])reconSettingDefColVOs)) {
            int i = 99;
            for (Object vo : reconSettingDefColVOs) {
                if (vo.getSeq() != null) continue;
                vo.setSeq(Integer.valueOf(i++));
            }
            ReconSettingDefColVO[] newReconSettingDefColVOs = (ReconSettingDefColVO[])Arrays.stream(reconSettingDefColVOs).sorted(Comparator.comparingInt(ReconSettingDefColVO::getSeq)).toArray(ReconSettingDefColVO[]::new);
            ReconSystemCache instance = ReconSystemCache.getInstance();
            for (ReconSettingDefColVO vo : newReconSettingDefColVOs) {
                ReconSysDefColVO defColVO = instance.getSysDefColByPk(vo.getPk_defcol());
                if (vo.getDesflag().booleanValue()) {
                    defColDes.add(vo.getPk_defcol());
                    defColDesDisplay.add(RcpSettingCardUtil.getDefColDisplay(defColVO, currLangIndex));
                    continue;
                }
                defColSrc.add(vo.getPk_defcol());
                defColSrcDisplay.add(RcpSettingCardUtil.getDefColDisplay(defColVO, currLangIndex));
            }
        }
        des = new Cell();
        des.setValue((Object)String.join((CharSequence)",", defColDes));
        des.setDisplay(String.join((CharSequence)",", defColDesDisplay));
        row.addCell("defcol_des", des);
        src = new Cell();
        src.setValue((Object)String.join((CharSequence)",", defColSrc));
        src.setDisplay(String.join((CharSequence)",", defColSrcDisplay));
        row.addCell("defcol_src", src);
    }

    private static String getDisplay(List<String> valueList, Map<String, String> displayMap) {
        ArrayList<String> display = new ArrayList<String>();
        for (String s : valueList) {
            display.add(displayMap.getOrDefault(s, s));
        }
        return String.join((CharSequence)",", display);
    }

    private static String getDefColDisplay(ReconSysDefColVO defColVO, int currLangIndex) {
        if (Objects.isNull(defColVO)) {
            return null;
        }
        String display = currLangIndex == 1 ? defColVO.getName() : (String)defColVO.getAttributeValue("name" + currLangIndex);
        return display;
    }

    private static Map<String, String> getOrgNameMap(List<String> pkList, int currLangIndex) throws BusinessException {
        IOrgUnitPubService orgUnitPubService;
        Object[] orgs;
        HashMap<String, String> displayMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(pkList) && ArrayUtils.isNotEmpty((Object[])(orgs = (orgUnitPubService = (IOrgUnitPubService)ServiceLocator.find(IOrgUnitPubService.class)).getOrgs(pkList.toArray(new String[0]), null)))) {
            for (Object org : orgs) {
                String name = org.getName();
                String otherName = (String)org.getAttributeValue("name" + currLangIndex);
                String display = currLangIndex == 1 ? name : (StringUtils.isNotEmpty((CharSequence)otherName) ? otherName : name);
                displayMap.put(org.getPk_org(), display);
            }
        }
        return displayMap;
    }
}

