/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.ref;

import java.util.Map;
import nc.bs.sec.esapi.NCESAPI;
import nc.vo.fip.reconsysreg.ReconSystemVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.processor.refgrid.RefQueryInfo;
import nccloud.framework.web.processor.refgrid.RefQueryResult;
import nccloud.framework.web.ui.meta.RefMeta;
import nccloud.framework.web.ui.model.refgrid.RefRow;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.web.refer.DefaultGridRefAction;

public class ReconSystemGridRef
extends DefaultGridRefAction {
    public RefMeta getRefMeta(RefQueryInfo refQueryInfo) {
        RefMeta meta = new RefMeta();
        meta.setNameField("dap.systypename");
        meta.setCodeField("dap.systypecode");
        meta.setPkField("pk_reconsystem");
        meta.setTableName(ReconSystemVO.getDefaultTableName() + " recon left join dap_dapsystem dap on recon.moduleid=dap.moduleid ");
        meta.setExtraFields(new String[]{"dap.resid", "recon.moduleid"});
        return meta;
    }

    public String getExtraSql(RefQueryInfo refQueryInfo, RefMeta refMeta) {
        Map param = refQueryInfo.getQueryCondition();
        String src_system = (String)param.get("src_system");
        String des_system = (String)param.get("des_system");
        String isSrc = (String)param.get("isSrc");
        StringBuilder extraSql = new StringBuilder();
        if ("Y".equals(isSrc)) {
            extraSql.append(" recon.srcflag='Y'");
            if (!StringUtils.isEmpty((CharSequence)des_system)) {
                extraSql.append(" and recon.pk_reconsystem in (select pk_reconsystem_src from fip_reconsysmap where pk_reconsystem_des in ('" + NCESAPI.sqlEncode((String)des_system).replace(",", "','") + "'))");
            }
        } else {
            extraSql.append(" recon.desflag='Y'");
            if (!StringUtils.isEmpty((CharSequence)src_system)) {
                extraSql.append(" and recon.pk_reconsystem in (select pk_reconsystem_des from fip_reconsysmap where pk_reconsystem_src in ('" + NCESAPI.sqlEncode((String)src_system).replace(",", "','") + "'))");
            }
        }
        return extraSql.toString();
    }

    public <T> Object execute(IRequest request, T para) throws Exception {
        RefQueryResult refresult = (RefQueryResult)super.execute(request, para);
        RefRow[] rows = refresult.getRows();
        if (rows != null && rows.length > 0) {
            for (RefRow refRow : rows) {
                Cell residcell = (Cell)refRow.getValues().get("dap.resid");
                if (residcell == null) continue;
                String resid = (String)residcell.getValue();
                String modulename = NCLangRes4VoTransl.getNCLangRes().getStrByID("funcode", resid);
                refRow.setRefname(modulename);
            }
        }
        return refresult;
    }
}

