/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.ref;

import java.util.ArrayList;
import java.util.Map;
import nc.bs.logging.Logger;
import nc.bs.sec.esapi.NCESAPI;
import nc.itf.org.IAccountingBookQryService;
import nc.vo.fip.pub.SqlTools;
import nc.vo.fip.reconsetting.ReconSettingVO;
import nc.vo.org.AccountingBookVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.processor.refgrid.RefQueryInfo;
import nccloud.framework.web.ui.meta.RefMeta;
import nccloud.web.refer.DefaultGridRefAction;

public class ReconSettingRefAction
extends DefaultGridRefAction {
    public RefMeta getRefMeta(RefQueryInfo refQueryInfo) {
        RefMeta meta = new RefMeta();
        meta.setCodeField("code");
        meta.setNameField("name");
        meta.setPkField("pk_reconsetting");
        meta.setTableName(ReconSettingVO.getDefaultTableName());
        meta.setExtraFields(new String[]{"pk_system_des", "pk_system_src"});
        meta.setMutilLangNameRef(true);
        return meta;
    }

    public String getExtraSql(RefQueryInfo refQueryInfo, RefMeta refMeta) {
        Map param = refQueryInfo.getQueryCondition();
        String src_system = (String)param.get("src_system");
        String des_system = (String)param.get("des_system");
        String pk_org_des = (String)param.get("param_pk_org_des");
        String[] pkorgArray = null;
        if (!StringUtils.isEmpty((CharSequence)pk_org_des)) {
            pkorgArray = pk_org_des.split(",");
        }
        StringBuffer extraSql = new StringBuffer();
        String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
        extraSql.append("pk_group").append("='").append(NCESAPI.sqlEncode((String)pk_group)).append("' ");
        if (pkorgArray != null && pkorgArray.length > 0) {
            IAccountingBookQryService service = (IAccountingBookQryService)ServiceLocator.find(IAccountingBookQryService.class);
            AccountingBookVO[] books = null;
            try {
                books = service.queryVOsByPks(pkorgArray);
                if (books != null) {
                    ArrayList<String> pk_setofbooks = new ArrayList<String>();
                    for (AccountingBookVO vo : books) {
                        pk_setofbooks.add(vo.getPk_setofbook());
                    }
                    extraSql.append(" and ");
                    extraSql.append(" (");
                    Object inSql = null;
                    extraSql.append(SqlTools.getInStr((String)"pk_org_des", (String[])pkorgArray, (boolean)false));
                    extraSql.append(" or ");
                    extraSql.append(SqlTools.getInStr((String)"pk_setofbook_des", pk_setofbooks, (boolean)false));
                    extraSql.append(" )");
                }
            }
            catch (BusinessException e) {
                Logger.error((Object)e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)des_system)) {
            extraSql.append(" and ");
            extraSql.append("pk_system_des").append("='").append(NCESAPI.sqlEncode((String)des_system)).append("'");
        }
        if (!StringUtils.isEmpty((CharSequence)src_system)) {
            String[] src_systems = src_system.split(",");
            String inSql = null;
            try {
                inSql = SqlTools.getInStr((String)"pk_system_src", (String[])src_systems, (boolean)false);
            }
            catch (BusinessException e) {
                throw new RuntimeException(e);
            }
            if (extraSql.length() > 0 && inSql.length() > 0) {
                extraSql.append(" and ").append(inSql);
            }
        }
        return extraSql.toString();
    }
}

