/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import nc.itf.fip.reconwork.IReconWorkService;
import nc.ui.querytemplate.querytree.FromWhereSQL;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.reconwork.ReconworkResultVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.impl.platform.common.util.CollectionUtils;
import nccloud.pubitf.platform.query.INCCloudQueryService;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class RcpWorkQueryAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        Grid grid = null;
        IJson json = JsonFactory.create();
        SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
        if (Objects.isNull(info)) {
            return null;
        }
        INCCloudQueryService queryService = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
        IQueryScheme scheme = queryService.convertCondition(info.getQueryInfo());
        List conditionList = info.getQueryInfo().getQuerycondition().getConditions();
        String whereSQLOnly = scheme.getWhereSQLOnly();
        FromWhereSQL metasql = scheme.getTableJoinFromWhereSQL();
        String name = scheme.getName();
        IReconWorkService iReconWorkService = (IReconWorkService)ServiceLocator.find(IReconWorkService.class);
        try {
            ReconworkResultVO[] reconworkResults = iReconWorkService.findReconWorkList(conditionList, metasql);
            ArrayList<String> pks = new ArrayList<String>();
            HashMap<String, ReconworkResultVO> pkMap = new HashMap<String, ReconworkResultVO>();
            if (reconworkResults != null) {
                for (ReconworkResultVO vo : reconworkResults) {
                    pks.add(vo.getPk_reconsetting().trim());
                    pkMap.put(vo.getPk_reconsetting(), vo);
                }
                if (CollectionUtils.isNotEmpty(pks)) {
                    grid = this.toPageGrid(reconworkResults, info, pks);
                }
            }
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return grid;
    }

    private Grid toPageGrid(ReconworkResultVO[] reconworkResults, SearchInfo info, List<String> allPks) {
        GridOperator operator = new GridOperator(info.getPagecode());
        ArrayList<ReconworkResultVO> pageVos = new ArrayList<ReconworkResultVO>(Arrays.asList(reconworkResults).subList(0, reconworkResults.length));
        operator.setTransFlag(Boolean.TRUE.booleanValue());
        Grid grid = operator.toGrid(pageVos.toArray());
        grid.getModel().setAllpks(allPks.toArray(new String[0]));
        return grid;
    }
}

