/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nc.bs.framework.json.core.exception.ExceptionUtils;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.fip.pub.IModuleService;
import nc.pubitf.fip.service.IFipQueryService;
import nc.vo.fip.service.FipReconCheckBasicDataVO;
import nc.vo.fip.service.FipReconCheckQueryVO;
import nc.vo.fip.service.FipReconCheckResultVO;
import nc.vo.fip.service.FipReconWorkbenchTypeDataVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFDate;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.Condition;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.txmsgdata.action.SearchInfo;
import org.apache.commons.lang3.ArrayUtils;

public class RcpVoucherConvertQueryAction
implements ICommonAction {
    public static final String OPERATINGLOG_FAILURE = "failure";
    public static final String OPERATINGLOG_TEMPVOUCHER = "tempvoucher";
    public static final String OPERATINGLOG_ZERO_VALUE = "zero";

    public Object doAction(IRequest request) {
        IJson json = JsonFactory.create();
        SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
        if (info == null || info.getQueryInfo() == null || info.getQueryInfo().getQuerycondition() == null) {
            return null;
        }
        try {
            List conditionList = info.getQueryInfo().getQuerycondition().getConditions();
            if (conditionList != null) {
                FipReconCheckQueryVO rcpCondition = new FipReconCheckQueryVO();
                for (Condition con : conditionList) {
                    String firstvalue = con.getValue().getFirstvalue();
                    if (StringUtils.isEmpty((CharSequence)firstvalue)) continue;
                    switch (con.getField()) {
                        case "pk_des_system": {
                            rcpCondition.setDes_syscode(firstvalue);
                            break;
                        }
                        case "des_billtype": {
                            rcpCondition.setDes_billtype(this.getBillTypes(firstvalue)[0]);
                            break;
                        }
                        case "des_org": {
                            rcpCondition.setDes_orgs(firstvalue.split(","));
                            break;
                        }
                        case "pk_src_system": {
                            rcpCondition.setSrc_syscodes(this.getDevModulesBySystemPKs(firstvalue));
                            break;
                        }
                        case "src_billtype": {
                            rcpCondition.setSrc_billtypes(this.getBillTypes(firstvalue));
                            break;
                        }
                        case "src_org": {
                            rcpCondition.setSrc_orgs(firstvalue.split(","));
                            break;
                        }
                        case "src_busidate": {
                            rcpCondition.setBegindate(UFDate.getDate((String)firstvalue));
                            rcpCondition.setEnddate(UFDate.getDate((String)con.getValue().getSecondvalue()).asEnd());
                            break;
                        }
                    }
                }
                FipReconCheckResultVO[] result = ((IFipQueryService)ServiceLocator.find(IFipQueryService.class)).queryReconCheckData(rcpCondition);
                return this.disposeResult(result);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return null;
    }

    private Map<String, Object> disposeResult(FipReconCheckResultVO[] results) {
        if (ArrayUtils.isEmpty((Object[])results)) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (FipReconCheckResultVO result : results) {
            String des_billtype = result.getDes_billtype();
            Map dataMap = result.getDataMap();
            Iterator iterator = dataMap.entrySet().iterator();
            HashMap workbenchTypeDataMap = new HashMap();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Integer datatype = (Integer)entry.getKey();
                FipReconWorkbenchTypeDataVO workbenchTypeData = (FipReconWorkbenchTypeDataVO)entry.getValue();
                int checkdatanum = workbenchTypeData.getCheckdatanum() == null ? 0 : workbenchTypeData.getCheckdatanum();
                List basicDataList = workbenchTypeData.getData();
                String keyName = RcpVoucherConvertQueryAction.getKeyName(datatype);
                HashMap<String, Serializable> detailMap = (HashMap<String, Serializable>)workbenchTypeDataMap.get(keyName);
                int oriNum = 0;
                List oriPks = new ArrayList();
                if (detailMap == null) {
                    detailMap = new HashMap<String, Serializable>();
                } else {
                    oriNum = (Integer)detailMap.get("checkdatanum");
                    oriPks = (List)detailMap.get("pks");
                }
                checkdatanum = oriNum + checkdatanum;
                ArrayList<String> pks = new ArrayList<String>(oriPks);
                detailMap.put("checkdatanum", Integer.valueOf(checkdatanum));
                detailMap.put("pks", pks);
                if (CollectionUtils.isNotEmpty((Collection)basicDataList)) {
                    for (FipReconCheckBasicDataVO basicData : basicDataList) {
                        pks.add(basicData.getId());
                    }
                }
                workbenchTypeDataMap.put(keyName, detailMap);
            }
            resultMap.put("desbilltype", des_billtype);
            resultMap.put("workbenchdata", workbenchTypeDataMap);
        }
        return resultMap;
    }

    private static String getKeyName(Integer datatype) {
        String keyName = 1 == datatype || 2 == datatype ? OPERATINGLOG_FAILURE : (4 == datatype || 5 == datatype ? OPERATINGLOG_TEMPVOUCHER : OPERATINGLOG_ZERO_VALUE);
        return keyName;
    }

    private String[] getBillTypes(String billTypeIdStr) {
        IBillTypeService billTypeService = (IBillTypeService)ServiceLocator.find(IBillTypeService.class);
        ArrayList billtypes = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)billTypeIdStr)) {
            String[] pks = billTypeIdStr.split(",");
            try {
                billtypes.addAll(billTypeService.queryByPks(pks));
                ArrayList<String> billTypeList = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty(billtypes)) {
                    for (BilltypeVO billtype : billtypes) {
                        billTypeList.add(billtype.getPk_billtypecode());
                    }
                }
                if (billTypeList.isEmpty()) {
                    return new String[]{"NAV"};
                }
                return billTypeList.toArray(new String[0]);
            }
            catch (BusinessException e) {
                ExceptionUtils.wrapException((Throwable)e);
            }
        }
        return null;
    }

    private String[] getDevModulesBySystemPKs(String reconSystemStr) {
        IModuleService moduleService = (IModuleService)ServiceLocator.find(IModuleService.class);
        if (StringUtils.isNotEmpty((CharSequence)reconSystemStr)) {
            String[] pks = reconSystemStr.split(",");
            try {
                return moduleService.qrySysCodesByReconSysPKs(pks);
            }
            catch (BusinessException e) {
                ExceptionUtils.wrapException((Throwable)e);
            }
        }
        return null;
    }
}

