/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nc.vo.fip.reconsetting.ReconSettingDefColVO;
import nc.vo.fip.reconsetting.ReconSettingExcludeOrgVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.ISuperVO;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.ExtBillCardConvertProcessor;
import nccloud.framework.web.ui.model.GridModel;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCard;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCardOperator;
import nccloud.web.fip.reconwb.utils.RcpSettingCardUtil;

public class RcpSettingSaveAction
implements ICommonAction {
    public static final String EXCLUDE_ORG_KEY = "exclude_org";
    public static final String DEF_COL_KEY = "def_col";

    public Object doAction(IRequest request) {
        ExtBillCard billCard = (ExtBillCard)JsonFactory.create().fromJson(request.read(), ExtBillCard.class);
        ExtBillCardConvertProcessor processor = new ExtBillCardConvertProcessor();
        AggReconSettingVO aggBill = (AggReconSettingVO)processor.fromExtBillCard(billCard);
        IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);
        try {
            this.dealExcludesOrgAndDefCol(billCard, aggBill);
            AggReconSettingVO aggReconSetting = reconSettingService.saveBill(aggBill);
            if (aggReconSetting != null) {
                billCard = this.afterProcess(billCard.getPageid(), aggReconSetting);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return billCard;
    }

    private ExtBillCard afterProcess(String pageid, AggReconSettingVO vo) throws BusinessException {
        ExtBillCardOperator operator = new ExtBillCardOperator(pageid);
        operator.setTransFlag(Boolean.TRUE.booleanValue());
        ExtBillCard card = operator.toCard((Object)vo);
        RcpSettingCardUtil.afterToCard(card, vo);
        return card;
    }

    private void dealExcludesOrgAndDefCol(ExtBillCard billCard, AggReconSettingVO newReconSetting) {
        if (Objects.isNull(newReconSetting)) {
            return;
        }
        Object[] allBody = billCard.getAllBodys();
        if (ArrayUtils.isNotEmpty((Object[])allBody)) {
            for (Object grid : allBody) {
                Map values;
                ReconSettingExcludeOrgVO vo;
                Row[] rows;
                GridModel model = grid.getModel();
                if (!Objects.nonNull(model) || !ArrayUtils.isNotEmpty((Object[])model.getRows())) continue;
                if (EXCLUDE_ORG_KEY.equals(model.getAreacode())) {
                    ArrayList<ReconSettingExcludeOrgVO> excludeOrgVOList = new ArrayList<ReconSettingExcludeOrgVO>();
                    for (Row row : rows = model.getRows()) {
                        vo = new ReconSettingExcludeOrgVO();
                        values = row.getValues();
                        vo.setDesorgflag(UFBoolean.valueOf((String)((String)((Cell)values.get("desorgflag")).getValue())));
                        vo.setPk_org((String)((Cell)values.get("pk_org")).getValue());
                        vo.setPk_recon_exclude(Objects.nonNull(values.get("pk_recon_exclude")) ? (String)((Cell)values.get("pk_recon_exclude")).getValue() : null);
                        vo.setPk_reconsetting(Objects.nonNull(values.get("pk_reconsetting")) ? (String)((Cell)values.get("pk_reconsetting")).getValue() : null);
                        vo.setStatus(2);
                        excludeOrgVOList.add(vo);
                    }
                    newReconSetting.setChildren(ReconSettingExcludeOrgVO.class, (ISuperVO[])excludeOrgVOList.toArray(new ReconSettingExcludeOrgVO[0]));
                    continue;
                }
                if (!DEF_COL_KEY.equals(model.getAreacode())) continue;
                ArrayList<ReconSettingExcludeOrgVO> defColVOList = new ArrayList<ReconSettingExcludeOrgVO>();
                for (Row row : rows = model.getRows()) {
                    vo = new ReconSettingDefColVO();
                    values = row.getValues();
                    vo.setDesflag(UFBoolean.valueOf((String)((String)((Cell)values.get("desflag")).getValue())));
                    vo.setSeq(Integer.valueOf(Integer.parseInt((String)((Cell)values.get("seq")).getValue())));
                    vo.setPk_defcol((String)((Cell)values.get("pk_defcol")).getValue());
                    vo.setStatus(2);
                    defColVOList.add(vo);
                }
                newReconSetting.setChildren(ReconSettingDefColVO.class, (ISuperVO[])defColVOList.toArray(new ReconSettingDefColVO[0]));
            }
        }
    }
}

