/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import nc.bs.logging.Logger;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.reconsetting.PageTypeEnum;
import nc.vo.fip.reconsetting.ReconSettingVO;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.Condition;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.impl.platform.common.util.CollectionUtils;
import nccloud.pubitf.baseapp.apprbac.IAppAndOrgPermQueryPubService;
import nccloud.pubitf.platform.query.INCCloudQueryService;
import nccloud.web.fip.reconwb.utils.RcpSettingListPageUtil;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;
import nccloud.web.fip.txmsgdata.action.SearchInfo;
import nccloud.web.fip.util.PageUtil;

public class RcpSettingListQueryAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        Grid grid = null;
        IJson json = JsonFactory.create();
        SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
        if (Objects.isNull(info) || Objects.isNull(info.getQueryInfo()) || Objects.isNull(info.getQueryInfo().getQuerycondition())) {
            return null;
        }
        PageTypeEnum pageTypeEnum = PageTypeEnum.getPageType((String)info.getPageType());
        INCCloudQueryService queryService = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
        IQueryScheme scheme = queryService.convertCondition(info.getQueryInfo());
        IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);
        try {
            List<String> filteredOrgList = this.getPermOrgList(info, pageTypeEnum);
            ReconSettingVO[] reconSettings = reconSettingService.findReconSettingList(scheme, pageTypeEnum, filteredOrgList);
            ArrayList<String> pks = new ArrayList<String>();
            HashMap<String, ReconSettingVO> pkMap = new HashMap<String, ReconSettingVO>();
            for (ReconSettingVO vo : reconSettings) {
                pks.add(vo.getPk_reconsetting().trim());
                pkMap.put(vo.getPk_reconsetting(), vo);
            }
            if (CollectionUtils.isNotEmpty(pks)) {
                grid = this.toPageGrid(reconSettings, info, pks);
                RcpSettingListPageUtil.dealReconDimAndExcludeOrg(grid, pkMap);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return grid;
    }

    private Grid toPageGrid(ReconSettingVO[] reconSettings, SearchInfo info, List<String> allPks) {
        GridOperator operator = new GridOperator(info.getPagecode());
        int length = Integer.parseInt(info.getQueryInfo().getPageInfo().getPageSize());
        if (reconSettings.length < length) {
            length = reconSettings.length;
        }
        ArrayList<ReconSettingVO> pageVos = new ArrayList<ReconSettingVO>(Arrays.asList(reconSettings).subList(0, length));
        operator.setTransFlag(Boolean.TRUE.booleanValue());
        Grid grid = operator.toGrid(pageVos.toArray());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(allPks.size());
        pageInfo.setPageSize(Integer.parseInt(info.getQueryInfo().getPageInfo().getPageSize()));
        pageInfo.setPageIndex(0);
        pageInfo.setTotalPage(PageUtil.getTotalPage(pageInfo, allPks.size()));
        grid.getModel().setPageinfo(pageInfo);
        grid.getModel().setAllpks(allPks.toArray(new String[0]));
        return grid;
    }

    private List<String> getPermOrgList(SearchInfo info, PageTypeEnum pageTypeEnum) throws BusinessException {
        ArrayList<String> filteredOrgList = new ArrayList<String>();
        if (info == null || info.getQueryInfo() == null || info.getQueryInfo().getQuerycondition() == null) {
            return filteredOrgList;
        }
        List conditionList = info.getQueryInfo().getQuerycondition().getConditions();
        String moduleId = null;
        String desOrgStr = null;
        if (conditionList != null) {
            for (Condition condition : conditionList) {
                if (condition.getField().equals("pk_system_des")) {
                    moduleId = condition.getValue().getFirstvalue();
                    continue;
                }
                if (!condition.getField().equals("pk_org_des")) continue;
                desOrgStr = condition.getValue().getFirstvalue();
            }
        }
        if (pageTypeEnum == PageTypeEnum.ORG) {
            filteredOrgList.addAll(this.getPermOrg(info.getAppCode(), moduleId, desOrgStr));
        }
        return filteredOrgList;
    }

    private List<String> getPermOrg(String strAppCode, String moduleIds, String desOrgStr) throws BusinessException {
        List<ReconSystemSingleVO> systemSingleVOList;
        ArrayList<String> filteredOrgList = new ArrayList<String>();
        String strPk_group = SessionContext.getInstance().getClientInfo().getPk_group();
        String strPk_user = SessionContext.getInstance().getClientInfo().getUserid();
        if (StringUtils.isBlank((CharSequence)moduleIds)) {
            systemSingleVOList = ReconSystemUtil.getAllReconSystem("N");
        } else {
            String[] moduleIdArray = moduleIds.split(",");
            String[] isSrcArray = new String[moduleIdArray.length];
            Arrays.fill(isSrcArray, "N");
            systemSingleVOList = ReconSystemUtil.getOnlyReconSystem(moduleIdArray, isSrcArray);
        }
        ArrayList<String> orgTypeList = new ArrayList<String>();
        for (ReconSystemSingleVO reconSystemSingleVO : systemSingleVOList) {
            orgTypeList.add(reconSystemSingleVO.getReconsystem().getOrgtype());
        }
        if (!orgTypeList.isEmpty()) {
            HashSet hasPermOrg = new HashSet();
            for (String orgType : orgTypeList) {
                String[] orgs = null;
                try {
                    orgs = ((IAppAndOrgPermQueryPubService)ServiceLocator.find(IAppAndOrgPermQueryPubService.class)).queryUserPermOrgPksByAppAndWithOrgTypesFilter(strPk_user, strAppCode, new String[]{orgType}, strPk_group);
                }
                catch (BusinessException ex) {
                    Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                if (orgs == null || orgs.length <= 0) continue;
                Collections.addAll(hasPermOrg, orgs);
            }
            if (!hasPermOrg.isEmpty()) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{desOrgStr})) {
                    String[] stringArray;
                    for (String org : stringArray = desOrgStr.split(",")) {
                        if (!hasPermOrg.contains(org)) continue;
                        filteredOrgList.add(org);
                    }
                    if (filteredOrgList.isEmpty()) {
                        throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0049"));
                    }
                } else {
                    filteredOrgList.addAll(hasPermOrg);
                }
            }
        }
        return filteredOrgList;
    }
}

