/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.util.Objects;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCard;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCardOperator;
import nccloud.web.fip.reconwb.utils.RcpSettingCardUtil;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class RcpSettingCardQueryAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        ExtBillCard card = null;
        IJson json = JsonFactory.create();
        SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
        if (Objects.isNull(info)) {
            return null;
        }
        IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);
        try {
            AggReconSettingVO reconSetting = reconSettingService.findBillByPk(info.getPk_bill());
            if (Objects.nonNull(reconSetting.getParentVO())) {
                RcpSettingCardUtil.setCurrentLang(reconSetting);
                ExtBillCardOperator operator = new ExtBillCardOperator(info.getPagecode());
                card = operator.toCard((Object)reconSetting);
                RcpSettingCardUtil.afterToCard(card, reconSetting);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return card;
    }
}

