/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.itf.fip.pub.IModuleService;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;
import org.apache.commons.lang3.ArrayUtils;

public class OrgrefQueryByModuleIdAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
        List moduleIds = (List)paramMap.get("moduleid");
        String isSrc = (String)paramMap.get("isSrc");
        try {
            Object[] systemVOs = ReconSystemUtil.getReconSystemVOs(moduleIds.toArray(new String[0]), isSrc);
            HashSet<String> orgRefSet = new HashSet<String>();
            HashSet<String> orgTypeSet = new HashSet<String>();
            if (ArrayUtils.isNotEmpty((Object[])systemVOs)) {
                for (Object systemVO : systemVOs) {
                    ReconSystemSingleVO.SingleSystemVO singleSystemVO = systemVO.getReconsystem();
                    if (singleSystemVO == null) continue;
                    orgRefSet.add(singleSystemVO.getOrgref());
                    orgTypeSet.add(singleSystemVO.getOrgtype());
                }
            }
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if ("Y".equals(isSrc)) {
                resultMap.putAll(((IModuleService)ServiceLocator.find(IModuleService.class)).getBillTypeByModuleIds(moduleIds.toArray(new String[0])));
            } else {
                resultMap.put("orgtype", orgTypeSet.size() == 1 ? orgTypeSet.toArray(new String[0])[0] : null);
            }
            resultMap.put("orgref", orgRefSet.size() == 1 ? orgRefSet.toArray(new String[0])[0] : null);
            return resultMap;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }
}

