/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.itf.fip.pub.IModuleService;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nccloud.commons.collections.CollectionUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;
import org.apache.commons.lang3.ArrayUtils;

public class OrgRefQueryByPkAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
        List modulePksList = (List)paramMap.get("modulePks");
        List isSrcList = (List)paramMap.get("isSrc");
        try {
            ArrayList resultMapList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)modulePksList)) {
                for (int i = 0; i < modulePksList.size(); ++i) {
                    String modulePks = (String)modulePksList.get(i);
                    String isSrc = (String)isSrcList.get(i);
                    Object[] systemVOs = ReconSystemUtil.getReconSystemVOs(modulePks.split(","), isSrc);
                    HashSet<String> orgRefSet = new HashSet<String>();
                    HashSet<String> orgTypeSet = new HashSet<String>();
                    ArrayList<String> moduleIds = new ArrayList<String>();
                    if (ArrayUtils.isNotEmpty((Object[])systemVOs)) {
                        for (Object systemVO : systemVOs) {
                            ReconSystemSingleVO.SingleSystemVO singleSystemVO = systemVO.getReconsystem();
                            if (singleSystemVO == null) continue;
                            orgRefSet.add(singleSystemVO.getOrgref());
                            orgTypeSet.add(singleSystemVO.getOrgtype());
                            moduleIds.add(singleSystemVO.getModuleid());
                        }
                    }
                    Map<String, String> resultMap = new HashMap<String, String>();
                    if ("Y".equals(isSrc)) {
                        if (CollectionUtils.isNotEmpty(moduleIds)) {
                            resultMap = ((IModuleService)ServiceLocator.find(IModuleService.class)).getBillTypeByModuleIds(moduleIds.toArray(new String[0]));
                            resultMap.put("moduleIds", String.join((CharSequence)",", moduleIds));
                        }
                    } else {
                        resultMap.put("orgtype", orgTypeSet.size() == 1 ? orgTypeSet.toArray(new String[0])[0] : null);
                    }
                    resultMap.put("isSrc", isSrc);
                    resultMap.put("orgref", orgRefSet.size() == 1 ? orgRefSet.toArray(new String[0])[0] : null);
                    resultMapList.add(resultMap);
                }
            }
            return resultMapList;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }
}

