/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.pfxxsysconf.action;

import java.util.HashMap;
import java.util.List;
import nc.itf.org.IGroupQryService;
import nc.pubitf.rbac.IUserPubService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.pub.FipStringUtils;
import nc.vo.org.GroupVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.sm.UserVO;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;

public class TranslateUtil {
    public static void translate(BillCard billcard) throws BusinessException {
        List rows = billcard.getHead().getModel().getListRows();
        TranslateUtil.translateGroup(rows);
        TranslateUtil.translateUser(rows);
    }

    private static void translateUser(List<Row> rows) throws BusinessException {
        HashMap<String, String> userMap = new HashMap<String, String>();
        for (Row row : rows) {
            Cell modifier;
            Cell creator = row.getCell("creator");
            if (TranslateUtil.notEmptyCellValue(creator)) {
                userMap.put(creator.getValue().toString(), null);
            }
            if (!TranslateUtil.notEmptyCellValue(modifier = row.getCell("modifier"))) continue;
            userMap.put(modifier.getValue().toString(), null);
        }
        if (!userMap.isEmpty()) {
            UserVO[] users = ((IUserPubService)ServiceLocator.find(IUserPubService.class)).getUsersByPKs(userMap.keySet().toArray(new String[0]));
            if (users != null && users.length > 0) {
                for (UserVO user : users) {
                    if (user == null) continue;
                    String userid = user.getCuserid();
                    String name = FipLangTool.getCurrLangValue((SuperVO)user, (String)"user_name");
                    userMap.put(userid, name);
                }
            }
            for (Row row : rows) {
                Cell creator = row.getCell("creator");
                Cell modifier = row.getCell("modifier");
                if (TranslateUtil.notEmptyCellValue(creator) && !FipStringUtils.isEmpty((String)((String)userMap.get(creator.getValue().toString())))) {
                    creator.setDisplay((String)userMap.get(creator.getValue().toString()));
                }
                if (!TranslateUtil.notEmptyCellValue(modifier) || FipStringUtils.isEmpty((String)((String)userMap.get(modifier.getValue().toString())))) continue;
                modifier.setDisplay((String)userMap.get(modifier.getValue().toString()));
            }
        }
    }

    private static void translateGroup(List<Row> rows) throws BusinessException {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        for (Row row : rows) {
            Cell org = row.getCell("pk_org");
            if (!TranslateUtil.notEmptyCellValue(org)) continue;
            groupMap.put(org.getValue().toString(), null);
        }
        if (!groupMap.isEmpty()) {
            GroupVO[] groups = ((IGroupQryService)ServiceLocator.find(IGroupQryService.class)).queryGroupVOsByPKS(groupMap.keySet().toArray(new String[0]));
            if (groups != null && groups.length > 0) {
                for (GroupVO group : groups) {
                    if (group == null) continue;
                    String pk = group.getPk_group();
                    String name = FipLangTool.getCurrLangValue((SuperVO)group, (String)"name");
                    groupMap.put(pk, name);
                }
            }
            for (Row row : rows) {
                Cell org = row.getCell("pk_org");
                if (!TranslateUtil.notEmptyCellValue(org) || FipStringUtils.isEmpty((String)((String)groupMap.get(org.getValue().toString())))) continue;
                org.setDisplay((String)groupMap.get(org.getValue().toString()));
            }
        }
    }

    private static boolean notEmptyCellValue(Cell cell) {
        return cell != null && cell.getValue() != null && !FipStringUtils.isEmpty((String)cell.getValue().toString());
    }
}

