/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.orgrule.action;

import nc.vo.fip.pub.ExtBillTypeVO;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.SuperVO;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.sm.funcreg.ModuleVO;
import nccloud.web.uapbd.commons.tree.TreeBuilder;
import nccloud.web.uapbd.commons.tree.TreeWapper;

public class OrgruleNodeWapper
extends TreeWapper<ExtBillTypeVO> {
    public static final String SYSTEM_FLAG = "sys";
    public static final String BILLTYPE_FLAG = "bill";

    public OrgruleNodeWapper(ExtBillTypeVO[] objs) {
        super((Object[])objs);
    }

    public OrgruleNodeWapper(ExtBillTypeVO[] objs, TreeBuilder builder) {
        super((Object[])objs, builder);
    }

    protected String getId(ExtBillTypeVO t) {
        String subkey = t.isSystem() ? SYSTEM_FLAG : BILLTYPE_FLAG;
        return subkey + t.getPrimaryKey();
    }

    protected String getName(ExtBillTypeVO t) {
        if (t.isSystem()) {
            ModuleVO movo = (ModuleVO)t.getDataVO();
            return movo.getResid() == null ? movo.getSystypename() : NCLangRes4VoTransl.getNCLangRes().getString("funcode", movo.getSystypename(), movo.getResid());
        }
        BilltypeVO billtype = (BilltypeVO)t.getDataVO();
        return billtype.getPk_billtypecode() + " " + FipLangTool.getCurrLangValue((SuperVO)t, (String)"billtypename");
    }

    public String getCode(ExtBillTypeVO t) {
        if (t.isSystem()) {
            ModuleVO movo = (ModuleVO)t.getDataVO();
            return movo.getModuleid();
        }
        BilltypeVO billtype = (BilltypeVO)t.getDataVO();
        return billtype.getPk_billtypecode();
    }

    protected String getPid(ExtBillTypeVO t) {
        if (t.isSystem()) {
            return null;
        }
        BilltypeVO billtype = (BilltypeVO)t.getDataVO();
        if (billtype.getIstransaction() == null || !billtype.getIstransaction().booleanValue()) {
            return SYSTEM_FLAG + billtype.getSystemcode();
        }
        return BILLTYPE_FLAG + billtype.getParentbilltype();
    }

    protected String getInnercode(ExtBillTypeVO t) {
        if (t.isSystem()) {
            return null;
        }
        BilltypeVO billtype = (BilltypeVO)t.getDataVO();
        if (billtype.getIstransaction() == null || !billtype.getIstransaction().booleanValue()) {
            return "false";
        }
        return "true";
    }
}

