/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.operatinglog.action;

import com.yonyou.cloud.ncc.NCCEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import nc.itf.fip.opreatinglog.IOperatingLog;
import nc.pubitf.fip.service.IFipMessageService;
import nc.vo.fip.operatinglogs.OperatingFlagEmu;
import nc.vo.fip.operatinglogs.OperatingLogVO;
import nc.vo.fip.pub.SqlTools;
import nc.vo.fip.service.FipBasicRelationVO;
import nc.vo.fip.service.FipMessageVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.ui.pattern.grid.GridOperator;

public class OperatingLogGenerateAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        GridOperator operator = new GridOperator();
        HashMap<String, List> map = new HashMap<String, List>();
        ArrayList<String> list = new ArrayList<String>();
        String global_batchno = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            SessionContext.getInstance().setAppcode("10170412");
            OperatingLogVO[] vos = (OperatingLogVO[])operator.toVos(request);
            if (vos != null && vos.length > 0) {
                if (!NCCEnv.isMerged()) {
                    global_batchno = vos[0].getBatchno();
                }
                String[] pks = new String[vos.length];
                for (int i = 0; i < vos.length; ++i) {
                    pks[i] = vos[i].getPk_operatinglog();
                }
                vos = ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).queryByPKs(pks);
                if (vos == null) {
                    vos = new OperatingLogVO[]{};
                }
                HashSet<String> groupIdSet = new HashSet<String>();
                for (OperatingLogVO vo : vos) {
                    if (!Objects.equals(vo.getOperateflag(), OperatingFlagEmu.FLAG_INIT_ERROR)) {
                        if (Objects.equals(vo.getOperateflag(), OperatingFlagEmu.FLAG_INIT) || Objects.equals(vo.getOperateflag(), OperatingFlagEmu.FLAG_INIT_RUNNING) || Objects.equals(vo.getOperateflag(), OperatingFlagEmu.FLAG_DELETE_RUNNING)) continue;
                        list.add(vo.getPk_operatinglog());
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getBatchno())) {
                        groupIdSet.add(vo.getBatchno());
                        continue;
                    }
                    List opvos = map.computeIfAbsent(vo.getSrc_billtype(), k -> new ArrayList());
                    opvos.add(vo);
                }
                IOperatingLog logService = (IOperatingLog)ServiceLocator.find(IOperatingLog.class);
                if (!list.isEmpty()) {
                    paramMap.put("pklist", list);
                    paramMap.put("isUseOrgRule", false);
                    paramMap.put("sagas_batchno", global_batchno);
                    logService.recomputeByPKs(paramMap);
                }
                OperatingLogVO[] batchLogvos = null;
                if (!groupIdSet.isEmpty()) {
                    String wherepart_oplog = " " + SqlTools.getInStr((String)"batchno", new ArrayList(groupIdSet), (boolean)false);
                    batchLogvos = logService.queryByWhere(wherepart_oplog);
                }
                if (batchLogvos != null) {
                    for (OperatingLogVO logvo : batchLogvos) {
                        List opvos = map.computeIfAbsent(logvo.getGroupid(), k -> new ArrayList());
                        opvos.add(logvo);
                    }
                }
                if (!map.isEmpty()) {
                    for (List volist : map.values()) {
                        FipMessageVO[] messagevos = this.convertVOs(volist);
                        ((IFipMessageService)ServiceLocator.find(IFipMessageService.class)).sendMessages(messagevos);
                    }
                }
                return "success";
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return null;
    }

    private FipMessageVO[] convertVOs(List<OperatingLogVO> vos) {
        ArrayList<FipMessageVO> messagevoList = new ArrayList<FipMessageVO>();
        if (vos != null && !vos.isEmpty()) {
            for (OperatingLogVO logvo : vos) {
                FipMessageVO vo = new FipMessageVO();
                vo.setMessageinfo(FipBasicRelationVO.convertFromOperatingVO((OperatingLogVO)logvo).getSrcRelation());
                vo.setMessagetype(0);
                messagevoList.add(vo);
            }
        }
        return messagevoList.toArray(new FipMessageVO[0]);
    }
}

