/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.HashSet;
import java.util.LinkedHashMap;
import nc.bs.logging.Logger;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.processor.refgrid.RefQueryInfo;
import nccloud.framework.web.processor.refgrid.RefQueryResult;
import nccloud.framework.web.processor.reftree.TreeRefQueryInfo;
import nccloud.framework.web.ui.meta.RefMeta;
import nccloud.framework.web.ui.meta.TreeRefMeta;
import nccloud.framework.web.ui.model.refgrid.RefRow;
import nccloud.framework.web.ui.model.reftree.TreeRefRow;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.pubitf.web.refer.INCCRefQry;
import nccloud.web.refer.DefaultTreeRefAction;
import nccloud.web.refer.RefHelper;

public class TranstypeTreeRefAction
extends DefaultTreeRefAction {
    private static ThreadLocal<Integer> local = new ThreadLocal();
    private static final String IAIA = "IAIA";
    private static final Integer SEARCH_PK_NO = -1;
    private static final Integer SEARCH_PK_SPECIAL_NO = 0;
    private static final Integer SEARCH_PK_SPECIAL_IA = 1;
    private static final Integer SEARCH_PK_SPECIAL_IAIA = 2;
    private static final Integer SEARCH_PK_SPECIAL_ALL = 3;

    public TreeRefMeta getRefMeta(RefQueryInfo refQueryInfo) {
        TreeRefMeta meta = new TreeRefMeta();
        String strDataPowerSQL = null;
        String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
        String userId = SessionContext.getInstance().getClientInfo().getUserid();
        try {
            strDataPowerSQL = ((INCCRefQry)ServiceLocator.find(INCCRefQry.class)).getRefDataPowerSQL("bd_billtype", "pk_billtypeid", "transtype", "fip", pk_group, userId);
        }
        catch (BusinessException var8) {
            Logger.error((Object)var8.getMessage(), (Throwable)var8);
        }
        StringBuffer tableName = new StringBuffer();
        tableName.append("( select systypecode, systypename, systypecode moduleid, 'rootSon' parentcode, null parentbilltype,resid from dap_dapsystem where ( systypecode in ( select distinct bd_billtype.systemcode from bd_billtype ) )").append(" union all ").append("select pk_billtypecode systypecode, " + RefHelper.getMultiLangNameSQL((String)"billtypename") + " as systypename, pk_billtypeid moduleid, systemcode parentcode ,parentbilltype parentbilltype,null resid  from bd_billtype where ").append(" ( ( pk_group = '").append(SessionContext.getInstance().getClientInfo().getPk_group()).append("' or (pk_group is null or pk_group='~') )) ").append(" and isaccount = 'Y'");
        if (strDataPowerSQL != null) {
            tableName.append(" and ").append(strDataPowerSQL);
        }
        tableName.append(" )  sys ");
        meta.setPkField("moduleid");
        meta.setCodeField("systypecode");
        meta.setNameField("systypename");
        meta.setPidField("parentcode");
        meta.setTableName(tableName.toString());
        meta.setExtraFields(new String[]{"parentbilltype", "resid"});
        this.setSearchPkSpecial(refQueryInfo);
        return meta;
    }

    private void setSearchPkSpecial(RefQueryInfo refQueryInfo) {
        Integer searchPkSpecial = SEARCH_PK_NO;
        String[] searchPks = refQueryInfo.getSearchPks();
        if (searchPks != null) {
            searchPkSpecial = SEARCH_PK_SPECIAL_NO;
            for (int i = 0; i < searchPks.length; ++i) {
                String searchPk = searchPks[i];
                if (IAIA.equals(searchPk)) {
                    searchPks[i] = "IA";
                    refQueryInfo.setSearchPks(searchPks);
                    if (searchPkSpecial == SEARCH_PK_SPECIAL_NO) {
                        searchPkSpecial = SEARCH_PK_SPECIAL_IAIA;
                        continue;
                    }
                    searchPkSpecial = SEARCH_PK_SPECIAL_ALL;
                    continue;
                }
                if (!"IA".equals(searchPk)) continue;
                searchPkSpecial = searchPkSpecial == SEARCH_PK_SPECIAL_NO ? SEARCH_PK_SPECIAL_IA : SEARCH_PK_SPECIAL_ALL;
            }
        }
        local.set(searchPkSpecial);
    }

    public String getOrderSql(RefQueryInfo refQueryInfo, RefMeta refMeta) {
        return " order by systypecode";
    }

    public String getExtraSql(RefQueryInfo para, RefMeta meta) {
        StringBuffer sql = new StringBuffer();
        return sql.toString();
    }

    protected RefQueryResult processData(TreeRefQueryInfo refQueryInfo) {
        RefQueryResult result = super.processData(refQueryInfo);
        LinkedHashMap<String, TreeRefRow> mapCode = new LinkedHashMap<String, TreeRefRow>();
        LinkedHashMap<String, RefRow> mapPk = new LinkedHashMap<String, RefRow>();
        LinkedHashMap<String, TreeRefRow> mapPid = new LinkedHashMap<String, TreeRefRow>();
        Integer searchPkSpecial = local.get();
        HashSet<String> setCode = new HashSet<String>();
        for (RefRow rows : result.getRows()) {
            TreeRefRow row = (TreeRefRow)rows;
            Object resid = ((Cell)rows.getValues().get("resid")).getValue();
            if (resid != null && resid.toString().trim().length() != 0) {
                rows.setRefname(NCLangRes4VoTransl.getNCLangRes().getString("funcode", rows.getRefname(), resid.toString()));
            }
            if ((row.getPid() == null || row.getPid().trim().length() == 0) && searchPkSpecial == SEARCH_PK_NO) {
                row.setPid("rootSon");
                mapPid.put(row.getRefpk(), row);
            }
            if (row.getRefname() == null || row.getRefname().trim().length() == 0) {
                row.setRefname(row.getRefcode());
            }
            if ("IA".equals(row.getRefpk()) && "rootSon".equals(row.getPid())) {
                row.setRefpk(IAIA);
                if (searchPkSpecial == SEARCH_PK_SPECIAL_IA) continue;
            }
            if ("IA".equals(row.getPid())) {
                row.setPid(IAIA);
                row.setIsleaf(true);
                if (searchPkSpecial == SEARCH_PK_SPECIAL_IAIA) continue;
            }
            if (((Cell)row.getValues().get("parentbilltype")).getValue() != null && ((Cell)row.getValues().get("parentbilltype")).getValue().toString().trim().length() > 0) {
                setCode.add(((Cell)row.getValues().get("parentbilltype")).getValue().toString().trim());
            }
            mapPk.put(row.getRefpk(), rows);
            mapCode.put(row.getRefcode(), row);
        }
        if (refQueryInfo.getSearchPks() == null && StringUtils.isEmpty((CharSequence)refQueryInfo.getKeyword())) {
            for (RefRow rows : mapPk.values()) {
                RefRow treeRef;
                TreeRefRow row = (TreeRefRow)rows;
                if (((Cell)row.getValues().get("parentbilltype")).getValue() != null && ((Cell)row.getValues().get("parentbilltype")).getValue().toString().trim().length() > 0 && (treeRef = (RefRow)mapCode.get(((Cell)row.getValues().get("parentbilltype")).getValue().toString())) != null) {
                    row.setPid(treeRef.getRefpk());
                }
                if (setCode.contains(row.getRefcode())) {
                    row.setIsleaf(false);
                }
                mapPid.remove(row.getPid());
            }
            if (mapPid.size() > 0) {
                for (String key : mapPid.keySet()) {
                    if ("IA".equals(key)) continue;
                    mapPk.remove(key);
                }
            }
        }
        result.setRows(mapPk.values().toArray(new RefRow[0]));
        local.remove();
        return result;
    }
}

