/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import com.yonyou.cloud.ncc.NCCEnv;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nc.bs.logging.Logger;
import nc.itf.fip.opreatinglog.IBusiTypeService;
import nc.itf.fip.opreatinglog.IOperatingLog;
import nc.jdbc.framework.ConnectionFactory;
import nc.jdbc.framework.crossdb.CrossDBConnection;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.fip.operatinglogs.OperatingLogVO;
import nc.vo.fip.pub.FipBaseDataProxy;
import nc.vo.fip.pub.SqlTools;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.AccbookVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.PageInfo;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import org.apache.commons.lang3.ArrayUtils;

public class QueryPageListByPksAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        Grid grid = null;
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        try {
            OperatingLogVO[] olvos = (OperatingLogVO[])json.fromJson(str, OperatingLogVO[].class);
            if (olvos != null && olvos.length > 0) {
                HashMap<String, String> map = new HashMap<String, String>();
                ArrayList<String> list = new ArrayList<String>();
                for (OperatingLogVO vo : olvos) {
                    map.put(vo.getPk_operatinglog(), vo.getGroupid());
                    list.add(vo.getPk_operatinglog());
                }
                Object[] vos = ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).queryByPKs(list.toArray(new String[0]));
                PageInfo page = new PageInfo();
                Map pagemap = ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).queryPaginationDataByWhere(SqlTools.getInStr((String)"pk_operatinglog", (String[])list.toArray(new String[0]), (boolean)true), page, false, QueryPageListByPksAction.getDataBaseType());
                String[] allPks = null;
                if (pagemap != null) {
                    vos = (OperatingLogVO[])pagemap.get("pageVos");
                    if (vos != null && vos.length > 0) {
                        for (Object vo : vos) {
                            if (StringUtils.isNotBlank((CharSequence)vo.getDes_billtype()) && "C0".equals(vo.getDes_billtype())) {
                                if (!StringUtils.isNotBlank((CharSequence)vo.getSumruledesc()) || vo.getSumruledesc().contains("-")) continue;
                                vo.setSumruledesc(null);
                                continue;
                            }
                            vo.setSumruledesc(null);
                        }
                    }
                    allPks = (String[])pagemap.get("allPks");
                }
                GridOperator operator = new GridOperator("10170410_1017041001");
                if (ArrayUtils.isNotEmpty((Object[])vos)) {
                    vos = ((IBusiTypeService)ServiceLocator.find(IBusiTypeService.class)).queryByVOs((OperatingLogVO[])vos);
                    grid = operator.toGrid(vos);
                    grid.getModel().setAllpks(allPks);
                    nccloud.framework.web.ui.model.PageInfo pageInfo = new nccloud.framework.web.ui.model.PageInfo();
                    pageInfo.setPageSize(Integer.parseInt(page.getPageSize()));
                    pageInfo.setPageIndex(Integer.parseInt(page.getPageIndex()));
                    pageInfo.setTotal(page.getTotal());
                    pageInfo.setTotalPage(page.getTotalPage());
                    grid.getModel().setPageinfo(pageInfo);
                    this.improveGrid(grid);
                    resMap.put("grid", grid);
                    if (!NCCEnv.isMerged()) {
                        resMap.put("isMerged", false);
                    } else {
                        resMap.put("isMerged", true);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return resMap;
    }

    private void improveGrid(Grid grid) throws BusinessException {
        int currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq();
        if (grid != null && grid.getModel() != null) {
            String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            HashMap<String, String> mapAccBook = new HashMap<String, String>();
            for (Row row : grid.getModel().getRows()) {
                AccbookVO accbookVO;
                Object[] accBookVOS;
                Cell desFactor1;
                String value;
                BilltypeVO billtypeVO;
                String billTypeCode;
                Cell cell2;
                Cell cell = row.getCell("src_defdoc1");
                if (cell != null && StringUtils.isBlank((CharSequence)cell.getDisplay())) {
                    cell.setDisplay((String)cell.getValue());
                }
                if ((cell2 = row.getCell("src_billtype")) != null && StringUtils.isBlank((CharSequence)cell2.getDisplay()) && cell2.getValue() != null && (!StringUtils.isNotEmpty((CharSequence)(billTypeCode = (String)cell2.getValue())) || !billTypeCode.trim().contains(" ")) && (billtypeVO = FipBaseDataProxy.getBilltype((String)pk_group, (String)billTypeCode.trim())) != null && StringUtils.isNotBlank((CharSequence)billtypeVO.getBilltypename())) {
                    if (currLangIndex == 1) {
                        cell2.setDisplay(billTypeCode + billtypeVO.getBilltypename());
                    } else {
                        cell2.setDisplay(billTypeCode + billtypeVO.getAttributeValue("billtypename" + currLangIndex));
                    }
                }
                if (row.getCell("des_factor1") == null || !StringUtils.isNotEmpty((CharSequence)(value = (String)(desFactor1 = row.getCell("des_factor1")).getValue()))) continue;
                String display = (String)mapAccBook.get(value);
                if (StringUtils.isEmpty((CharSequence)display) && (accBookVOS = BDCacheQueryUtil.queryVOsByIDs(AccbookVO.class, (String)"pk_accbook", (String[])new String[]{value}, null)) != null && (accbookVO = (AccbookVO)accBookVOS[0]) != null) {
                    display = currLangIndex == 1 ? accbookVO.getName() : (String)accbookVO.getAttributeValue("name" + currLangIndex);
                    mapAccBook.put(value, display);
                }
                desFactor1.setDisplay(display);
            }
        }
    }

    private static int getDataBaseType() throws BusinessException {
        int databaseType = -1;
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            if (con instanceof CrossDBConnection) {
                databaseType = ((CrossDBConnection)con).getDatabaseType();
            }
        }
        catch (SQLException e) {
            Logger.error((Object)"", (Throwable)e);
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0020"));
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                Logger.error((Object)e.getMessage());
            }
        }
        return databaseType;
    }
}

