/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.bs.logging.Logger;
import nc.itf.fip.opreatinglog.IFipInterfaceService;
import nc.itf.fip.opreatinglog.IPreviewDesBillService;
import nc.vo.fip.service.FipMessageVO;
import nc.vo.gl.pubvoucher.VoucherVO;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.dto.gl.lightgl.VoucherMDVO;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.precision.GridPrecisionOperator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.GridModel;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.gl.lightgl.voucher.IVoucherWebQryService;

public class PreviewDesBillAction
implements ICommonAction {
    private static String MESSAGEVO = "messagevo";
    private static String DESBILLTYPE = "desbilltype";
    private static String SRCBILLTYPE = "srcbilltype";
    private static String PK_GROUP = "pk_group";

    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        FipMessageVO[][] vos = null;
        Grid grid = null;
        try {
            Map dataMap;
            List list;
            Map map = (Map)json.fromJson(str, Map.class);
            if (map != null && map.size() > 0 && (list = (List)map.get(MESSAGEVO)) != null && list.size() > 0 && (dataMap = ((IFipInterfaceService)ServiceLocator.find(IFipInterfaceService.class)).getPreviewVocherService((String)((Map)list.get(0)).get(PK_GROUP), (String)map.get(SRCBILLTYPE), map)) != null && dataMap.size() > 0) {
                List desbilltype = (List)dataMap.get(DESBILLTYPE);
                vos = (FipMessageVO[][])dataMap.get(MESSAGEVO);
                if (ArrayUtils.isNotEmpty((Object[])vos) && CollectionUtils.isNotEmpty((Collection)desbilltype)) {
                    if (desbilltype.size() > 1) {
                        throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170410", "1101704100019"));
                    }
                    Object[] voucherVOs = ((IPreviewDesBillService)ServiceLocator.find(IPreviewDesBillService.class)).previewDesBill(vos, (String)desbilltype.get(0));
                    if (ArrayUtils.isNotEmpty((Object[])voucherVOs)) {
                        Row[] rows;
                        ArrayList<VoucherMDVO> mdVOList = new ArrayList<VoucherMDVO>();
                        HashSet<String> systemcodes = new HashSet<String>();
                        for (Object voucherVO : voucherVOs) {
                            VoucherVO voucher = (VoucherVO)voucherVO;
                            VoucherMDVO mdVO = new VoucherMDVO(voucher, true);
                            if (StringUtil.isEmptyWithTrim((String)mdVO.getSystemname())) {
                                systemcodes.add(mdVO.getPk_system());
                            }
                            mdVO.setPk_voucher("");
                            mdVOList.add(mdVO);
                        }
                        if (systemcodes.size() > 0) {
                            Map systemNames = ((IVoucherWebQryService)ServiceLocator.find(IVoucherWebQryService.class)).getSystemNames(systemcodes.toArray(new String[0]));
                            for (VoucherMDVO voucherMDVO : mdVOList) {
                                if (!StringUtil.isEmptyWithTrim((String)voucherMDVO.getSystemname())) continue;
                                voucherMDVO.setSystemname((String)systemNames.get(voucherMDVO.getPk_system()));
                            }
                        }
                        SessionContext.getInstance().setAppcode("20020PREPA");
                        GridOperator oper = new GridOperator("20021005list");
                        grid = oper.toGrid((Object[])mdVOList.toArray(new VoucherMDVO[0]));
                        this.processListGridScale(grid, mdVOList.toArray(new VoucherMDVO[0]));
                        for (Row row : rows = grid.getModel().getRows()) {
                            Cell systemname = row.getCell("systemname");
                            Cell pk_system = row.getCell("pk_system");
                            Cell period = row.getCell("period");
                            Cell adjustperiod = row.getCell("adjustperiod");
                            if (systemname != null && pk_system != null) {
                                pk_system.setDisplay((String)systemname.getValue());
                            }
                            if (adjustperiod == null || period == null) continue;
                            adjustperiod.setValue(period.getValue());
                        }
                        return grid;
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return null;
    }

    public void processListGridScale(Grid grid, VoucherMDVO[] vos) {
        if (vos == null || vos.length == 0) {
            return;
        }
        Map<String, Object> scaleInfo = this.getScaleInfo(vos);
        GridPrecisionOperator operator = new GridPrecisionOperator(grid);
        GridModel model = grid.getModel();
        int i = 0;
        for (Row row : model.getRows()) {
            String pk_accountingbook = (String)row.getCell("pk_accountingbook").getValue();
            if (scaleInfo.get(pk_accountingbook) == null) {
                operator.addFixScalePrecision("totalcredit", i, Integer.valueOf(8));
                operator.addFixScalePrecision("totaldebit", i, Integer.valueOf(8));
            } else {
                operator.addCurrencyMnyPrecision("totalcredit", i, (String)scaleInfo.get(pk_accountingbook));
                operator.addCurrencyMnyPrecision("totaldebit", i, (String)scaleInfo.get(pk_accountingbook));
            }
            ++i;
        }
        operator.addGroupStdMnyPrecision("totaldebitgroup");
        operator.addGroupStdMnyPrecision("totalcreditgroup");
        operator.addGlobalStdMnyPrecision("totaldebitglobal");
        operator.addGlobalStdMnyPrecision("totalcreditglobal");
        operator.processPrecision();
    }

    private Map<String, Object> getScaleInfo(VoucherMDVO[] mdvos) {
        try {
            Map scaleInfo = ((IVoucherWebQryService)ServiceLocator.find(IVoucherWebQryService.class)).getScaleInfo(mdvos);
            return scaleInfo;
        }
        catch (Exception e) {
            Logger.error((Object)e.getMessage());
            ExceptionUtils.wrapException((Throwable)e);
            return new HashMap<String, Object>();
        }
    }
}

