/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import com.yonyou.cloud.ncc.NCCEnv;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nc.bs.logging.Logger;
import nc.cmpub.business.enumeration.CMSourceTypeEnum;
import nc.itf.fip.generate.IGenerateService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.fip.opreatinglog.IBusiTypeService;
import nc.itf.fip.opreatinglog.IOperatingLog;
import nc.itf.fip.relation.IFipRelation;
import nc.jdbc.framework.ConnectionFactory;
import nc.jdbc.framework.crossdb.CrossDBConnection;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.fip.operatinglogs.OperatingLogVO;
import nc.vo.fip.pub.FipBaseDataProxy;
import nc.vo.fip.relation.FipRelationVO;
import nc.vo.fip.service.FipBasicRelationVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.AccbookVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.Condition;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.baseapp.apprbac.IAppAndOrgPermQueryPubService;
import nccloud.pubitf.platform.query.INCCloudQueryService;
import nccloud.pubitf.web.refer.INCCRefQry;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class OperatingLogQueryAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        String str = request.read();
        Map varMap = (Map)JsonFactory.create().fromJson(str, Map.class);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        String status = String.valueOf(2);
        if (varMap.get("allpks") != null) {
            List pkList = (List)varMap.get("allpks");
            if (CollectionUtils.isNotEmpty((Collection)pkList)) {
                String[] pks = pkList.toArray(new String[0]);
                try {
                    List conditions;
                    Map conditionMap = (Map)varMap.get("conditions");
                    if (conditionMap != null && CollectionUtils.isNotEmpty((Collection)(conditions = (List)conditionMap.get("conditions")))) {
                        for (Object o : conditions) {
                            Map condition = (Map)o;
                            String field = (String)condition.get("field");
                            if (!"billstate".equals(field)) continue;
                            status = (String)((Map)condition.get("value")).get("firstvalue");
                            break;
                        }
                    }
                    Object[] vos = null;
                    boolean stateTempdes = Boolean.FALSE;
                    switch (Integer.parseInt(status)) {
                        case 2: {
                            stateTempdes = Boolean.TRUE;
                            vos = ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).queryByPKs(pks);
                            break;
                        }
                        case 3: {
                            FipRelationVO[] relations = ((IFipRelation)ServiceLocator.find(IFipRelation.class)).queryByPKs(pks);
                            vos = new OperatingLogVO[relations.length];
                            for (int i = 0; i < relations.length; ++i) {
                                vos[i] = FipBasicRelationVO.convertFromRelationVO((FipRelationVO)relations[i]).convertToOperatingLogVO();
                            }
                            break;
                        }
                    }
                    if (ArrayUtils.isNotEmpty(vos)) {
                        vos = this.sortByPks(pks, (OperatingLogVO[])vos, stateTempdes);
                        vos = ((IBusiTypeService)ServiceLocator.find(IBusiTypeService.class)).queryByVOs((OperatingLogVO[])vos);
                        SessionContext.getInstance().setAppcode("10170410");
                        GridOperator operator = new GridOperator((String)varMap.get("pageId"));
                        Grid grid = operator.toGrid(vos);
                        this.improveGrid(grid);
                        resMap.put("grid", grid);
                    }
                }
                catch (BusinessException e) {
                    ExceptionUtils.wrapException((Throwable)e);
                }
            }
        } else {
            IJson json = JsonFactory.create();
            SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);
            try {
                String srcBillTypeDataPowerSQL;
                String replace;
                IBillTypeService billTypeService = (IBillTypeService)ServiceLocator.find(IBillTypeService.class);
                boolean hasSrcFreedef3 = false;
                boolean hasDesFreedef1 = false;
                String desBilltype = null;
                List<BilltypeVO> srcBillTypeList = null;
                if (info == null || info.getQueryInfo() == null || info.getQueryInfo().getQuerycondition() == null) {
                    return null;
                }
                List conditionList = info.getQueryInfo().getQuerycondition().getConditions();
                if (conditionList != null) {
                    Iterator it = conditionList.iterator();
                    while (it.hasNext()) {
                        Condition con = (Condition)it.next();
                        switch (con.getField()) {
                            case "des_billtype": {
                                desBilltype = this.getBillTypeCodeStr(this.getBillType(con.getValue().getFirstvalue(), billTypeService));
                                con.getValue().setFirstvalue(desBilltype);
                                break;
                            }
                            case "src_billtype": {
                                if (StringUtils.isBlank((CharSequence)con.getValue().getFirstvalue())) break;
                                srcBillTypeList = this.getBillType(con.getValue().getFirstvalue(), billTypeService);
                                con.getValue().setFirstvalue(!srcBillTypeList.isEmpty() ? this.getBillTypeCodeStr(srcBillTypeList) : "NAV");
                                break;
                            }
                            case "des_org": {
                                String desOrgStr = con.getValue().getFirstvalue();
                                con.getValue().setFirstvalue(this.getFilteredDesOrgPks(desBilltype, desOrgStr));
                                break;
                            }
                            case "billstate": {
                                status = con.getValue().getFirstvalue();
                                it.remove();
                                break;
                            }
                            case "des_defdoc1": {
                                it.remove();
                                break;
                            }
                            case "src_freedef3": {
                                hasSrcFreedef3 = true;
                                break;
                            }
                            case "des_freedef1": {
                                hasDesFreedef1 = !"like".equals(con.getOprtype());
                                break;
                            }
                        }
                    }
                }
                INCCloudQueryService qservice = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
                IQueryScheme scheme = qservice.convertCondition(info.getQueryInfo());
                Object sqlwhere = scheme.getWhereSQLOnly();
                int databaseType = OperatingLogQueryAction.getDataBaseType();
                if (hasSrcFreedef3) {
                    replace = databaseType == 1 ? "to_number(src_freedef3)" : (databaseType == 12 ? "CONVERT(src_freedef3,DECIMAL)" : (databaseType == 2 ? "CAST (src_freedef3 AS NUMERIC(28,8))" : (databaseType == 7 ? "CAST (src_freedef3 AS NUMERIC(28,8))" : "CAST (src_freedef3 AS NUMERIC(28,8))")));
                    sqlwhere = ((String)sqlwhere).replaceAll("src_freedef3", replace);
                }
                if ("C0".equals(desBilltype) && hasDesFreedef1) {
                    replace = databaseType == 1 ? "to_number(des_freedef1)" : (databaseType == 12 ? "CONVERT(des_freedef1,DECIMAL)" : (databaseType == 2 ? "CAST (des_freedef1 AS NUMERIC(38,0))" : (databaseType == 7 ? "CAST (des_freedef1 AS NUMERIC(38,0))" : "CAST (des_freedef1 AS NUMERIC(38,0))")));
                    sqlwhere = ((String)sqlwhere).replaceAll("des_freedef1", replace);
                }
                Map custconditionMap = info.getQueryInfo().getUserdefObj();
                String sql = "";
                String fields = "";
                String type = null;
                if (custconditionMap != null && !custconditionMap.isEmpty()) {
                    String extsql = (String)custconditionMap.get("extsql");
                    sql = (String)custconditionMap.get("sql");
                    fields = (String)custconditionMap.get("fields");
                    type = (String)custconditionMap.get("type");
                    String field = "src_relationid";
                    if ("DES".equals(type)) {
                        field = "des_relationid";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)extsql)) {
                        sqlwhere = (String)sqlwhere + " and " + field + " in (" + extsql + ") ";
                    }
                }
                List busiList = null;
                if (sql != null && !sql.isEmpty()) {
                    busiList = ((IGenerateService)ServiceLocator.find(IGenerateService.class)).getSelfDefQueryResult(sql);
                }
                if (StringUtils.isNotEmpty((CharSequence)(srcBillTypeDataPowerSQL = this.getSrcBillTypeDataPowerSQL()))) {
                    sqlwhere = (String)sqlwhere + srcBillTypeDataPowerSQL;
                }
                boolean srcBillTypeIsGL = false;
                if (CollectionUtils.isNotEmpty(srcBillTypeList)) {
                    srcBillTypeIsGL = srcBillTypeList.stream().allMatch(billType -> "C0".equals(billType.getParentbilltype()) || "C3".equals(billType.getPk_billtypecode()));
                }
                boolean srcFreedef1ToNumber = "CM02".equals(desBilltype) || srcBillTypeIsGL;
                Object[] vos = null;
                String[] allPks = null;
                if (status != null) {
                    switch (Integer.parseInt(status)) {
                        case 2: {
                            sqlwhere = NCCEnv.isMerged() ? (String)sqlwhere + " and operateflag =4 " : (String)sqlwhere + " and operateflag in (4,14,15,16) and  DES_RELATIONID is not null ";
                            Map map = ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).queryPaginationDataByWhere((String)sqlwhere, info.getQueryInfo().getPageInfo(), srcFreedef1ToNumber, databaseType);
                            if (map == null) break;
                            vos = (OperatingLogVO[])map.get("pageVos");
                            if (vos != null) {
                                for (Object vo : vos) {
                                    if (StringUtils.isNotBlank((CharSequence)vo.getDes_billtype()) && "C0".equals(vo.getDes_billtype())) {
                                        if (!StringUtils.isNotBlank((CharSequence)vo.getSumruledesc()) || vo.getSumruledesc().contains("-")) continue;
                                        vo.setSumruledesc(null);
                                        continue;
                                    }
                                    vo.setSumruledesc(null);
                                }
                            }
                            allPks = (String[])map.get("allPks");
                            break;
                        }
                        case 3: {
                            Map map = ((IFipRelation)ServiceLocator.find(IFipRelation.class)).queryPaginationDataByWhere((String)sqlwhere, info.getQueryInfo().getPageInfo(), srcFreedef1ToNumber, databaseType);
                            if (map == null) break;
                            FipRelationVO[] fipVos = (FipRelationVO[])map.get("pageVos");
                            if (fipVos != null && fipVos.length > 0) {
                                vos = new OperatingLogVO[fipVos.length];
                                for (int i = 0; i < fipVos.length; ++i) {
                                    vos[i] = FipBasicRelationVO.convertFromRelationVO((FipRelationVO)fipVos[i]).convertToOperatingLogVO();
                                    vos[i].setSaga_frozen(Integer.valueOf(fipVos[i].getSaga_frozen() == null ? 0 : fipVos[i].getSaga_frozen()));
                                    vos[i].setSaga_status(Integer.valueOf(fipVos[i].getSaga_status() == null ? 0 : fipVos[i].getSaga_status()));
                                    vos[i].setSaga_btxid(fipVos[i].getSaga_btxid());
                                    vos[i].setSaga_gtxid(fipVos[i].getSaga_gtxid());
                                    if (StringUtils.isNotBlank((CharSequence)vos[i].getDes_billtype()) && "C0".equals(vos[i].getDes_billtype())) {
                                        if (!StringUtils.isBlank((CharSequence)vos[i].getSumruledesc())) continue;
                                        String sumruledesc = NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0908");
                                        vos[i].setSumruledesc(sumruledesc);
                                        continue;
                                    }
                                    vos[i].setSumruledesc(null);
                                }
                            }
                            allPks = (String[])map.get("allPks");
                            break;
                        }
                    }
                }
                if (vos != null && vos.length > 0) {
                    List<List<HashMap<String, Object>>> extData;
                    vos = ((IBusiTypeService)ServiceLocator.find(IBusiTypeService.class)).queryByVOs(vos);
                    if (busiList != null && !busiList.isEmpty() && (extData = this.mix((OperatingLogVO[])vos, busiList, fields, type)) != null && !extData.isEmpty()) {
                        resMap.put("extData", extData);
                    }
                    SessionContext.getInstance().setAppcode("10170410");
                    GridOperator operator = new GridOperator(info.getPagecode());
                    Grid grid = operator.toGrid(vos);
                    grid.getModel().setAllpks(allPks);
                    PageInfo pageInfo = new PageInfo();
                    pageInfo.setPageSize(Integer.parseInt(info.getQueryInfo().getPageInfo().getPageSize()));
                    pageInfo.setPageIndex(Integer.parseInt(info.getQueryInfo().getPageInfo().getPageIndex()));
                    pageInfo.setTotal(info.getQueryInfo().getPageInfo().getTotal());
                    pageInfo.setTotalPage(info.getQueryInfo().getPageInfo().getTotalPage());
                    grid.getModel().setPageinfo(pageInfo);
                    this.improveGrid(grid);
                    resMap.put("grid", grid);
                }
            }
            catch (Exception e) {
                ExceptionUtils.wrapException((Throwable)e);
            }
        }
        if (!NCCEnv.isMerged()) {
            resMap.put("isMerged", false);
        } else {
            resMap.put("isMerged", true);
        }
        return resMap;
    }

    private String getSrcBillTypeDataPowerSQL() {
        String returnSql = null;
        String strDataPowerSQL = null;
        String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
        String userId = SessionContext.getInstance().getClientInfo().getUserid();
        try {
            strDataPowerSQL = ((INCCRefQry)ServiceLocator.find(INCCRefQry.class)).getRefDataPowerSQL("bd_billtype", "pk_billtypeid", "transtype", "fip", pk_group, userId);
        }
        catch (BusinessException var8) {
            Logger.error((Object)var8.getMessage(), (Throwable)var8);
        }
        if (StringUtils.isNotEmpty(strDataPowerSQL)) {
            returnSql = " and src_billtype in (select pk_billtypecode from bd_billtype where " + strDataPowerSQL + ")";
        }
        return returnSql;
    }

    private String getFilteredDesOrgPks(String desBillTypeStr, String desOrgStr) throws BusinessException {
        String filteredDesOrgs = desOrgStr;
        String strPk_group = SessionContext.getInstance().getClientInfo().getPk_group();
        String strPk_user = SessionContext.getInstance().getClientInfo().getUserid();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{desBillTypeStr})) {
            String[] desBillTypes = desBillTypeStr.split(",");
            ArrayList<String> orgTypeList = new ArrayList<String>();
            String[] stringArray = desBillTypes;
            int n = stringArray.length;
            block13: for (int i = 0; i < n; ++i) {
                String desBillType;
                switch (desBillType = stringArray[i]) {
                    case "NRESA03": {
                        orgTypeList.add("LIABILITYBOOK0000000");
                        continue block13;
                    }
                    case "C0": {
                        orgTypeList.add("ACCOUNTINGBOOK000000");
                        continue block13;
                    }
                    case "CCA02": 
                    case "ICA03": {
                        orgTypeList.add("LIABILITYBOOK0000000");
                        orgTypeList.add("ACCOUNTINGBOOK000000");
                        continue block13;
                    }
                }
            }
            if (!orgTypeList.isEmpty()) {
                HashSet hasPermOrg = new HashSet();
                for (String orgType : orgTypeList) {
                    String[] orgs = null;
                    try {
                        orgs = ((IAppAndOrgPermQueryPubService)ServiceLocator.find(IAppAndOrgPermQueryPubService.class)).queryUserPermOrgPksByAppAndWithOrgTypesFilter(strPk_user, null, new String[]{orgType}, strPk_group);
                    }
                    catch (BusinessException ex) {
                        Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    if (orgs == null || orgs.length <= 0) continue;
                    Collections.addAll(hasPermOrg, orgs);
                }
                if (!hasPermOrg.isEmpty() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{desOrgStr})) {
                    ArrayList<String> filteredOrgList = new ArrayList<String>();
                    String[] desOrgs = desOrgStr.split(",");
                    for (String org : desOrgs) {
                        if (!hasPermOrg.contains(org)) continue;
                        filteredOrgList.add(org);
                    }
                    if (filteredOrgList.isEmpty()) {
                        throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0049"));
                    }
                    CharSequence[] filteredOrgs = filteredOrgList.toArray(new String[0]);
                    filteredDesOrgs = String.join((CharSequence)",", filteredOrgs);
                }
            }
        }
        return filteredDesOrgs;
    }

    private OperatingLogVO[] sortByPks(String[] pks, OperatingLogVO[] oplogs, boolean stateTempdes) {
        HashMap<String, OperatingLogVO> map = new HashMap<String, OperatingLogVO>();
        for (OperatingLogVO vo : oplogs) {
            if (StringUtils.isNotBlank((CharSequence)vo.getDes_billtype()) && "C0".equals(vo.getDes_billtype())) {
                if (StringUtils.isBlank((CharSequence)vo.getSumruledesc()) && !stateTempdes) {
                    String sumruledesc = NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0908");
                    vo.setSumruledesc(sumruledesc);
                }
                if (stateTempdes && StringUtils.isNotBlank((CharSequence)vo.getSumruledesc()) && !vo.getSumruledesc().contains("-")) {
                    vo.setSumruledesc(null);
                }
            } else {
                vo.setSumruledesc(null);
            }
            map.put(vo.getPk_operatinglog(), vo);
        }
        ArrayList<OperatingLogVO> rt = new ArrayList<OperatingLogVO>();
        for (String pk : pks) {
            if (!Objects.nonNull(map.get(pk))) continue;
            rt.add((OperatingLogVO)map.get(pk));
        }
        return rt.toArray(new OperatingLogVO[0]);
    }

    private void improveGrid(Grid grid) throws BusinessException {
        int currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq();
        if (grid != null && grid.getModel() != null) {
            String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            HashMap<String, String> mapAccBook = new HashMap<String, String>();
            for (Row row : grid.getModel().getRows()) {
                AccbookVO accbookVO;
                Object[] accBookVOS;
                Cell desFactor1;
                String value;
                BilltypeVO billtypeVO;
                String billTypeCode;
                Cell cell2;
                Cell cell = row.getCell("src_defdoc1");
                if (cell != null && StringUtils.isBlank((CharSequence)cell.getDisplay())) {
                    cell.setDisplay((String)cell.getValue());
                }
                if ((cell2 = row.getCell("src_billtype")) != null && StringUtils.isBlank((CharSequence)cell2.getDisplay()) && cell2.getValue() != null && (!StringUtils.isNotEmpty((CharSequence)(billTypeCode = (String)cell2.getValue())) || !billTypeCode.trim().contains(" ")) && (billtypeVO = FipBaseDataProxy.getBilltype((String)pk_group, (String)billTypeCode.trim())) != null && StringUtils.isNotBlank((CharSequence)billtypeVO.getBilltypename())) {
                    if (currLangIndex == 1) {
                        cell2.setDisplay(billTypeCode + billtypeVO.getBilltypename());
                    } else {
                        cell2.setDisplay(billTypeCode + billtypeVO.getAttributeValue("billtypename" + currLangIndex));
                    }
                }
                if (row.getCell("des_factor1") == null || !StringUtils.isNotEmpty((CharSequence)(value = (String)(desFactor1 = row.getCell("des_factor1")).getValue()))) continue;
                String display = (String)mapAccBook.get(value);
                if (StringUtils.isEmpty((CharSequence)display) && (accBookVOS = BDCacheQueryUtil.queryVOsByIDs(AccbookVO.class, (String)"pk_accbook", (String[])new String[]{value}, null)) != null && (accbookVO = (AccbookVO)accBookVOS[0]) != null) {
                    display = currLangIndex == 1 ? accbookVO.getName() : (String)accbookVO.getAttributeValue("name" + currLangIndex);
                    mapAccBook.put(value, display);
                }
                desFactor1.setDisplay(display);
            }
        }
    }

    private String getBillTypeCodeStr(List<BilltypeVO> billtypes) {
        String billTypeCodeStr = "";
        if (CollectionUtils.isNotEmpty(billtypes)) {
            ArrayList<String> srcCodeList = new ArrayList<String>();
            for (BilltypeVO billtype : billtypes) {
                srcCodeList.add(billtype.getPk_billtypecode());
            }
            billTypeCodeStr = String.join((CharSequence)",", srcCodeList);
        }
        return billTypeCodeStr;
    }

    private List<BilltypeVO> getBillType(String billTypeIdStr, IBillTypeService billTypeService) {
        ArrayList<BilltypeVO> billtypes = new ArrayList<BilltypeVO>();
        if (StringUtils.isNotBlank((CharSequence)billTypeIdStr)) {
            String[] pks = billTypeIdStr.split(",");
            try {
                billtypes.addAll(billTypeService.queryByPks(pks));
            }
            catch (BusinessException e) {
                ExceptionUtils.wrapException((Throwable)e);
            }
        }
        return billtypes;
    }

    private List<List<HashMap<String, Object>>> mix(OperatingLogVO[] rs, List<List<Object>> selfDefQueryResult, String fields, String type) {
        String[] exFields = null;
        if (fields != null) {
            exFields = fields.split(",");
        }
        if (ArrayUtils.isEmpty((Object[])rs)) {
            return null;
        }
        if (CollectionUtils.isEmpty(selfDefQueryResult)) {
            return null;
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (List<Object> exfield : selfDefQueryResult) {
            Object object = exfield.get(0);
            map.put((String)object, exfield);
        }
        ArrayList<List<HashMap<String, Object>>> list = new ArrayList<List<HashMap<String, Object>>>();
        for (OperatingLogVO operatingLogVO : rs) {
            ArrayList filedMap = new ArrayList();
            String field = operatingLogVO.getSrc_relationid();
            if ("DES".equals(type)) {
                field = operatingLogVO.getDes_relationid();
            }
            List exfield = (List)map.get(field);
            for (int i = 0; i < Objects.requireNonNull(exFields).length; ++i) {
                HashMap<String, String> disMap = new HashMap<String, String>();
                disMap.put("field", exFields[i]);
                if ("isourcetype".equals(exFields[i])) {
                    CMSourceTypeEnum cMSourceTypeEnum = (CMSourceTypeEnum)CMSourceTypeEnum.valueOf(CMSourceTypeEnum.class, exfield.get(i));
                    disMap.put("value", cMSourceTypeEnum.getName());
                } else {
                    disMap.put("value", (String)exfield.get(i));
                }
                filedMap.add(disMap);
            }
            list.add(filedMap);
        }
        return list;
    }

    private static int getDataBaseType() throws BusinessException {
        int databaseType = -1;
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            if (con instanceof CrossDBConnection) {
                databaseType = ((CrossDBConnection)con).getDatabaseType();
            }
        }
        catch (SQLException e) {
            Logger.error((Object)"", (Throwable)e);
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0020"));
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                Logger.error((Object)e.getMessage());
            }
        }
        return databaseType;
    }
}

