/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.opreatinglog.IFipInterfaceService;
import nc.vo.fip.billregister.BillRegisterVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.lang.UFBoolean;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;

public class GetQueryPanelAction
implements ICommonAction {
    private static final String CHECKEDKEYS = "checkedKeys";
    private static final String ISRELOAD = "isReload";

    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        ArrayList resList = new ArrayList();
        try {
            Map params = (Map)json.fromJson(str, Map.class);
            ArrayList list = (ArrayList)params.get(CHECKEDKEYS);
            UFBoolean isReload = params.get(ISRELOAD) == null ? UFBoolean.FALSE : UFBoolean.valueOf((boolean)((Boolean)params.get(ISRELOAD)));
            String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            IFipInterfaceService service = (IFipInterfaceService)ServiceLocator.find(IFipInterfaceService.class);
            if (list != null && list.size() > 0) {
                BillRegisterVO vo;
                boolean flag = false;
                ArrayList<BillRegisterVO> registerList = new ArrayList<BillRegisterVO>();
                HashSet<String> noWebcomponentList = new HashSet<String>();
                for (String billtype : list) {
                    if (!StringUtils.isNotEmpty((CharSequence)billtype)) continue;
                    try {
                        vo = service.getQueryPanel(pk_group, billtype);
                        if (vo == null) continue;
                        if (StringUtils.isNotEmpty((CharSequence)vo.getWebcomponent()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryconditionclass())) {
                            registerList.add(vo);
                            continue;
                        }
                        flag = true;
                        noWebcomponentList.add(billtype);
                    }
                    catch (Exception e) {
                        flag = true;
                        noWebcomponentList.add(billtype);
                    }
                }
                if (CollectionUtils.isNotEmpty(noWebcomponentList)) {
                    if (!isReload.booleanValue()) {
                        resMap.put("errorMsg", NCLangRes4VoTransl.getNCLangRes().getStrByID("10170410", "1101704100097", null, new String[]{StringUtils.join(noWebcomponentList, (String)",")}));
                    }
                    return resMap;
                }
                ArrayList<String> panelList = new ArrayList<String>();
                HashSet<String> transTypeList = new HashSet<String>();
                if (!flag) {
                    for (BillRegisterVO vo2 : registerList) {
                        if (!panelList.contains(vo2.getWebcomponent())) {
                            panelList.add(vo2.getWebcomponent());
                        }
                        transTypeList.add(vo2.getPk_billtype());
                    }
                    if (panelList.size() > 1) {
                        flag = true;
                    }
                }
                if (!registerList.isEmpty()) {
                    vo = (BillRegisterVO)registerList.get(0);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("panel", vo.getWebcomponent());
                    map.put("queryClass", vo.getQueryconditionclass());
                    map.put("billtype", String.join((CharSequence)",", list));
                    map.put("transType", String.join((CharSequence)",", transTypeList));
                    map.put("moduleCode", vo.getModulecode());
                    resList.add(map);
                }
                resMap.put("list", resList);
                resMap.put("emptyFlag", flag);
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return resMap;
    }
}

