/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.Map;
import nc.itf.fip.opreatinglog.IFipInterfaceService;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.QueryTreeFormatVO;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class GetDefQueryCondition
implements ICommonAction {
    private static final String QUERYDATA = "queryData";
    private static final String DEFQUERYCLASS = "defQueryClass";
    private static final String DEFBILLTYPE = "defBilltype";
    private static final String DEFMODULECODE = "defModuleCode";

    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        Map result = null;
        try {
            Map map = (Map)json.fromJson(str, Map.class);
            if (map != null && map.size() > 0) {
                String defQueryClass = (String)map.get(DEFQUERYCLASS);
                String defBilltype = (String)map.get(DEFBILLTYPE);
                String defModuleCode = (String)map.get(DEFMODULECODE);
                String queryData = (String)map.get(QUERYDATA);
                QueryTreeFormatVO formatVO = (QueryTreeFormatVO)json.fromJson(queryData, QueryTreeFormatVO.class);
                if (StringUtils.isNotEmpty((CharSequence)defQueryClass) && StringUtils.isNotEmpty((CharSequence)defBilltype) && StringUtils.isNotEmpty((CharSequence)defModuleCode) && formatVO != null) {
                    result = ((IFipInterfaceService)ServiceLocator.find(IFipInterfaceService.class)).getQuerySQL(defQueryClass, defBilltype, defModuleCode, formatVO);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return result;
    }
}

