/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.itf.gl.fip.IVoucherSumRuleQryService;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.SuperVO;
import nc.vo.voucher.fip.Aggcombinscheme;
import nc.vo.voucher.fip.CombinschemeVO;
import nc.vo.voucher.fip.Expaccount;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.core.reflect.Constructor;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.pattern.BillCardConvertor;
import nccloud.framework.web.convert.pattern.CardAreaInfo;
import nccloud.framework.web.convert.pattern.CardPosition;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.config.Area;
import nccloud.framework.web.ui.config.PageTemplet;
import nccloud.framework.web.ui.config.TempletQueryPara;
import nccloud.framework.web.ui.config.TempletResource;
import nccloud.framework.web.ui.meta.AreaType;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.SpecilAggBill;

public class GetCombinSchemeByPkAction
implements ICommonAction {
    private static final String PK = "pk";
    private static final String PAGECODE = "pageCode";
    private static final String APPCODE = "appCode";

    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        Aggcombinscheme scheme = null;
        try {
            Map map = (Map)json.fromJson(str, HashMap.class);
            if (map != null && map.size() > 0) {
                String pk = (String)map.get(PK);
                scheme = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID(pk);
                if (scheme != null) {
                    SpecilAggBill newAggBill = new SpecilAggBill();
                    if (scheme.getParentVO() != null) {
                        newAggBill.setHead((SuperVO)((CombinschemeVO)scheme.getParentVO()));
                    } else {
                        newAggBill.setHead((SuperVO)new CombinschemeVO());
                    }
                    if (scheme.getChildrenVO() != null) {
                        newAggBill.setBodys((SuperVO[])((Expaccount[])scheme.getChildrenVO()));
                    } else {
                        newAggBill.setBodys((SuperVO[])new Expaccount[0]);
                    }
                    BillCard retcard = this.convert((String)map.get(PAGECODE), (String)map.get(APPCODE), newAggBill);
                    Translator translator = new Translator();
                    translator.translate(retcard);
                    if (retcard != null && retcard.getHead() != null) {
                        ((Cell)retcard.getHead().getModel().getRows()[0].getValues().get("pk_combinscheme")).setDisplay(StringUtils.isNotEmpty((CharSequence)((CombinschemeVO)newAggBill.getHead()).getName()) ? ((CombinschemeVO)newAggBill.getHead()).getName() : ((CombinschemeVO)newAggBill.getHead()).getCode());
                    }
                    return retcard;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return null;
    }

    public BillCard convert(String pagecode, String appcode, Object vo) {
        TempletResource resourc = new TempletResource();
        TempletQueryPara para = new TempletQueryPara();
        para.setPagecode(pagecode);
        para.setAppcode(appcode);
        PageTemplet templet = resourc.query(para);
        CardAreaInfo[] infos = this.getAreaInfo(templet, new ArrayList<String>());
        BillCardConvertor convertor = new BillCardConvertor();
        BillCard card = convertor.toBillCard(vo, infos);
        card.setPageid(pagecode);
        card.setTempletid(templet.getOid());
        return card;
    }

    private CardAreaInfo[] getAreaInfo(PageTemplet templet, List<String> codes) {
        ArrayList<CardAreaInfo> infoList = new ArrayList<CardAreaInfo>();
        String headcode = templet.getHeadcode();
        CardAreaInfo headinfo = new CardAreaInfo();
        Area headArea = templet.getArea(headcode);
        headinfo.setAreacode(headArea.getCode());
        headinfo.setClazz(Constructor.load((String)headArea.getClazz()));
        headinfo.setPosition(CardPosition.Head);
        headinfo.setVometa(headArea.getVometa());
        infoList.add(headinfo);
        if (templet.getTailcode() != null) {
            CardAreaInfo tailinfo = new CardAreaInfo();
            Area tailArea = templet.getArea(headcode);
            if (headArea.getClazz() == null) {
                ExceptionUtils.wrapBusinessException((String)(NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0233") + templet.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0235") + tailArea.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0236")));
            }
            tailinfo.setAreacode(tailArea.getCode());
            tailinfo.setClazz(Constructor.load((String)tailArea.getClazz()));
            tailinfo.setPosition(CardPosition.Tail);
            tailinfo.setVometa(tailArea.getVometa());
            infoList.add(tailinfo);
        }
        for (Area area : templet.getAllAreas()) {
            if (!area.getAreaType().equals((Object)AreaType.Table) || codes != null && codes.contains(area.getCode())) continue;
            CardAreaInfo bodyarea = new CardAreaInfo();
            bodyarea.setAreacode(area.getCode());
            if (headArea.getClazz() == null) {
                ExceptionUtils.wrapBusinessException((String)(NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0233") + templet.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0235") + area.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0236")));
            }
            bodyarea.setClazz(Constructor.load((String)area.getClazz()));
            bodyarea.setPosition(CardPosition.Body);
            bodyarea.setVometa(area.getVometa());
            infoList.add(bodyarea);
        }
        return infoList.toArray(new CardAreaInfo[0]);
    }
}

