/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nc.itf.gl.fip.IVoucherSumRuleQryService;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nc.vo.voucher.fip.Aggcombinscheme;
import nc.vo.voucher.fip.CombinschemeVO;
import nc.vo.voucher.fip.Expaccount;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.core.reflect.Constructor;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.pattern.BillCardConvertor;
import nccloud.framework.web.convert.pattern.CardAreaInfo;
import nccloud.framework.web.convert.pattern.CardPosition;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.config.Area;
import nccloud.framework.web.ui.config.PageTemplet;
import nccloud.framework.web.ui.config.TempletQueryPara;
import nccloud.framework.web.ui.config.TempletResource;
import nccloud.framework.web.ui.meta.AreaType;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.SpecilAggBill;
import nccloud.framework.web.ui.pattern.form.Form;

public class GetCombinSchemeAction
implements ICommonAction {
    private static final String PK_COMBINSCHEME = "pk_combinscheme";
    private static final String PAGECODE = "pageCode";
    private static final String APPCODE = "appCode";

    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        Aggcombinscheme scheme = null;
        try {
            Map map = (Map)json.fromJson(str, HashMap.class);
            if (map != null && map.size() > 0) {
                String pk_combinscheme = (String)map.get(PK_COMBINSCHEME);
                if (StringUtils.isBlank((CharSequence)pk_combinscheme)) {
                    throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170410", "1101704100086"));
                }
                IVoucherSumRuleQryService sumRuleQryService = (IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class);
                scheme = sumRuleQryService.queryByID(pk_combinscheme);
                if (scheme == null) {
                    throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170410", "1101704100087"));
                }
                SpecilAggBill newAggBill = new SpecilAggBill();
                if (scheme.getParentVO() != null) {
                    CombinschemeVO schemeHead = (CombinschemeVO)scheme.getParentVO();
                    schemeHead.setIsdefault(schemeHead.getIsdefault());
                    newAggBill.setHead((SuperVO)schemeHead);
                } else {
                    newAggBill.setHead((SuperVO)new CombinschemeVO());
                }
                if (scheme.getChildrenVO() != null) {
                    newAggBill.setBodys((SuperVO[])((Expaccount[])scheme.getChildrenVO()));
                } else {
                    newAggBill.setBodys((SuperVO[])new Expaccount[0]);
                }
                BillCard retcard = this.convert((String)map.get(PAGECODE), (String)map.get(APPCODE), newAggBill, pk_combinscheme);
                Translator translator = new Translator();
                translator.translate(retcard);
                if (retcard != null && retcard.getHead() != null) {
                    ((Cell)retcard.getHead().getModel().getRows()[0].getValues().get(PK_COMBINSCHEME)).setDisplay(StringUtils.isNotEmpty((CharSequence)((CombinschemeVO)newAggBill.getHead()).getName()) ? ((CombinschemeVO)newAggBill.getHead()).getName() : ((CombinschemeVO)newAggBill.getHead()).getCode());
                }
                return retcard;
            }
        }
        catch (Exception ex) {
            ExceptionUtils.wrapException((Throwable)ex);
        }
        return null;
    }

    public BillCard convert(String pagecode, String appcode, Object vo, String pk_combinscheme) throws BusinessException {
        TempletResource resourc = new TempletResource();
        TempletQueryPara para = new TempletQueryPara();
        para.setPagecode(pagecode);
        para.setAppcode(appcode);
        PageTemplet templet = resourc.query(para);
        CardAreaInfo[] infos = this.getAreaInfo(templet, new ArrayList<String>());
        BillCardConvertor convertor = new BillCardConvertor();
        BillCard card = convertor.toBillCard(vo, infos);
        card.setPageid(pagecode);
        card.setTempletid(templet.getOid());
        this.processPkAccounting(card, pk_combinscheme);
        return card;
    }

    private void processPkAccounting(BillCard billCard, String pk_combinscheme) throws BusinessException {
        IVoucherSumRuleQryService sumRuleQryService = (IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class);
        Form headForm = billCard.getHead();
        Row[] rows = headForm.getModel().getRows();
        for (int i = 0; i < rows.length; ++i) {
            Cell cell = rows[i].getCell("pk_accountingbook");
            if (cell == null || !StringUtils.isBlank((CharSequence)cell.getDisplay())) continue;
            cell.setDisplay(sumRuleQryService.querOrgNameByCombinschemePk(pk_combinscheme));
            break;
        }
    }

    private CardAreaInfo[] getAreaInfo(PageTemplet templet, List<String> codes) {
        ArrayList<CardAreaInfo> infoList = new ArrayList<CardAreaInfo>();
        String headcode = templet.getHeadcode();
        CardAreaInfo headinfo = new CardAreaInfo();
        Area headArea = templet.getArea(headcode);
        headinfo.setAreacode(headArea.getCode());
        headinfo.setClazz(Constructor.load((String)headArea.getClazz()));
        headinfo.setPosition(CardPosition.Head);
        headinfo.setVometa(headArea.getVometa());
        infoList.add(headinfo);
        if (templet.getTailcode() != null) {
            CardAreaInfo tailinfo = new CardAreaInfo();
            Area tailArea = templet.getArea(headcode);
            if (headArea.getClazz() == null) {
                ExceptionUtils.wrapBusinessException((String)(NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0233") + templet.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0235") + tailArea.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0236")));
            }
            tailinfo.setAreacode(tailArea.getCode());
            tailinfo.setClazz(Constructor.load((String)tailArea.getClazz()));
            tailinfo.setPosition(CardPosition.Tail);
            tailinfo.setVometa(tailArea.getVometa());
            infoList.add(tailinfo);
        }
        for (Area area : templet.getAllAreas()) {
            if (!area.getAreaType().equals((Object)AreaType.Table) || codes != null && codes.contains(area.getCode())) continue;
            CardAreaInfo bodyarea = new CardAreaInfo();
            bodyarea.setAreacode(area.getCode());
            if (headArea.getClazz() == null) {
                ExceptionUtils.wrapBusinessException((String)(NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0233") + templet.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0235") + area.getCode() + NCLangRes4VoTransl.getNCLangRes().getStrByID("1501001_0", "01501001-0236")));
            }
            bodyarea.setClazz(Constructor.load((String)area.getClazz()));
            bodyarea.setPosition(CardPosition.Body);
            bodyarea.setVometa(area.getVometa());
            infoList.add(bodyarea);
        }
        return infoList.toArray(new CardAreaInfo[0]);
    }
}

