/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import com.yonyou.cloud.ncc.NCCEnv;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nc.bs.logging.Logger;
import nc.bs.sec.esapi.NCESAPI;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.fip.opreatinglog.IOperatingLog;
import nc.jdbc.framework.ConnectionFactory;
import nc.jdbc.framework.crossdb.CrossDBConnection;
import nc.util.fi.pub.SqlUtils;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFDate;
import nc.vo.pub.lang.UFDouble;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class GenerateRebuildAction
implements ICommonAction {
    private static final String TYPE = "type";
    private static final String RULE = "rule";
    private static final String PKS = "pks";

    public Object doAction(IRequest request) {
        String str = request.read();
        IJson json = JsonFactory.create();
        Object sqlWhere = " 1=1 ";
        boolean useOrgRule = false;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            Map map = (Map)json.fromJson(str, HashMap.class);
            if (map != null && map.size() > 0) {
                String rebuildType;
                if (!NCCEnv.isMerged()) {
                    paramMap.put("sagas_batchno", map.get("batchno"));
                }
                if (RebuildType.REBUILD_CONDITION.VALUE.equals(rebuildType = (String)map.get(TYPE))) {
                    for (Map.Entry entry : map.entrySet()) {
                        switch ((String)entry.getKey()) {
                            case "src_billtype": {
                                String src_billtype = (String)entry.getValue();
                                sqlWhere = (String)sqlWhere + " and " + SqlUtils.getInStr((String)"src_billtype", (String[])src_billtype.split(","));
                                break;
                            }
                            case "src_org": {
                                String src_org = (String)entry.getValue();
                                sqlWhere = (String)sqlWhere + " and " + SqlUtils.getInStr((String)"src_org", (String[])src_org.split(","));
                                break;
                            }
                            case "src_operator": {
                                String srcOperate = (String)entry.getValue();
                                sqlWhere = (String)sqlWhere + " and " + SqlUtils.getInStr((String)"src_operator", (String[])srcOperate.split(","));
                                break;
                            }
                            case "src_busidate": {
                                Map srcBusiMap = (Map)entry.getValue();
                                if (srcBusiMap == null) break;
                                if (srcBusiMap.get("firstValue") != null && StringUtils.isNotEmpty((CharSequence)((String)srcBusiMap.get("firstValue")))) {
                                    sqlWhere = (String)sqlWhere + " and src_busidate >='" + NCESAPI.sqlEncode((String)UFDate.getDate((String)((String)srcBusiMap.get("firstValue"))).asBegin().toString()) + "'";
                                }
                                if (srcBusiMap.get("secondValue") == null || !StringUtils.isNotEmpty((CharSequence)((String)srcBusiMap.get("secondValue")))) break;
                                sqlWhere = (String)sqlWhere + " and src_busidate <='" + NCESAPI.sqlEncode((String)UFDate.getDate((String)((String)srcBusiMap.get("secondValue"))).asEnd().toString()) + "'";
                                break;
                            }
                            case "src_defdoc1": {
                                sqlWhere = (String)sqlWhere + " and src_defdoc1 = '" + (String)entry.getValue() + "'";
                                break;
                            }
                            case "src_freedef1": {
                                sqlWhere = (String)sqlWhere + " and src_freedef1 = '" + (String)entry.getValue() + "'";
                                break;
                            }
                            case "src_freedef2": {
                                sqlWhere = (String)sqlWhere + " and src_freedef2 = '" + (String)entry.getValue() + "'";
                                break;
                            }
                            case "src_freedef3": {
                                String value = (String)entry.getValue();
                                if (!StringUtils.isNotBlank((CharSequence)value)) break;
                                UFDouble src_money = new UFDouble(value);
                                int databaseType = GenerateRebuildAction.getDataBaseType();
                                String src_freedef3_sql = databaseType == 1 ? "to_number(src_freedef3)" : (databaseType == 12 ? "CONVERT(src_freedef3,DECIMAL)" : (databaseType == 2 ? "CAST (src_freedef3 AS NUMERIC(28,8))" : (databaseType == 7 ? "CAST (src_freedef3 AS NUMERIC(28,8))" : "CAST (src_freedef3 AS NUMERIC(28,8))")));
                                sqlWhere = (String)sqlWhere + " and " + src_freedef3_sql + " = " + src_money;
                                break;
                            }
                            case "des_billtype": {
                                BilltypeVO vo = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).queryByPk((String)entry.getValue());
                                sqlWhere = (String)sqlWhere + " and des_billtype = '" + NCESAPI.sqlEncode((String)vo.getPk_billtypecode()) + "'";
                                break;
                            }
                            case "des_org": {
                                String desOrgs = (String)entry.getValue();
                                sqlWhere = (String)sqlWhere + " and " + SqlUtils.getInStr((String)"des_org", (String[])desOrgs.split(","));
                                break;
                            }
                            case "rule": {
                                useOrgRule = (Boolean)entry.getValue();
                                break;
                            }
                        }
                    }
                    sqlWhere = (String)sqlWhere + " and (operateflag=0 or operateflag>=4)";
                    paramMap.put("queryWhere", sqlWhere);
                    paramMap.put("isUseOrgRule", useOrgRule);
                    ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).recomputeByWhere(paramMap);
                } else if (RebuildType.REBUILD_PKS.VALUE.equals(rebuildType)) {
                    ArrayList pks = (ArrayList)map.get(PKS);
                    useOrgRule = (Boolean)map.get(RULE);
                    if (pks != null && pks.size() > 0) {
                        paramMap.put("pklist", pks);
                        paramMap.put("isUseOrgRule", useOrgRule);
                        ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).recomputeByPKs(paramMap);
                    }
                }
                return "success";
            }
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return null;
    }

    private static int getDataBaseType() throws BusinessException {
        int databaseType = -1;
        Connection con = null;
        try {
            con = ConnectionFactory.getConnection();
            if (con instanceof CrossDBConnection) {
                databaseType = ((CrossDBConnection)con).getDatabaseType();
            }
        }
        catch (SQLException e) {
            Logger.error((Object)"", (Throwable)e);
            throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0020"));
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                Logger.error((Object)e.getMessage());
            }
        }
        return databaseType;
    }

    static enum RebuildType {
        REBUILD_CONDITION(1),
        REBUILD_PKS(2);

        public final String VALUE;

        private RebuildType(int value) {
            this.VALUE = String.valueOf(value);
        }
    }
}

