/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.generate.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nc.bs.logging.Logger;
import nc.cmpub.business.enumeration.CMSourceTypeEnum;
import nc.itf.fip.generate.IGenerateService;
import nc.itf.fip.opreatinglog.IOperatingLog;
import nc.vo.fip.operatinglogs.OperatingLogVO;
import nc.vo.pub.lang.UFDate;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class BatchChooseAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            String str = request.read();
            Map varMap = (Map)JsonFactory.create().fromJson(str, Map.class);
            String[] pks = null;
            if (varMap.get("pks") != null) {
                pks = ((List)varMap.get("pks")).toArray(new String[0]);
            }
            if (ArrayUtils.isEmpty(pks)) {
                return null;
            }
            List groupFields = null;
            if (varMap.get("checkedFields") != null) {
                groupFields = (List)varMap.get("checkedFields");
            }
            List<HashMap<String, Object>> queryInfo = this.getValue(varMap, pks, groupFields);
            queryInfo = this.sortByPks(pks, queryInfo);
            List groupidlist = new ArrayList();
            if (varMap.get("groupIds") != null) {
                groupidlist = (List)varMap.get("groupIds");
            }
            int index = 1;
            HashMap<String, String> rtMap = new HashMap<String, String>();
            if (groupFields != null) {
                HashMap<String, String> groupidmap = new HashMap<String, String>();
                for (HashMap<String, Object> stringObjectHashMap : queryInfo) {
                    StringBuilder key = new StringBuilder();
                    for (String strKey : groupFields) {
                        Object bodyValueAt = stringObjectHashMap.get(strKey);
                        if (bodyValueAt instanceof UFDate) {
                            bodyValueAt = ((UFDate)bodyValueAt).toLocalString();
                        }
                        key.append(bodyValueAt);
                    }
                    String groupid = (String)groupidmap.get(key.toString());
                    if (groupid == null) {
                        groupid = BatchChooseAction.getCode("" + index++, 4);
                        while (groupidlist.contains(groupid)) {
                            groupid = BatchChooseAction.getCode("" + index++, 4);
                        }
                        groupidmap.put(key.toString(), groupid);
                    }
                    rtMap.put((String)stringObjectHashMap.get("pk_operatinglog"), groupid);
                }
            }
            return rtMap;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }

    private static String getCode(String code, int strLength) {
        if (code == null) {
            code = "0";
        }
        StringBuilder codeBuilder = new StringBuilder(code);
        while (codeBuilder.length() < strLength) {
            codeBuilder.insert(0, "0");
        }
        code = codeBuilder.toString();
        return code;
    }

    private List<HashMap<String, Object>> sortByPks(String[] pks, List<HashMap<String, Object>> queryInfo) {
        ArrayList<HashMap<String, Object>> listMap = new ArrayList<HashMap<String, Object>>();
        HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(pks.length);
        for (HashMap<String, Object> mapValue : queryInfo) {
            map.put((String)mapValue.get("pk_operatinglog"), mapValue);
        }
        for (String pk : pks) {
            HashMap value = (HashMap)map.get(pk);
            if (Objects.isNull(value)) continue;
            listMap.add(value);
        }
        return listMap;
    }

    private List<HashMap<String, Object>> getValue(Map<String, Object> varMap, String[] pks, List<String> frontSelectFields) {
        ArrayList<HashMap<String, Object>> resultMap = new ArrayList<HashMap<String, Object>>();
        if (ArrayUtils.isEmpty((Object[])pks) || CollectionUtils.isEmpty(frontSelectFields)) {
            return resultMap;
        }
        Map queryInfo = (Map)varMap.get("queryInfo");
        try {
            String fields = "";
            List busiList = null;
            String type = null;
            if (queryInfo != null) {
                Map custconditionMap = (Map)queryInfo.get("userdefObj");
                String selDefsql = "";
                if (custconditionMap != null && !custconditionMap.isEmpty()) {
                    selDefsql = (String)custconditionMap.get("sql");
                    fields = (String)custconditionMap.get("fields");
                    type = (String)custconditionMap.get("type");
                }
                if (selDefsql != null && !selDefsql.isEmpty()) {
                    busiList = ((IGenerateService)ServiceLocator.find(IGenerateService.class)).getSelfDefQueryResult(selDefsql);
                }
            }
            ArrayList<String> selectFields = new ArrayList<String>(frontSelectFields);
            selectFields.add("pk_operatinglog");
            if ("DES".equals(type)) {
                selectFields.add("des_relationid");
            } else {
                selectFields.add("src_relationid");
            }
            Iterator it = selectFields.iterator();
            while (it.hasNext()) {
                String field = (String)it.next();
                if (!field.equals("groupid") && !fields.contains(field)) continue;
                it.remove();
            }
            OperatingLogVO[] vos = ((IOperatingLog)ServiceLocator.find(IOperatingLog.class)).queryByPKs(selectFields.toArray(new String[0]), pks);
            if (vos != null && vos.length > 0) {
                List<List<HashMap<String, Object>>> extData = null;
                if (busiList != null && !busiList.isEmpty()) {
                    extData = this.mix(vos, busiList, fields, type);
                }
                for (int i = 0; i < vos.length; ++i) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    OperatingLogVO vo = vos[i];
                    for (String key : selectFields) {
                        map.put(key, vo.getAttributeValue(key));
                    }
                    if (CollectionUtils.isNotEmpty(extData)) {
                        List<HashMap<String, Object>> mapList = extData.get(i);
                        for (HashMap<String, Object> extMap : mapList) {
                            map.put((String)extMap.get("field"), extMap.get("value"));
                        }
                    }
                    resultMap.add(map);
                }
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return resultMap;
    }

    private List<List<HashMap<String, Object>>> mix(OperatingLogVO[] rs, List<List<Object>> selfDefQueryResult, String fields, String type) {
        String[] exFields = null;
        if (fields != null) {
            exFields = fields.split(",");
        }
        if (ArrayUtils.isEmpty((Object[])rs)) {
            return null;
        }
        if (CollectionUtils.isEmpty(selfDefQueryResult)) {
            return null;
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (List<Object> exfield : selfDefQueryResult) {
            Object object = exfield.get(0);
            map.put((String)object, exfield);
        }
        ArrayList<List<HashMap<String, Object>>> list = new ArrayList<List<HashMap<String, Object>>>();
        for (OperatingLogVO operatingLogVO : rs) {
            ArrayList filedMap = new ArrayList();
            String field = operatingLogVO.getSrc_relationid();
            if ("DES".equals(type)) {
                field = operatingLogVO.getDes_relationid();
            }
            List exfield = (List)map.get(field);
            for (int i = 0; i < Objects.requireNonNull(exFields).length; ++i) {
                HashMap<String, String> disMap = new HashMap<String, String>();
                disMap.put("field", exFields[i]);
                if ("isourcetype".equals(exFields[i])) {
                    CMSourceTypeEnum cMSourceTypeEnum = (CMSourceTypeEnum)CMSourceTypeEnum.valueOf(CMSourceTypeEnum.class, exfield.get(i));
                    disMap.put("value", cMSourceTypeEnum.getName());
                } else {
                    disMap.put("value", (String)exfield.get(i));
                }
                filedMap.add(disMap);
            }
            list.add(filedMap);
        }
        return list;
    }
}

