/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.fieldreport.action;

import java.util.List;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.fip.report.IFipReport;
import nc.vo.fip.report.FieldReportVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.dto.fip.PageQueryDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridFormulaHandler;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingPagingService;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;

public class QueryFieldreportAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            String read = request.read();
            IJson json = JsonFactory.create();
            Grid result = null;
            AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(read, AccountingQueryPageInfo.class);
            String wherepart = this.getSearchSql(info);
            Integer pageSize = info.getPageInfo().getPageSize();
            Integer pageIndex = info.getPageInfo().getPageIndex();
            if (info.getAllpks() == null) {
                Object[] currentHeadVOs;
                AccountingPagingService service = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
                PageQueryDTO pageResult = service.queryFieldBillPksByWhere(wherepart, pageSize.intValue());
                String[] pks = pageResult == null ? null : pageResult.getAllPKs();
                Object[] objectArray = currentHeadVOs = pageResult == null ? null : pageResult.getCurrentHeadVOs();
                if (pageResult == null || pks == null || pks.length == 0 || currentHeadVOs == null || currentHeadVOs.length == 0) {
                    return null;
                }
                GridOperator operator = new GridOperator(info.getPagecode());
                result = operator.toGrid(currentHeadVOs);
                result.getModel().setAllpks(pks);
                PageInfo pageInfo = new PageInfo();
                pageInfo.setTotal(pks.length);
                pageInfo.setPageSize(pageSize.intValue());
                pageInfo.setPageIndex(pageIndex.intValue());
                pageInfo.setTotalPage(this.getTotalPage(pageInfo, pks.length));
                result.getModel().setPageinfo(pageInfo);
            } else {
                FieldReportVO[] vos = ((IFipReport)ServiceLocator.find(IFipReport.class)).queryFieldReport(wherepart);
                if (vos == null) {
                    return null;
                }
                int size = pageIndex * pageSize;
                int length = vos.length - size > pageSize ? pageSize : vos.length - size;
                Object[] newvos = new FieldReportVO[length];
                for (int i = 0; i < length; ++i) {
                    newvos[i] = vos[size + i];
                }
                GridOperator operator = new GridOperator(info.getPagecode());
                result = operator.toGrid(newvos);
            }
            GridFormulaHandler gfh = new GridFormulaHandler(result);
            gfh.handleLoadFormula();
            Translator translator = new Translator();
            translator.translate(result);
            return result;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private int getTotalPage(PageInfo pageInfo, int len) {
        int size = pageInfo.getPageSize();
        int total = 0;
        total = len % size == 0 ? len / size : len / size + 1;
        return total;
    }

    public String getSearchSql(AccountingQueryPageInfo info) {
        List conditions = info.getConditions();
        Object sqlWhere = "1=1";
        if (conditions != null && conditions.size() > 0) {
            for (Conditions con : conditions) {
                String[] pks;
                if (!"des_billtype".equals(con.getField()) && !"src_billtype".equals(con.getField()) || (pks = con.getValue().getFirstvalue().split(",")) == null || pks.length <= 0) continue;
                Object srcCode = "";
                List billtypes = null;
                try {
                    billtypes = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).queryByPks(pks);
                }
                catch (BusinessException e) {
                    ExceptionUtils.wrapException((String)e.getMessage(), (Throwable)e);
                }
                if (billtypes != null && billtypes.size() > 0) {
                    for (i = 0; i < billtypes.size(); ++i) {
                        srcCode = i == 0 ? (String)srcCode + "'" + ((BilltypeVO)billtypes.get(i)).getPk_billtypecode() + "'" : (String)srcCode + ",'" + ((BilltypeVO)billtypes.get(i)).getPk_billtypecode() + "'";
                    }
                } else {
                    for (i = 0; i < pks.length; ++i) {
                        srcCode = i == 0 ? (String)srcCode + "'" + pks[i] + "'" : (String)srcCode + ",'" + pks[i] + "'";
                    }
                }
                sqlWhere = (String)sqlWhere + " and " + con.getField() + " in (" + (String)srcCode + ")";
            }
        }
        return sqlWhere;
    }
}

