/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.docview.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nc.vo.jcom.lang.StringUtil;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pfxx.pub.SwapException;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.itf.uap.excel.IExcelFileService;
import nccloud.vo.excel.scheme.BillDefination;
import nccloud.vo.excel.scheme.Field;
import nccloud.vo.excel.scheme.Record;
import nccloud.web.trade.action.ExportInfo;
import nccloud.web.trade.excel.action.FieldTreeUtil;
import nccloud.web.trade.excel.action.FieldTreeWapper;

public class SchemeCustomQueryAction
implements ICommonAction {
    private List<Field> leftFields = null;
    private List<Field> rightFields = null;
    private BillDefination billDefination = null;

    public Object doAction(IRequest request) {
        HashMap<String, List> map = new HashMap<String, List>();
        BillDefination srcbillDefination = null;
        try {
            String str = request.read();
            IJson json = JsonFactory.create();
            ExportInfo info = (ExportInfo)json.fromJson(str, ExportInfo.class);
            if (StringUtil.isEmptyWithTrim((String)info.getModuleName())) {
                throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-2-0005"));
            }
            if (StringUtil.isEmptyWithTrim((String)info.getBillType())) {
                throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-2-0006"));
            }
            srcbillDefination = ((IExcelFileService)ServiceLocator.find(IExcelFileService.class)).getSchemeDefination(info.getModuleName(), info.getBillType());
            this.billDefination = (BillDefination)srcbillDefination.clone();
            if (this.billDefination == null) {
                return null;
            }
            this.leftFields = new ArrayList<Field>();
            this.rightFields = new ArrayList<Field>();
            Record record1 = (Record)this.billDefination.getRecords().get(0);
            this.generateField(record1);
            FieldTreeWapper leftFieldTree = null;
            FieldTreeWapper rightFieldTree = null;
            ArrayList<Object> e = new ArrayList<Object>(1);
            e.add(null);
            if (this.leftFields.size() != 0) {
                this.leftFields = FieldTreeUtil.removeAll(this.leftFields, e);
                leftFieldTree = new FieldTreeWapper(this.leftFields.toArray(new Field[0]), false);
                map.put("leftdata", leftFieldTree.getTree());
            }
            if (this.rightFields.size() != 0) {
                this.rightFields = FieldTreeUtil.removeAll(this.rightFields, e);
                rightFieldTree = new FieldTreeWapper(this.rightFields.toArray(new Field[0]), true);
                map.put("rightdata", rightFieldTree.getTree());
            }
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return map;
    }

    private void generateField(Record record) {
        Field field1 = new Field();
        field1.setRefItem(record.getMeteDataID() != null ? record.getMeteDataID() : record.getName());
        field1.setDesc(record.getDisplayName());
        Record recordtemp = new Record();
        recordtemp.setMeteDataID("");
        recordtemp.setName("");
        field1.setRecord(recordtemp);
        this.leftFields.add(field1);
        this.rightFields.add(field1);
        List fields = record.getFields();
        ArrayList<Field> leftfieldlist = new ArrayList<Field>();
        ArrayList<Field> rightfieldlist = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getRefItem() == null) {
                if (field.isNullAllowed()) {
                    leftfieldlist.add(field);
                    continue;
                }
                rightfieldlist.add(field);
                continue;
            }
            try {
                Record childrecord = this.billDefination.getRecordByMetaDataID(field.getRefFieldItem());
                this.generateField(childrecord);
            }
            catch (SwapException e) {
                ExceptionUtils.wrapException((Throwable)e);
            }
        }
        if (leftfieldlist.size() > 0) {
            this.leftFields.addAll(leftfieldlist);
        } else {
            this.leftFields.remove(field1);
        }
        if (rightfieldlist.size() > 0) {
            this.rightFields.addAll(rightfieldlist);
        } else {
            this.rightFields.remove(field1);
        }
    }
}

