/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.docview.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.docview.IDocViewListService;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.web.fip.docview.action.DocViewGridConvertUtil;

public class DocViewRefreshAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        String parameter = request.read();
        IJson json = JsonFactory.create();
        Map param = (Map)json.fromJson(parameter, HashMap.class);
        String pagecode = (String)param.get("pagecode");
        String pk_org = (String)param.get("pk_org");
        String node_type = (String)param.get("node_type");
        String desdocid = (String)param.get("desdocid");
        String callflag = (String)param.get("callflag");
        String pk = (String)param.get("pk");
        String org_type = (String)param.get("org_type");
        if ("group".equals(node_type)) {
            pk_org = SessionContext.getInstance().getClientInfo().getPk_group();
        }
        try {
            return DocViewRefreshAction.refresh(pk_org, pagecode, desdocid, callflag, pk, org_type);
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }

    public static Object refresh(String pk_org, String pagecode, String desdocTypeID, String callflag, String pk, String orgType) throws BusinessException {
        if (pk_org == null || "".equals(pk_org.trim()) || desdocTypeID == null || "".equals(desdocTypeID.trim())) {
            return null;
        }
        String condition = "pk_org='" + pk_org + "' and desdocid='" + desdocTypeID + "' ";
        if (orgType != null && !"~".equals(orgType) && !"".equals(orgType.trim())) {
            condition = condition + "and orgtype='" + orgType + "' ";
        }
        if (callflag != null && callflag.equals("classdef")) {
            condition = "pk_classview='" + pk + "'";
        }
        try {
            Collection viewListVOs = ((IDocViewListService)ServiceLocator.find(IDocViewListService.class)).queryByWhere(condition);
            if (viewListVOs == null || viewListVOs.size() < 1) {
                return null;
            }
            Grid docViewGrid = DocViewGridConvertUtil.toGridForDocView(viewListVOs, desdocTypeID, "fip_docview_b");
            Grid srcDocGroupGrid = DocViewGridConvertUtil.toGridForSrcDocGroup(viewListVOs, "fip_srcdocgroup");
            Grid docViewListGrid = DocViewGridConvertUtil.toGridForDocViewList(viewListVOs, "fip_docview");
            BillGrid bgrid = new BillGrid();
            bgrid.setHead(docViewListGrid);
            bgrid.setBody(docViewGrid);
            bgrid.setPageid(pagecode);
            Translator translator = new Translator();
            translator.translate(bgrid);
            ArrayList<Grid> grids = new ArrayList<Grid>();
            grids.add(docViewListGrid);
            grids.add(docViewGrid);
            grids.add(srcDocGroupGrid);
            return grids;
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }
}

