/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.docview.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nc.vo.fip.docview.DocViewListVO;
import nc.vo.fip.docview.DocViewVO;
import nc.vo.fip.docview.SrcDocGroupVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.ArrayUtils;
import nccloud.dto.fip.docview.DocTranslateDTO;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.docview.IDocViewListQuery;

public class DocViewGridConvertUtil {
    public static Grid toGridForDocViewList(Collection<DocViewListVO> viewListVOs, String areacode) throws BusinessException {
        HashSet<String> orgbooks = new HashSet<String>();
        HashSet<String> docIDs = new HashSet<String>();
        for (DocViewListVO vo : viewListVOs) {
            orgbooks.add(vo.getPk_setorg1());
            docIDs.add(vo.getDesdocid());
            Object srcNames = "";
            if (ArrayUtils.isNotEmpty((Object[])vo.getSrcdocgroup())) {
                for (SrcDocGroupVO groupVO : vo.getSrcdocgroup()) {
                    docIDs.add(groupVO.getPk_srcdocid());
                    srcNames = "".equals(srcNames) ? groupVO.getPk_srcdocid() : (String)srcNames + "," + groupVO.getPk_srcdocid();
                }
            }
            vo.setSrcdocname((String)srcNames);
            vo.setSrcdocobj(null);
            vo.setViewobj(null);
            vo.setSrcdocgroup(null);
            vo.setClassviews(null);
        }
        Object[] infos = ((IDocViewListQuery)ServiceLocator.find(IDocViewListQuery.class)).queryDocViewListInfos(orgbooks.toArray(new String[0]), docIDs.toArray(new String[0]));
        HashMap orgbookMap = infos != null ? (HashMap)infos[0] : null;
        HashMap beanMap = infos != null ? (HashMap)infos[1] : null;
        GridConvertor convertor = new GridConvertor();
        Grid grid = convertor.toGrid(areacode, (Object[])viewListVOs.toArray(new DocViewListVO[0]));
        for (Row row : grid.getModel().getRows()) {
            Object[] srcIDs;
            Cell cell;
            if (row.getValues().get("pk_setorg1") != null) {
                cell = (Cell)row.getValues().get("pk_setorg1");
                String pk_setorg1 = cell.getValue() == null ? null : cell.getValue().toString();
                String bookName = orgbookMap != null ? (String)orgbookMap.get(pk_setorg1) : pk_setorg1;
                cell.setDisplay(bookName);
                row.getValues().put("pk_setorg1", cell);
            }
            if (row.getValues().get("desdocid") != null) {
                cell = (Cell)row.getValues().get("desdocid");
                String desdocid = cell.getValue() == null ? null : cell.getValue().toString();
                String descdocName = beanMap != null ? (String)beanMap.get(desdocid) : desdocid;
                cell.setDisplay(descdocName);
                row.getValues().put("desdocid", cell);
            }
            if (row.getValues().get("srcdocname") == null) continue;
            cell = (Cell)row.getValues().get("srcdocname");
            String srcdocname = cell.getValue() == null ? null : cell.getValue().toString();
            Object displayName = "";
            Object[] objectArray = srcIDs = srcdocname != null ? srcdocname.split(",") : null;
            if (ArrayUtils.isNotEmpty((Object[])srcIDs)) {
                for (Object id : srcIDs) {
                    String docName = beanMap != null ? (String)beanMap.get(id) : "";
                    displayName = "".equals(displayName) ? docName : (String)displayName + "," + docName;
                }
            }
            cell.setDisplay((String)displayName);
            row.getValues().put("srcdocname", cell);
        }
        return grid;
    }

    public static Grid toGridForDocView(Collection<DocViewListVO> viewListVOs, String desdocTypeID, String areacode) throws BusinessException {
        ArrayList<DocTranslateDTO> params = new ArrayList<DocTranslateDTO>();
        HashMap<String, Set> paraMap = new HashMap<String, Set>();
        HashMap<String, String> docNameMap = new HashMap();
        HashMap<String, String> srcdocIdMap = new HashMap<String, String>();
        ArrayList<DocViewVO> viewVOs = new ArrayList<DocViewVO>();
        for (DocViewListVO vo : viewListVOs) {
            Object srcNames = "";
            if (vo.getClassviews() != null && vo.getClassviews().length > 0) {
                viewVOs.addAll(Arrays.asList(vo.getClassviews()));
            }
            if (vo.getSrcdocgroup() == null || vo.getSrcdocgroup().length <= 0) continue;
            for (SrcDocGroupVO groupVO : vo.getSrcdocgroup()) {
                srcNames = "".equals(srcNames) ? groupVO.getPk_srcdocid() : (String)srcNames + "," + groupVO.getPk_srcdocid();
            }
            srcdocIdMap.put(vo.getPk_classview(), (String)srcNames);
        }
        GridConvertor convertor = new GridConvertor();
        Grid grid = null;
        if (!viewVOs.isEmpty()) {
            grid = convertor.toGrid(areacode, (Object[])viewVOs.toArray(new DocViewVO[0]));
            for (DocViewVO docViewVO : viewVOs) {
                String pk_classview = docViewVO.getPk_classview();
                String[] stringArray = srcdocIdMap.get(pk_classview) != null ? ((String)srcdocIdMap.get(pk_classview)).split(",") : null;
                Set desDocValues = paraMap.computeIfAbsent(desdocTypeID, k -> new HashSet());
                if (docViewVO.getDesdocvalue() != null) {
                    desDocValues.add(docViewVO.getDesdocvalue());
                }
                if (stringArray == null) continue;
                String factorvalue = "factorvalue";
                for (int i = 0; i < stringArray.length; ++i) {
                    Set pks = paraMap.computeIfAbsent(stringArray[i], k -> new HashSet());
                    String fieldName = factorvalue + (i + 1);
                    if (docViewVO.getAttributeValue(fieldName) == null) continue;
                    pks.add((String)docViewVO.getAttributeValue(fieldName));
                }
            }
            for (Map.Entry entry : paraMap.entrySet()) {
                String id = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                if (set == null || set.isEmpty()) continue;
                DocTranslateDTO dto = new DocTranslateDTO();
                dto.setId(id);
                dto.setPks(set);
                params.add(dto);
            }
            if (!params.isEmpty()) {
                docNameMap = ((IDocViewListQuery)ServiceLocator.find(IDocViewListQuery.class)).getDocNameByPKForShow(params.toArray(new DocTranslateDTO[0]));
            }
            for (Iterator<Object> iterator : grid.getModel().getRows()) {
                DocViewGridConvertUtil.displayDesDocvalue(iterator, docNameMap, desdocTypeID);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 1, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 2, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 3, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 4, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 5, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 6, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 7, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 8, docNameMap, srcdocIdMap);
                DocViewGridConvertUtil.displayFactorvalue(iterator, 9, docNameMap, srcdocIdMap);
            }
        }
        return grid;
    }

    private static void displayFactorvalue(Row row, int i, Map<String, String> docNameMap, Map<String, String> srcdocIdMap) {
        String[] srcDocIDs;
        String factorvalue;
        String fieldName = "factorvalue" + i;
        Cell cell_factorvalue = (Cell)row.getValues().get(fieldName);
        Cell cell_fk = (Cell)row.getValues().get("pk_classview");
        String pk_classview = cell_fk.getValue().toString();
        String string = factorvalue = cell_factorvalue.getValue() == null ? "" : cell_factorvalue.getValue().toString();
        if ("".equals(factorvalue)) {
            return;
        }
        String[] stringArray = srcDocIDs = srcdocIdMap.get(pk_classview) != null ? srcdocIdMap.get(pk_classview).split(",") : null;
        if (srcDocIDs == null || srcDocIDs.length < i) {
            return;
        }
        String docID = srcDocIDs[i - 1];
        String key = docID + factorvalue;
        String displayName = docNameMap.get(key);
        if (displayName == null) {
            displayName = factorvalue;
        }
        if ("BS000010000100001032".equals(docID)) {
            cell_factorvalue.setValue((Object)"Y".equals(factorvalue));
        }
        cell_factorvalue.setDisplay(displayName);
        row.getValues().put(fieldName, cell_factorvalue);
    }

    private static void displayDesDocvalue(Row row, Map<String, String> docNameMap, String desdocID) {
        String desdocvalue;
        String fieldName = "desdocvalue";
        Cell cell_desdocvalue = (Cell)row.getValues().get(fieldName);
        String string = desdocvalue = cell_desdocvalue.getValue() == null ? "" : cell_desdocvalue.getValue().toString();
        if ("".equals(desdocvalue)) {
            return;
        }
        String key = desdocID + desdocvalue;
        String displayName = docNameMap.get(key);
        if (displayName == null) {
            displayName = desdocvalue;
        }
        cell_desdocvalue.setDisplay(displayName);
        row.getValues().put(fieldName, cell_desdocvalue);
    }

    public static void displayDocvalue(Row row, String fieldName) {
        String desdocvalue;
        Cell cell_docvalue = (Cell)row.getValues().get(fieldName);
        String string = desdocvalue = cell_docvalue.getValue() == null ? "" : cell_docvalue.getValue().toString();
        if (desdocvalue != null) {
            String[] desInfos = desdocvalue.split(":");
            if (desInfos.length < 2 || desInfos[0] == null || desInfos[1] == null) {
                cell_docvalue.setValue(null);
                cell_docvalue.setDisplay(null);
            } else {
                cell_docvalue.setValue((Object)desInfos[0]);
                cell_docvalue.setDisplay(desInfos[1]);
            }
            row.getValues().put(fieldName, cell_docvalue);
        }
    }

    public static Grid toGridForSrcDocGroup(Collection<DocViewListVO> viewListVOs, String areacode) throws BusinessException {
        ArrayList<SrcDocGroupVO> srcDocGroupVOs = new ArrayList<SrcDocGroupVO>();
        for (DocViewListVO vo : viewListVOs) {
            if (vo.getSrcdocgroup() == null || vo.getSrcdocgroup().length <= 0) continue;
            srcDocGroupVOs.addAll(Arrays.asList(vo.getSrcdocgroup()));
        }
        GridConvertor convertor = new GridConvertor();
        Grid grid = null;
        if (!srcDocGroupVOs.isEmpty()) {
            grid = convertor.toGrid(areacode, (Object[])srcDocGroupVOs.toArray(new SrcDocGroupVO[0]));
        }
        return grid;
    }
}

