/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.docview.action;

import java.util.ArrayList;
import java.util.List;
import nc.itf.fip.docview.IDocViewListService;
import nc.vo.bd.meta.BatchOperateVO;
import nc.vo.fip.docview.DocViewListVO;
import nc.vo.fip.docview.DocViewVO;
import nc.vo.fip.docview.SrcDocGroupVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.pub.BusinessException;
import nc.vo.pub.SuperVO;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.fip.docview.DocViewParamDTO;
import nccloud.dto.fip.docview.DocViewParamVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.docview.action.DocViewGridConvertUtil;
import nccloud.web.fip.docview.action.DocViewRefreshAction;

public class DocViewBatchSaveAction
implements ICommonAction {
    public static String OPT_CHANGE = "change";

    public Object doAction(IRequest request) {
        String parameter = request.read();
        IJson json = JsonFactory.create();
        DocViewParamDTO param = (DocViewParamDTO)json.fromJson(parameter, DocViewParamDTO.class);
        String pagecode = param.getPagecode();
        String callRange = param.getCallRange() == null ? "" : param.getCallRange();
        DocViewParamVO[] params = param.getObjs();
        String desdocid = param.getDesdocid();
        String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
        BatchOperateVO operateVO = new BatchOperateVO();
        ArrayList<DocViewListVO> addObjs = new ArrayList<DocViewListVO>();
        ArrayList<DocViewListVO> delObjs = new ArrayList<DocViewListVO>();
        ArrayList<DocViewListVO> updObjs = new ArrayList<DocViewListVO>();
        String pk_org = "";
        block7: for (DocViewParamVO vo : params) {
            DocViewListVO docViewListVO = vo.getDocViewListVO();
            docViewListVO.setPk_group(pk_group);
            docViewListVO.setOrgtype(docViewListVO.getOrgtype() == null || docViewListVO.getOrgtype().trim().isEmpty() ? "~" : docViewListVO.getOrgtype());
            List docViewVOs = this.filterVOs((SuperVO[])vo.getDocViewListVO().getClassviews());
            List srcDocGroupVOs = this.filterVOs((SuperVO[])vo.getDocViewListVO().getSrcdocgroup());
            if (docViewVOs != null && !docViewVOs.isEmpty()) {
                for (DocViewVO dv : docViewVOs) {
                    for (int j = 1; j < 10; ++j) {
                        SrcDocGroupVO srcDoc = null;
                        if (srcDocGroupVOs != null && !srcDocGroupVOs.isEmpty() && srcDocGroupVOs.size() > j - 1 && srcDocGroupVOs.get(j - 1) != null) {
                            srcDoc = (SrcDocGroupVO)srcDocGroupVOs.get(j - 1);
                        }
                        if ("".equals(dv.getAttributeValue("factorvalue" + j))) {
                            dv.setAttributeValue("factorvalue" + j, null);
                            continue;
                        }
                        if (srcDoc == null || !"BS000010000100001032".equals(srcDoc.getPk_srcdocid())) continue;
                        dv.setAttributeValue("factorvalue" + j, (Object)("true".equals(dv.getAttributeValue("factorvalue" + j)) ? "Y" : "N"));
                    }
                }
                docViewListVO.setClassviews(docViewVOs.toArray(new DocViewVO[0]));
            } else {
                docViewListVO.setClassviews(null);
            }
            if (srcDocGroupVOs != null && !srcDocGroupVOs.isEmpty()) {
                docViewListVO.setSrcdocgroup(srcDocGroupVOs.toArray(new SrcDocGroupVO[0]));
            } else {
                docViewListVO.setSrcdocgroup(null);
            }
            this.setViewNameNull(docViewListVO);
            pk_org = docViewListVO.getPk_org();
            switch (docViewListVO.getStatus()) {
                case 2: {
                    addObjs.add(docViewListVO);
                    continue block7;
                }
                case 1: {
                    updObjs.add(docViewListVO);
                    continue block7;
                }
                case 3: {
                    delObjs.add(docViewListVO);
                    continue block7;
                }
            }
        }
        operateVO.setAddObjs((Object[])addObjs.toArray(new DocViewListVO[0]));
        operateVO.setUpdObjs((Object[])updObjs.toArray(new DocViewListVO[0]));
        operateVO.setDelObjs((Object[])delObjs.toArray(new DocViewListVO[0]));
        try {
            BatchOperateVO batchVO = ((IDocViewListService)ServiceLocator.find(IDocViewListService.class)).batchSave(operateVO);
            if (OPT_CHANGE.equals(callRange)) {
                DocViewListVO[] adds = batchVO.getAddObjs() == null ? null : (DocViewListVO[])batchVO.getAddObjs();
                DocViewListVO[] ups = batchVO.getUpdObjs() == null ? null : (DocViewListVO[])batchVO.getUpdObjs();
                DocViewListVO returnVO = null;
                if (adds != null && adds.length > 0) {
                    returnVO = adds[0];
                }
                if (ups != null && ups.length > 0) {
                    returnVO = ups[0];
                }
                if (returnVO != null) {
                    ArrayList<DocViewListVO> viewListVOs = new ArrayList<DocViewListVO>();
                    viewListVOs.add(returnVO);
                    return DocViewGridConvertUtil.toGridForDocView(viewListVOs, desdocid, "fip_docview_b");
                }
            } else {
                return DocViewRefreshAction.refresh(pk_org, pagecode, desdocid, null, null, params[0].getDocViewListVO().getOrgtype());
            }
            return null;
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }

    private void setViewNameNull(DocViewListVO docViewListVO) {
        if (docViewListVO == null) {
            return;
        }
        Object[] enableLangVOs = MultiLangContext.getInstance().getEnableLangVOs();
        if (ArrayUtils.isNotEmpty((Object[])enableLangVOs)) {
            for (Object lang : enableLangVOs) {
                String name;
                int seq = lang.getLangseq();
                Object index = "";
                if (seq != 1) {
                    index = "" + seq;
                }
                if (!StringUtils.isBlank((CharSequence)(name = (String)docViewListVO.getAttributeValue("viewname" + (String)index)))) continue;
                docViewListVO.setAttributeValue("viewname" + (String)index, null);
            }
        }
    }

    private <T extends SuperVO> List<T> filterVOs(T[] vos) {
        if (vos == null || vos.length < 1) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T vo : vos) {
            if (3 == vo.getStatus()) continue;
            result.add(vo);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

