/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.docconvertmap.action;

import nc.vo.fip.docmap.DocMapVO;
import nccloud.dto.fip.PageQueryDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingPagingService;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;

public class QueryDocmapAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            String str = request.read();
            IJson json = JsonFactory.create();
            Grid result = null;
            AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(str, AccountingQueryPageInfo.class);
            DocMapVO vo = new DocMapVO();
            String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            vo.setPk_group(pk_group);
            if (info.getAllpks() == null) {
                Object[] currentHeadVOs;
                Integer pageSize = info.getPageInfo().getPageSize();
                Integer pageIndex = info.getPageInfo().getPageIndex();
                AccountingPagingService service = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
                PageQueryDTO pageResult = service.queryWebPageBillPksByWhere(vo, pageSize.intValue());
                String[] pks = pageResult == null ? null : pageResult.getAllPKs();
                Object[] objectArray = currentHeadVOs = pageResult == null ? null : pageResult.getCurrentHeadVOs();
                if (pageResult == null || pks == null || pks.length == 0 || currentHeadVOs == null || currentHeadVOs.length == 0) {
                    return null;
                }
                GridOperator operator = new GridOperator(info.getPagecode());
                result = operator.toGrid(currentHeadVOs);
                result.getModel().setAllpks(pks);
                PageInfo pageInfo = new PageInfo();
                pageInfo.setTotal(pks.length);
                pageInfo.setPageSize(pageSize.intValue());
                pageInfo.setPageIndex(pageIndex.intValue());
                pageInfo.setTotalPage(this.getTotalPage(pageInfo, pks.length));
                result.getModel().setPageinfo(pageInfo);
            } else {
                AccountingPagingService service = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
                Object[] vos = service.queryDocmapsByPksWhere(info.getAllpks());
                if (vos.length == 0) {
                    return null;
                }
                GridOperator operator = new GridOperator(info.getPagecode());
                result = operator.toGrid(vos);
            }
            Translator translator = new Translator();
            translator.translate(result);
            return result;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }

    private int getTotalPage(PageInfo pageInfo, int len) {
        int size = pageInfo.getPageSize();
        int total = 0;
        total = len % size == 0 ? len / size : len / size + 1;
        return total;
    }
}

