/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.classdefreport.action;

import nc.itf.fip.report.IFipReport;
import nc.vo.fip.report.ClassDefReportVO;
import nccloud.dto.fip.PageQueryDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridFormulaHandler;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingPagingService;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;

public class QueryClassdefreportAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            String str = request.read();
            IJson json = JsonFactory.create();
            Grid result = null;
            AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(str, AccountingQueryPageInfo.class);
            String wherepart = this.getSearchSql(info);
            Integer pageSize = info.getPageInfo().getPageSize();
            Integer pageIndex = info.getPageInfo().getPageIndex();
            if (info.getAllpks() == null) {
                Object[] currentHeadVOs;
                service = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
                PageQueryDTO pageResult = service.queryWebPageBillPksByWhere(wherepart, pageSize.intValue());
                String[] pks = pageResult == null ? null : pageResult.getAllPKs();
                Object[] objectArray = currentHeadVOs = pageResult == null ? null : pageResult.getCurrentHeadVOs();
                if (pageResult == null || pks == null || pks.length == 0 || currentHeadVOs == null || currentHeadVOs.length == 0) {
                    return null;
                }
                GridOperator operator = new GridOperator(info.getPagecode());
                result = operator.toGrid(currentHeadVOs);
                result.getModel().setAllpks(pks);
                PageInfo pageInfo = new PageInfo();
                pageInfo.setTotal(pks.length);
                pageInfo.setPageSize(pageSize.intValue());
                pageInfo.setPageIndex(pageIndex.intValue());
                pageInfo.setTotalPage(this.getTotalPage(pageInfo, pks.length));
                result.getModel().setPageinfo(pageInfo);
            } else {
                service = (IFipReport)ServiceLocator.find(IFipReport.class);
                ClassDefReportVO[] vos = service.queryClassDefReport(wherepart);
                if (vos.length == 0) {
                    return null;
                }
                int size = pageIndex * pageSize;
                int length = vos.length - size - pageSize > 0 ? pageSize : vos.length - size;
                Object[] newvos = new ClassDefReportVO[length];
                for (int i = 0; i < length; ++i) {
                    newvos[i] = vos[size + i];
                }
                GridOperator operator = new GridOperator(info.getPagecode());
                result = operator.toGrid(newvos);
            }
            GridFormulaHandler gfh = new GridFormulaHandler(result);
            gfh.handleLoadFormula();
            Translator translator = new Translator();
            translator.translate(result);
            return result;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }

    private int getTotalPage(PageInfo pageInfo, int len) {
        int size = pageInfo.getPageSize();
        int total = 0;
        total = len % size == 0 ? len / size : len / size + 1;
        return total;
    }

    public String getSearchSql(AccountingQueryPageInfo info) {
        Object sqlwhere = "1=1";
        if (info.getConditions() != null && info.getConditions().size() > 0) {
            for (int i = 0; i < info.getConditions().size(); ++i) {
                String pieceSql;
                Conditions element = (Conditions)info.getConditions().get(i);
                Object field = null;
                if (element.getField().equals("src_system")) {
                    field = element.getValue().getFirstvalue();
                    pieceSql = "(" + this.addSlash((String)field) + ")";
                    sqlwhere = "src_system in " + pieceSql;
                    continue;
                }
                if (element.getField().equals("des_billtype")) {
                    field = element.getValue().getFirstvalue();
                    if (field != null && ((String)field).contains("DL")) {
                        field = "DL," + ((String)field).replaceAll("DL", "C0,NRESA03,CCA02,ICA03");
                    }
                    pieceSql = "(" + this.addSlash((String)field) + ")";
                    sqlwhere = (String)sqlwhere + " and  des_billtype in" + pieceSql;
                    continue;
                }
                if (element.getField().equals("displaycode")) {
                    field = element.getValue().getFirstvalue();
                    sqlwhere = (String)sqlwhere + "   and    displaycode = '" + (String)field + "'";
                    continue;
                }
                if (!element.getField().equals("pk_org")) continue;
                field = element.getValue().getFirstvalue();
                String[] pkorgs = ((String)field).split(",");
                Object pieceSql2 = "(select  pk_org from org_orgs  where 11=11 and ( ";
                boolean flag = false;
                for (String pkorg : pkorgs) {
                    if (flag) continue;
                    pieceSql2 = (String)pieceSql2 + " org_orgs.innercode like '" + pkorg + "%' )";
                }
                pieceSql2 = (String)pieceSql2 + " )";
                sqlwhere = (String)sqlwhere + " and  pk_org in " + (String)pieceSql2;
            }
        }
        return sqlwhere;
    }

    public String addSlash(String field) {
        Object afterfield = "";
        if (!"".equals(field) || field != null) {
            String[] fdarr;
            for (String string : fdarr = field.split(",")) {
                afterfield = (String)afterfield + "'" + string + "',";
            }
        }
        int index = ((String)afterfield).lastIndexOf(",");
        return ((String)afterfield).substring(0, index);
    }
}

