/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.classdefglobal.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import nc.itf.fip.classdef.IClassDefService;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class ClassdefCopyByBillAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            String json = request.read();
            JsonObject jb = (JsonObject)JsonFactory.create().fromJson(json, JsonObject.class);
            JsonArray jArr = jb.getAsJsonArray("datas");
            String[] pk_classdefs = new String[jArr.size()];
            for (int i = 0; i < jArr.size(); ++i) {
                JsonObject obj = jArr.get(i).getAsJsonObject();
                JsonObject data = obj.get("data").getAsJsonObject();
                JsonObject values = data.get("values").getAsJsonObject();
                JsonObject pkObj = values.get("pk_classdef").getAsJsonObject();
                if (pkObj == null || pkObj.get("value").isJsonNull()) continue;
                pk_classdefs[i] = pkObj.get("value").getAsString();
            }
            String desBillType = jb.get("des_billtype").getAsString();
            if (StringUtils.isEmpty((CharSequence)desBillType)) {
                throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017pub_0", "01017pub-2-0007"));
            }
            IClassDefService service = (IClassDefService)ServiceLocator.find(IClassDefService.class);
            service.copyByBill(desBillType, pk_classdefs);
        }
        catch (BusinessException e) {
            ExceptionUtils.wrapException((Throwable)e);
        }
        return null;
    }
}

