/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.billmapping.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.billmapping.IFipBillMappingService;
import nc.vo.fip.billmapping.BillMappingVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class QueryBillmappingAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            String str = request.read();
            IJson json = JsonFactory.create();
            QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(str, QueryTemplateInfo4Web.class);
            String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            BillMappingVO vo = new BillMappingVO();
            if (info.getOid() != null) {
                vo.setPk_billtype(info.getOid());
            }
            vo.setPk_group(pk_group);
            Object[] billMappingvos = ((IFipBillMappingService)ServiceLocator.find(IFipBillMappingService.class)).queryBillMappingByVO(vo);
            if (billMappingvos == null || billMappingvos.length == 0) {
                return null;
            }
            int currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq();
            for (BillMappingVO billMappingVO : billMappingvos) {
                if (currLangIndex == 1) {
                    billMappingVO.setExplanation(billMappingVO.getExplanation());
                    continue;
                }
                if (billMappingVO.getAttributeValue("explanation" + currLangIndex) != null) {
                    billMappingVO.setExplanation((String)billMappingVO.getAttributeValue("explanation" + currLangIndex));
                }
                if (billMappingVO.getAttributeValue("attrname" + currLangIndex) == null) continue;
                billMappingVO.setAttrname(billMappingVO.getAttributeValue("attrname" + currLangIndex).toString());
            }
            GridConvertor convertor1 = new GridConvertor();
            GridConvertor convertor2 = new GridConvertor();
            Grid grid1 = convertor1.toGrid("billmapping", billMappingvos);
            BillMappingVO vo2 = new BillMappingVO();
            vo2.setAttrcode(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170202", "1101702020002"));
            Object[] objectArray = new BillMappingVO[]{vo2};
            Grid grid2 = convertor2.toGrid("billmapping-tx", objectArray);
            HashSet<String> set = new HashSet<String>();
            Row[] rows = grid1.getModel().getRows();
            if (rows != null && rows.length > 0) {
                for (Row row : rows) {
                    Cell cell = (Cell)row.getValues().get("entity_attr");
                    if (cell == null || cell.getValue() == null) continue;
                    set.add((String)cell.getValue());
                }
                Map map = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertBillItemData(set, pk_group, "TX01");
                for (Row row : rows) {
                    Cell cell = (Cell)row.getValues().get("entity_attr");
                    if (cell == null || cell.getValue() == null || map.get(cell.getValue()) == null) continue;
                    cell.setDisplay((String)map.get(cell.getValue()));
                }
            }
            BillGrid bgrid = new BillGrid();
            bgrid.setHead(grid1);
            bgrid.setBody(grid2);
            bgrid.setTempletid("1001Z3100000000075R2");
            bgrid.setPageid(info.getPageCode());
            Translator translator = new Translator();
            translator.translate(bgrid);
            ArrayList<Grid> grids = new ArrayList<Grid>();
            grids.add(grid1);
            grids.add(grid2);
            return grids;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }
}

